/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef ENIROGUICONFIG_H
#define ENIROGUICONFIG_H

#include <QtGui/QLineEdit>
#include <QtGui/QVBoxLayout>
#include <QtGui/QLabel>
#include "buttonselector.h"
#include "enirocoreconfig.h"
#include "sourceguiconfig.h"

class EniroGuiConfig : public SourceGuiConfig, public EniroCoreConfig
{

    Q_OBJECT

public:
    EniroGuiConfig(QWidget* parent = 0);
    virtual ~EniroGuiConfig();
    virtual void save();

private slots:
    void siteChanged(unsigned int index, QString const& text, QVariant const& value);

private:
    void loadLayout(QString const& site);
    QVBoxLayout* layout_;
    QLineEdit* usernameInput_;
    QLineEdit* passwordInput_;
    ButtonSelector* siteSelector_;
    QLabel* usernameLabel_;
    QLabel* passwordLabel_;

};

#endif
