/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef LOGWINDOW_H
#define LOGWINDOW_H

#include <QtGui/QMainWindow>
#include <QtGui/QListWidget>
#include "source.h"
#include "listwidget.h"
#include "cache.h"

class LogWindow : public QMainWindow
{
    Q_OBJECT

public:
    static int const LOG_MAX_ITEMS = 50;
    LogWindow(QWidget* parent = 0);

signals:
    void logItemSelected(Source::Result const& result);

protected:
    void setVisible(bool visible);

private slots:
    void itemClicked(int index);
    void clearLog();

private:
    QWidget* createWidget(Cache::LogDetails const& details);
    void loadLogItems();
    ListWidget* list_;
};

#endif
