/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DETAILWINDOW_H
#define DETAILWINDOW_H

#include <QtGui/QMainWindow>
#include <QtGui/QVBoxLayout>
#include <QtGui/QDialog>
#include <QtGui/QLineEdit>
#include <QtGui/QWidget>
#include <QMaemo5ValueButton>
#include "searchdialog.h"
#include "eniro.h"

class DetailWindow : public QMainWindow
{
    Q_OBJECT

public:

    DetailWindow(QWidget* parent = 0);

public slots:
    void loadData(Source::Result const& details);

private slots:
    void makeCall();
    void showAddToContactsDialog();
    void addToContacts();
    void copyToClipboard();
    void sendSMS();
    void openMaps();

private:
    void getDetails(QString& street, QString& streetNumber,
                    QString& zip, QString& city);
    QWidget* area_;
    QVBoxLayout* layout_;
    QMaemo5ValueButton* nameButton_;
    QMaemo5ValueButton* streetButton_;
    QMaemo5ValueButton* cityButton_;
    QMaemo5ValueButton* numberButton_;
    QDialog* addDialog_;
    QLineEdit* addContactInput_;
    QString country_;


};

#endif
