/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SEARCHDIALOG_H
#define SEARCHDIALOG_H

#include <QtCore/QString>
#include <QtGui/QDialog>
#include <QtGui/QWidget>
#include <QtGui/QLineEdit>
#include <QMaemo5ListPickSelector>
#include "buttonselector.h"

class SearchDialog : public QDialog
{
    Q_OBJECT

public:

    struct SearchDetails
    {
        QString name;
        QString location;
        int type;
    };

    SearchDialog(QWidget* parent = 0);
    virtual void setVisible(bool visible);

signals:
    void search(SearchDialog::SearchDetails& details);

private slots:
    void searchPressed();

private:
    QLineEdit* numberInput_;
    QLineEdit* locationInput_;
    ButtonSelector* selector_;

};

#endif
