/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/QDebug>
#include "connectionselector.h"
#include "connectionmanager.h"

ConnectionSelector::ConnectionSelector(QString const& text, QWidget* parent):
ButtonSelector(text, parent), loaded_(false), gprsIndex_(0)
{
    addItems();
}

void ConnectionSelector::updateConnections()
{
    loaded_ = true;

    QVariant currentValue = value();

    addItems();

    ConnectionManager cm;

    QList<ConnectionManager::Connection> connections;

    if(cm.scanConnections(connections, ConnectionManager::GPRS) &&
       connections.size() > 0)
    {
        changeItem(gprsIndex_, connections.at(0).name, "gprs");
    }
    else
    {
        qDebug() << "Unable to scan network connections";
    }

    selectByValue(currentValue);

}

void ConnectionSelector::setVisible(bool visible)
{
    if(visible && !loaded_)
    {
        updateConnections();
    }

    ButtonSelector::setVisible(visible);
}

void ConnectionSelector::addItems()
{
    clear();

    addItem(tr("Use global setting"), "global");
    addItem(tr("WLAN connection"), "wlan");
    addItem(tr("GPRS connection"), "gprs");
    addItem(tr("Any connection"), "any");

    gprsIndex_ = 2;
}
