/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QPixmap>
#include "aboutdialog.h"

AboutDialog::AboutDialog(QWidget* parent): QDialog(parent)
{
    setWindowTitle(tr("About"));

    QHBoxLayout* mainLayout = new QHBoxLayout();
    QPixmap pixmap(":/icons/icon.png");
    QLabel* image = new QLabel;
    image->setPixmap(pixmap);
    mainLayout->addWidget(image, 0, Qt::AlignLeft);
    mainLayout->addSpacing(20);
    QLabel* text = new QLabel(QString::fromUtf8("<font size='4'><b>Jenirok</b></font><br>(c) 2010 Jesse Hakanen<br>Norwegian translation by Eirik Lindem and Jørgen Sogn<br>Swedish translation by Torbjörn Svangård<br><a href='http://jenirok.garage.maemo.org'>http://jenirok.garage.maemo.org</a>"));
    text->setOpenExternalLinks(true);
    mainLayout->addWidget(text, 10, Qt::AlignLeft);

    setLayout(mainLayout);
}
