/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtSql/QSqlQuery>
#include <QtSql/QSqlError>
#include <QtCore/QVariant>
#include <QtCore/QDebug>
#include "cache.h"
#include "db.h"
#include "settings.h"

Cache* Cache::instance_ = 0;

Cache::Cache()
{
}

int Cache::clear()
{
    bool connected = DB::connected();

    if(!connected)
    {
        DB::connect();
    }

    QSqlQuery query;
    int ret = -1;

    if(query.exec("DELETE FROM cache"))
    {
        ret = query.numRowsAffected();
    }

    if(!connected)
    {
        DB::disconnect();
    }

    return ret;
}
bool Cache::findItem(QString const& number, Source::Result& result)
{
    bool connected = DB::connected();

    if(!connected)
    {
        DB::connect();
    }

    QSqlQuery query;
    query.prepare("SELECT name, street, city FROM cache WHERE number = :number");
    query.bindValue(":number", number);

    bool ret = false;

    if(query.exec() && query.next())
    {
        result.number = number;
        result.name = query.value(0).toString();
        result.street = query.value(1).toString();
        result.city = query.value(2).toString();

        ret = true;
    }

    if(!connected)
    {
        DB::disconnect();
    }

    return ret;
}

bool Cache::addItem(Source::Result const& result)
{
    bool connected = DB::connected();

    if(!connected)
    {
        DB::connect();
    }

    bool ret = true;

    QSqlQuery query;

    query.prepare("INSERT INTO cache(number, name, street, city) VALUES(:number, :name, :street, :city)");
    query.bindValue(":number", result.number);
    query.bindValue(":name", result.name);
    query.bindValue(":street", result.street);
    query.bindValue(":city", result.city);


    if(!query.exec())
    {
        ret = false;
    }

    query.clear();

    QString cacheSize = Settings::instance()->get("cache_size");

    int cacheLimit = 0;

    // Delete old entries from cache
    if((cacheLimit = cacheSize.toInt()) > 0)
    {
        if(query.exec("SELECT COUNT(*) FROM cache") && query.next())
        {
            int itemsToDelete = query.value(0).toInt() - cacheLimit;

            for(int i = 0; i < itemsToDelete; i++)
            {
                query.clear();

                if(!query.exec("DELETE FROM cache WHERE id = (SELECT MIN(id) FROM cache)"))
                {
                    QSqlError error = query.lastError();
                    qDebug() << "Unable to delete old cache entries: " << error.text();
                    ret = false;
                }
            }
        }
        else
        {
            QSqlError error = query.lastError();
            qDebug() << "Unable to get count for cache entries: " << error.text();
            ret = false;
        }

    }

    if(!connected)
    {
        DB::disconnect();
    }

    return ret;

}

Cache& Cache::instance()
{
    if(!instance_)
    {
        instance_ = new Cache;
    }

    return *instance_;
}
