/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QDebug>
#include <QtGui/QLabel>
#include <QtGui/QVBoxLayout>
#include "sourceguiconfig.h"
#include "eniroguiconfig.h"
#include "emptyguiconfig.h"

SourceGuiConfig::SourceGuiConfig(QWidget* parent): QWidget(parent)
{
}

SourceGuiConfig::~SourceGuiConfig()
{
}

SourceGuiConfig* SourceGuiConfig::getGuiConfig(Source::SourceId id, QWidget* parent)
{
    switch(id)
    {
    case Source::ENIRO:
        return new EniroGuiConfig(parent);
        break;
    case Source::MOBIL1881:
        return new EmptyGuiConfig(parent); // No configuration
        break;
    default:
        qDebug() << "Unknown source id: " << id;
    }

    return 0;
}
