/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QObject>
#include <QtGui/QApplication>
#include "mainwindow.h"
#include "searchdialog.h"
#include "resultwindow.h"
#include "detailwindow.h"
#include "eniro.h"
#include "settings.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    Settings::instance()->loadLanguage(app);

    MainWindow window;
    ResultWindow results(&window);
    DetailWindow details(&results);

    window.show();

    QObject::connect(&window, SIGNAL(search(SearchDialog::SearchDetails&)),
                     &results, SLOT(search(SearchDialog::SearchDetails&)));

    QObject::connect(&results, SIGNAL(itemSelected(Source::Result const&)),
                     &details, SLOT(loadData(Source::Result const&)));

    return app.exec();
}
