/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QDebug>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLabel>
#include "eniroguiconfig.h"
#include "eniro.h"

EniroGuiConfig::EniroGuiConfig(QWidget* parent):
SourceGuiConfig(parent), EniroCoreConfig()
{
    load();

    QVBoxLayout* layout = new QVBoxLayout;

    QHBoxLayout* username = new QHBoxLayout;
    QHBoxLayout* password = new QHBoxLayout;

    QLabel* usernameLabel = new QLabel(tr("Eniro username"));
    usernameInput_ = new QLineEdit(getUsername());

    QLabel* passwordLabel = new QLabel(tr("Eniro password"));
    passwordInput_ = new QLineEdit(getPassword());
    passwordInput_->setEchoMode(QLineEdit::PasswordEchoOnEdit);

    QMap <Eniro::Site, Eniro::SiteDetails> sites = Eniro::getSites();

    siteSelector_ = new ButtonSelector(tr("Eniro site"), this);
    QString site = getSite();
    int i = 0;

    QMap <Eniro::Site, Eniro::SiteDetails>::const_iterator it;
    for(it = sites.begin(); it != sites.end(); it++)
    {
        QString name;

        switch(it.key())
        {
        case Eniro::FI:
            name = tr("Finnish");
            break;
        case Eniro::SE:
            name = tr("Swedish");
            break;
        case Eniro::DK:
            name = tr("Danish");
            break;
        default:
            qDebug() << "Unknown site";
            continue;

        }
        siteSelector_->addItem(name, it.value().id);

        if(it.value().id == site)
        {
            siteSelector_->setCurrentIndex(i);
        }

        i++;
    }

    username->addWidget(usernameLabel);
    username->addWidget(usernameInput_);
    password->addWidget(passwordLabel);
    password->addWidget(passwordInput_);

    layout->addLayout(username);
    layout->addLayout(password);
    layout->addWidget(siteSelector_);

    setLayout(layout);
}

EniroGuiConfig::~EniroGuiConfig()
{
}

void EniroGuiConfig::save()
{
    setUsername(usernameInput_->text());
    setPassword(passwordInput_->text());
    setSite(siteSelector_->value().toString());

    store();
}
