/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

/* Modifications done for Jenirok:
 *  All boxes changed to notifications
 *  Default timeout changed to 0
 *  Box hides itself on click instead of closing
 */

#ifndef InformationBox_H
#define InformationBox_H

#include <QtGui/QDialog>

class InformationBoxPrivate;

class InformationBox: public QDialog
{
    Q_OBJECT
    Q_PROPERTY(int timeout READ timeout WRITE setTimeout)

public:
    explicit InformationBox(QWidget *parent = 0);
    ~InformationBox();

    void setWidget(QWidget *widget);
    QWidget *widget() const;

    enum { NoTimeout = 0, DefaultTimeout = 0 };

    void setTimeout(unsigned int ms);
    int timeout() const;

signals:
    void clicked();

protected:
    void showEvent(QShowEvent *se);
    void timerEvent(QTimerEvent *te);
    void mousePressEvent(QMouseEvent *me);
    void paintEvent(QPaintEvent *pe);

protected:
    QScopedPointer<InformationBoxPrivate> d_ptr;

private:
    Q_DISABLE_COPY(InformationBox)
    Q_DECLARE_PRIVATE(InformationBox)
};

#endif // InformationBox_H
