/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef ENIRO_H
#define ENIRO_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <QtCore/QVector>
#include <QtCore/QSet>
#include <QtCore/QRegExp>
#include <QtCore/QUrl>
#include <QtCore/QTimerEvent>
#include <QtNetwork/QHttp>
#include "source.h"

class Eniro: public Source
{
    Q_OBJECT

public:

    enum Site {FI, SE, DK};

    struct SiteDetails
    {
        QString name;
        QString id;
    };

    static const int SITE_COUNT = 3;

    Eniro(QObject *parent = 0);
    ~Eniro();
    void login(QString const& username, QString const& password);
    void logout();
    void setSite(Site);
    virtual void search(Source::SearchDetails const& details);
    virtual void abort();
    static QMap<Site, SiteDetails> getSites();
    static Site stringToSite(QString const& str);

signals:
    void loginStatus(bool success);

private:

    Q_DISABLE_COPY(Eniro);

    struct NumberData
    {
        int searchId;
        int index;
    };

    struct SearchData
    {
        Source::SearchDetails details;
        QVector <Source::Result> results;
        unsigned int foundNumbers;
        unsigned int numbersTotal;
    };

    virtual void handleHttpData(int id, QByteArray const& data);
    virtual void handleHttpError(int id);
    QUrl createUrl(QString const& query, QString const& location);
    void loadResults(int id, QString const& data);
    void loadNumber(int id, QString const& data);
    void getNumberForResult(int id, int index, SearchDetails const& details);
    void emitRequestFinished(int key, SearchData* data, bool error);
    void timerEvent(QTimerEvent *t);

    Site site_;
    bool loggedIn_;
    QString username_;
    QString password_;
    int timerId_;
    typedef QMap <int, SearchData*> searchMap;
    typedef QMap <int, NumberData*> numberMap;
    searchMap pendingSearches_;
    numberMap pendingNumberRequests_;
    QSet <int> pendingLoginRequests_;
    static QRegExp numberCleaner_;
    static QRegExp tagStripper_;

};

#endif // ENIRO_H

