/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CONTACTMANAGER_H
#define CONTACTMANAGER_H

#include <QtCore/QLibrary>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVector>
#include <libebook/e-book.h>

class ContactManager
{
public:
    struct Name
    {
        QString firstname;
        QString surname;
    };

    struct Contact
    {
        Name name;
        QString number;
        QString street;
        QString zipCode;
        QString city;
        QString country;
    };

    ContactManager();
    ~ContactManager();
    bool addContact(Contact const& contact);
    bool numberExists(QString const& number);
    static void stringToName(QString const& strname, Name& name);

private:
    bool load();
    EBook* book_;
};

#endif
