/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtGui/QVBoxLayout>
#include <QtGui/QLabel>
#include "emptyguiconfig.h"

EmptyGuiConfig::EmptyGuiConfig(QWidget* parent):
SourceGuiConfig(parent), EmptyCoreConfig()
{
    QVBoxLayout* layout = new QVBoxLayout(this);
    QLabel* info = new QLabel(tr("Selected phonebook has no settings to configure."));
    info->setAlignment(Qt::AlignCenter);
    info->setWordWrap(true);
    layout->addWidget(info);
    setLayout(layout);
}

EmptyGuiConfig::~EmptyGuiConfig()
{
}

void EmptyGuiConfig::save()
{
}
