/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef ENIROCORECONFIG_H
#define ENIROCORECONFIG_H

#include <QtCore/QMap>
#include <QtCore/QString>
#include "sourcecoreconfig.h"

class EniroCoreConfig : public SourceCoreConfig
{

public:
    EniroCoreConfig();
    virtual ~EniroCoreConfig();
    virtual bool apply(Source* source);
    void store();
    virtual void getConfig(QMap<QString, QString>& config);
    virtual void loadFromConfig(QMap<QString, QString> const& config);
    virtual bool readyToSearch();

protected:
    void setUsername(QString const& username);
    void setPassword(QString const& password);
    void setSite(QString const& site);
    void load();
    QString getUsername() const;
    QString getPassword() const;
    QString getSite() const;

private:
    QMap<QString, QString> config_;
    bool loaded_;
};

#endif
