#ifndef MOBIL1881_H
#define MOBIL1881_H

#include <QtCore/QList>
#include <QtCore/QSet>
#include <QtCore/QVector>
#include <QtCore/QByteArray>
#include "source.h"

class Mobil1881 : public Source
{
public:
    Mobil1881(QObject* parent = 0);
    ~Mobil1881();
    virtual void abort();
    virtual void search(Source::SearchDetails const& details);

private:

    struct SearchData
    {
        QSet<int> searchIds;
        Source::SearchDetails details;
        QVector<Source::Result> results;
        int currentPage;
    };

    void addNumbers(SearchData* searchData, QString const& data, int index);
    void addOnlyNumber(SearchData* searchData, QString const& data, int index);
    bool formatResult(QString& name, QString& number, QString& street, QString& city, Source::Result& result);
    void emitRequestFinished(SearchData* data, bool error, int index);
    int sendQuery(Source::SearchDetails const& details, int page = 1);

    QList<SearchData*> pendingSearches_;

    Q_DISABLE_COPY(Mobil1881);
    virtual void handleHttpData(int id, QByteArray const& data);
    virtual void handleHttpError(int id);
};

#endif // MOBIL1881_H
