/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QtCore/QString>
#include <QCoreApplication>

class Settings;

class Settings
{
    Q_DECLARE_TR_FUNCTIONS(Settings)

public:
    static Settings* instance();
    static void close();
    bool set(QString const& name, QString const& value);
    QString get(QString const& name);
    QString getDefaultValue(QString const& name);
    bool reset();

private:
    Settings();
    static Settings* instance_;

};

#endif

