/**sequencer_track_view.c is part of JamMo.
License: GPLv2, read more from COPYING

First call this: sequencer_track_view_tune_width
And then sequencer_track_view_add_with_type(sequencerTrackViewTYpe)
 */
#include <glib-object.h>
#include <clutter/clutter.h>
#include <string.h>
#include <stdlib.h>
#include <tangle.h>


#include "../../meam/jammo-track.h"
#include "../../meam/jammo-editing-track.h"
#include "../../meam/jammo-instrument-track.h"
#include "../../meam/jammo-slider-track.h"
#include "../../meam/jammo-backing-track.h"
#include "../../meam/jammo-midi.h"
#include "../../meam/jammo-meam.h" //JAMMO_DURATION_INVALID

#include "../jammo-track-view.h"
#include "../jammo-miditrack-view.h"
#include "../jammo.h"
#include "../jammo-cursor.h"
#include "../save_helper.h"

#include "sequencer_track_view.h"
#include "sequencer.h"
#include "midi_editor.h"
#include "instrument_gui.h"
#include "jammer_view.h"

static int width_of_slot = 40;
static gfloat track_height = 50.0;



//We get these as parameters
static int number_of_slots = -1;


static SequencerTrackView *track_views[6] = {NULL};
static gint tracks_in_use = 0;

static gboolean pressed_sequencer_button_mute (TangleButton *tanglebutton, gpointer user_data);
static gboolean pressed_sequencer_button_volume (TangleButton *tanglebutton, gpointer user_data);
static gboolean pressed_sequencer_button_track_label (TangleButton *tanglebutton, gpointer data);

//We want toggle this up, when next is clicked
TangleButton* last_pressed_volume_button = NULL;

/*
 * Creates and returns SequencerTrackView struct
 */
static SequencerTrackView *sequencer_track_view_new(ClutterActor *label,
    ClutterActor *track_view, gint track_view_type, gboolean muted, gfloat current_volume) {

	ClutterActor* mute_button = tangle_button_new_selectable_with_background_actors (
     clutter_texture_new_from_file("/opt/jammo/sequencer/button_mute.png", NULL), /* normal */
     clutter_texture_new_from_file("/opt/jammo/sequencer/button_mute_pressed.png", NULL),  /* interactive */
     clutter_texture_new_from_file("/opt/jammo/sequencer/button_mute_pressed.png", NULL)); /* selected */
	clutter_actor_set_size(mute_button, track_height-4,track_height-4); //it is square. Four pixels marginal
	tangle_button_set_selected(TANGLE_BUTTON(mute_button),muted);

	//Button for volume is dynamic texture.
	//printf("current_volume : %f\n",current_volume);
	gfloat height_ = 36; //background_heigt - nub_height
	gfloat y = height_-current_volume*height_;
	//printf("y : %f\n",y);

	ClutterActor* dynamic_texture_for_button = tangle_widget_new();
	ClutterActor* back = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_background.png",NULL);
	ClutterActor* nub = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_button.png",NULL);
	tangle_widget_set_background_actor(TANGLE_WIDGET(dynamic_texture_for_button), back);
	tangle_widget_add(TANGLE_WIDGET(dynamic_texture_for_button), nub,NULL);
	clutter_actor_set_y(nub,y);

	ClutterActor* dynamic_texture_for_button_selected = tangle_widget_new();
	ClutterActor* back_selected = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_background.png",NULL);
	ClutterActor* nub_selected = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_button_selected.png",NULL);
	tangle_widget_set_background_actor(TANGLE_WIDGET(dynamic_texture_for_button_selected), back_selected);
	tangle_widget_add(TANGLE_WIDGET(dynamic_texture_for_button_selected), nub_selected,NULL);
	clutter_actor_set_y(nub_selected,y);

	ClutterActor* volume_button = tangle_button_new_selectable ();
	tangle_button_set_normal_background_actor(TANGLE_BUTTON(volume_button),dynamic_texture_for_button);
	tangle_button_set_selected_background_actor(TANGLE_BUTTON(volume_button),dynamic_texture_for_button_selected);


	clutter_actor_set_size(volume_button, track_height-4,track_height-4); //it is square. Four pixels marginal

	clutter_actor_set_height(label,track_height-4); //this is not square, so change oly height

	SequencerTrackView *view = malloc(sizeof(SequencerTrackView));
	view->control_panel = tangle_widget_new();
	view->track_view = track_view;
	view->track_type = track_view_type; //can this be checked inside meam-track (which is inside track_view)?

	tangle_widget_add(TANGLE_WIDGET(view->control_panel), label,NULL);
	tangle_widget_add(TANGLE_WIDGET(view->control_panel), mute_button,NULL);
	tangle_widget_add(TANGLE_WIDGET(view->control_panel), volume_button,NULL);

	gfloat x=0;
	clutter_actor_set_position(label, x, 0.0);
	x += 1 +  clutter_actor_get_width(label);

	clutter_actor_set_position(mute_button, x, 0.0);
	x += 1.0 + clutter_actor_get_width(mute_button);

	clutter_actor_set_position(volume_button, x, 0.0);

	g_signal_connect(CLUTTER_ACTOR(label), "clicked", G_CALLBACK(pressed_sequencer_button_track_label), view);
	g_signal_connect(CLUTTER_ACTOR(mute_button), "clicked", G_CALLBACK(pressed_sequencer_button_mute), view);
	g_signal_connect(CLUTTER_ACTOR(volume_button), "clicked", G_CALLBACK(pressed_sequencer_button_volume), view);

	return view;
}

#define Y_OFFSET 48
/* Adds STV into array & container and positions it.
 */
static void sequencer_track_view_add(SequencerTrackView *track_view) {
	track_views[tracks_in_use] = track_view;

	//Add this tracks control_panel (volume buttons etc)
	clutter_container_add_actor(CLUTTER_CONTAINER(jammo_get_actor_by_id("fullsequencer-track-control-panel")), track_view->control_panel);
	clutter_actor_set_y(track_view->control_panel, track_height * tracks_in_use + Y_OFFSET);

	//Add track to container
	ClutterActor* track_container = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	clutter_container_add_actor(CLUTTER_CONTAINER(track_container), track_view->track_view);
	clutter_actor_set_x(track_view->track_view, clutter_actor_get_x(track_view->track_view)+1);  //unless left border is not visible
	clutter_actor_set_y(track_view->track_view, track_height * tracks_in_use + Y_OFFSET +1);  //unless bottom border is not visible

	//Raise container's and scroller's height
	clutter_actor_set_height(track_container,clutter_actor_get_height(track_container)+track_height);
	ClutterActor* texture_of_cursor = jammo_get_actor_by_id("fullsequencer_cursor_texture");
	clutter_actor_set_height(texture_of_cursor, clutter_actor_get_height(track_container) + Y_OFFSET);

	tracks_in_use++;
}


//This contains lots of same rows than sequencer_track_view_add_with_type
ClutterActor* sequencer_track_view_add_backing_track(JammoTrack* track, gboolean muted,gfloat volume) {
	ClutterActor *label;
	ClutterActor* track_view_actor = NULL; //This will be returned
	SequencerTrackView *sequencer_track_view;
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));

	gchar* name_of_label_button="";
	name_of_label_button = "/opt/jammo/sequencer/label_backingtrack.png";
	label = tangle_button_new_with_background_actors (
     clutter_texture_new_from_file(name_of_label_button, NULL), /* normal */
     clutter_texture_new_from_file(name_of_label_button, NULL));  /* interactive TODO*/

	track_view_actor = tangle_widget_new();
	g_object_set_data (G_OBJECT(track_view_actor),"track",track);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));
	sequencer_track_view = sequencer_track_view_new(label, track_view_actor, BACKING_TRACK_VIEW, muted,volume);
	sequencer_track_view_add(sequencer_track_view);
	printf("sequencer_track_view_add_backing_track over\n");
	return track_view_actor;
}

/*
 * Adds given type of track view into sequencer view
 * Returns track_view_actor (jammo_track_view) of newly created sequencer_track_view
 * Returns NULL is askes invalid type.
 */
ClutterActor* sequencer_track_view_add_with_type(gint track_view_type, gboolean muted, gfloat volume, gint optional_parameter) {
	gint twt = track_view_type;
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	guint64 duration_of_tracks = jammo_sequencer_get_duration(sequencer);

	printf("Making '%d' track (duration: %" G_GUINT64_FORMAT ")\n",track_view_type, duration_of_tracks);

	guint64 duration_of_one_slot = duration_of_tracks / number_of_slots;

	ClutterActor *label;
	gchar* name_of_label_button="";
	JammoTrack* track;

	ClutterActor* track_view_actor = NULL; //This will be returned
	SequencerTrackView *sequencer_track_view;

	//Choose label-image:
	switch (track_view_type) {
		case 	INSTRUMENT_TRACK_VIEW:
			if (optional_parameter==1)
				name_of_label_button = "/opt/jammo/sequencer/label_drum.png"; //drum has own label
			else
				name_of_label_button = "/opt/jammo/sequencer/label_keyboard.png";
			break;

		case SLIDER_TRACK_VIEW:
			name_of_label_button = "/opt/jammo/sequencer/label_slider.png";
			break;

		case AUDIO_TRACK_VIEW:
			name_of_label_button = "/opt/jammo/sequencer/label_audio.png";
			break;

		case EDITING_TRACK_VIEW:
			if (optional_parameter==JAMMO_SAMPLE_RHYTMICAL)
				name_of_label_button = "/opt/jammo/sequencer/label_loop_rhythm.png";
			else if (optional_parameter==JAMMO_SAMPLE_HARMONICAL)
				name_of_label_button = "/opt/jammo/sequencer/label_loop_harmony.png";
			else if (optional_parameter==JAMMO_SAMPLE_MELODICAL)
				name_of_label_button = "/opt/jammo/sequencer/label_loop_melody.png";
			else if (optional_parameter==JAMMO_SAMPLE_EFFECT)
				name_of_label_button = "/opt/jammo/sequencer/label_loop_effect.png";
			else //Same sane default value
				name_of_label_button = "/opt/jammo/sequencer/label_loop_effect.png";
			break;
/*
		case BACKING_TRACK_VIEW:
			name_of_label_button = "/opt/jammo/sequencer/label_backingtrack.png";
			break;
*/
		default:	 //Error-case
			printf("sequencer_track_view_add_with_type: Not detected track-view type '%d'\n",track_view_type);
		return NULL;
	}

	label = tangle_button_new_with_background_actors (
     clutter_texture_new_from_file(name_of_label_button, NULL), /* normal */
     clutter_texture_new_from_file(name_of_label_button, NULL));  /* interactive TODO*/


	//Make instrument_track and miditrack_view
	if (track_view_type == INSTRUMENT_TRACK_VIEW)
		{
		track = JAMMO_TRACK(jammo_instrument_track_new(optional_parameter));

		// TODO set transpose. Key of the song should be stored somewhere
		instrument_gui_set_transpose('c');

		//TODO: we need to know highest_note and lowest_note for this instrument!
		track_view_actor = jammo_miditrack_view_new(JAMMO_INSTRUMENT_TRACK(track),
          number_of_slots*4,       //Miditrack-view uses more narrow slots
          duration_of_one_slot/4,
          width_of_slot, track_height, //height can be anything, we zoom it
          59,36);  //Highest-note and lowest-note. TODO: should be asked from instrumet
		jammo_miditrack_view_zoom_to_fit(JAMMO_MIDITRACK_VIEW(track_view_actor), number_of_slots*width_of_slot,track_height);
		jammo_miditrack_view_set_show_grid(JAMMO_MIDITRACK_VIEW(track_view_actor),FALSE);
		}



	//Make slider_track and container for it
	else if (track_view_type == SLIDER_TRACK_VIEW)
		{
		track = JAMMO_TRACK(jammo_slider_track_new(optional_parameter));


		track_view_actor = tangle_widget_new();
		g_object_set_data (G_OBJECT(track_view_actor),"track",track);
		//TODO: set size and some visualization.
		}

	//Make editing_track and track_view
	else
	{
		track = JAMMO_TRACK(jammo_editing_track_new_fixed_duration(duration_of_tracks));

		track_view_actor = jammo_track_view_new(JAMMO_EDITING_TRACK(track),
          number_of_slots, duration_of_one_slot, width_of_slot, track_height);
		clutter_actor_set_reactive(track_view_actor, TRUE);
		g_object_set(track_view_actor, "line-every-nth-slot", 1, "sample-type", optional_parameter, NULL);
	}


	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));
	sequencer_track_view = sequencer_track_view_new(label, track_view_actor, twt, muted,volume);
	sequencer_track_view_add(sequencer_track_view);
	return track_view_actor;
}

/*
 * Event for pressing label on track, data points to track structure
 */
static gboolean pressed_sequencer_button_track_label (TangleButton *tanglebutton, gpointer data) {

	SequencerTrackView* s_track_view = (SequencerTrackView*)data;

	printf("Pressed track label\n");
	if (JAMMO_IS_MIDITRACK_VIEW(s_track_view->track_view))
	{
		printf("It is instrument track\n");
		//We can start realtime jamming or midi-editor.
		//Midi-editor backs always to sequencer.
		//From Jamming we can go back to sequencer or reach editor
		//TODO: some way to go straight to editor.

		//jamming
		instrument_gui_start(JAMMO_MIDITRACK_VIEW(s_track_view->track_view), NULL); //NULL means no slider

		//editor
		//midi_editor_start_with_miditrack_view(JAMMO_MIDITRACK_VIEW(track->track_view));
	}
	else if (TANGLE_IS_WIDGET(s_track_view->track_view))
	{
		printf("It is slider track or backing-track\n");
		TangleWidget* container = TANGLE_WIDGET(s_track_view->track_view);
		JammoTrack* track= JAMMO_TRACK(g_object_get_data(G_OBJECT(container),"track"));
		if (JAMMO_IS_SLIDER_TRACK(track)) {
			printf(" it is slider_track\n");
			instrument_gui_start(NULL, container); //NULL means no keyboard, but slider
		}
		else if (JAMMO_IS_BACKING_TRACK(track)){
			printf(" it is backing_track\n");
			clutter_actor_show(jammo_get_actor_by_id("backingtrack-selection-view"));
			clutter_actor_hide(jammo_get_actor_by_id("fullsequencer-view"));
		}
		else {
			printf(" it is editing_track (start jammer)\n");
			clutter_actor_show(jammo_get_actor_by_id("jammer-view"));
			clutter_actor_hide(jammo_get_actor_by_id("fullsequencer-view"));
			start_jammer();
		}
	}

	return TRUE;
}


/*JSON callback. TODO
*/
gboolean fullsequencer_mentor_clicked (TangleButton *tanglebutton, gpointer data)   {
	printf("mentor clicked\n");
	return TRUE;
}

static gboolean pressed_sequencer_button_mute (TangleButton *tanglebutton, gpointer data)   {
	printf("mute clicked\n");
	SequencerTrackView *track_view = (SequencerTrackView*) data;
	JammoPlayingTrack* jammotrack;

	//slider and backingtrack is inside tangle_widget, midi- and loop-tracks are inside of jammo-*track-view
	if (JAMMO_IS_TRACK_VIEW(track_view->track_view) || JAMMO_IS_MIDITRACK_VIEW(track_view->track_view)) {
		g_object_get(track_view->track_view, "track", &jammotrack, NULL);
	} else if (TANGLE_IS_WIDGET(track_view->track_view)) {
		jammotrack = JAMMO_PLAYING_TRACK(g_object_get_data(G_OBJECT(track_view->track_view),"track"));
	} else  {
		return FALSE;
	}


	jammo_playing_track_set_muted(JAMMO_PLAYING_TRACK(jammotrack), tangle_button_get_selected(tanglebutton));

	return TRUE;
}



/**
This syncs scrollers offset to tracks volume.
*/
gboolean sequencer_volumebar_used (ClutterActor *scroll_action, gpointer none){
	printf("sequencer_volumebar_used\n");
	if (!last_pressed_volume_button)
		return FALSE;

	ClutterActor* volume_scroller = clutter_actor_meta_get_actor(CLUTTER_ACTOR_META(scroll_action));
	//-50 is height of the visible marker.
	gfloat height = clutter_actor_get_height(CLUTTER_ACTOR(volume_scroller))-50;
	gfloat offset,not_used;
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(scroll_action), &not_used,&offset);

	printf("height %f, offset :%f\n",height, offset);

	JammoPlayingTrack* jammotrack = g_object_get_data(G_OBJECT(volume_scroller),"track");

	gfloat new_volume = offset/height; //This is between [0...1]
	jammo_playing_track_set_volume(jammotrack,new_volume);
	//printf("new volume:%f\n\n",new_volume);

	ClutterActor* container = tangle_button_get_normal_background_actor(last_pressed_volume_button);
	ClutterActor* nub = tangle_widget_get_nth_child(TANGLE_WIDGET(container),0);

	ClutterActor* container2 = tangle_button_get_selected_background_actor(last_pressed_volume_button);
	ClutterActor* nub2 = tangle_widget_get_nth_child(TANGLE_WIDGET(container2),0);

	gfloat height_ = 36; //clutter_actor_get_height(container) - clutter_actor_get_height(nub); //If hided. container reports it's height wrongly
	//printf("height_: %f\n",height_);

	clutter_actor_set_y(nub,height_-new_volume*height_);
	clutter_actor_set_y(nub2,height_-new_volume*height_);
	return FALSE;
}



/**
Each tracks share one volumebar.
*/
static gboolean pressed_sequencer_button_volume (TangleButton *tanglebutton, gpointer data) {
	SequencerTrackView *track_view = (SequencerTrackView*) data;

	ClutterActor* volume_container = jammo_get_actor_by_id("fullsequencer-volumebar-container");
	ClutterActor* volume_scroller = jammo_get_actor_by_id("fullsequencer-volumebar-scroller");
	ClutterAction* scroll_action = tangle_actor_get_action_by_type(volume_scroller,TANGLE_TYPE_SCROLL_ACTION);

	JammoPlayingTrack* jammotrack;

	//slider and backingtrack is inside tangle_widget, midi- and loop-tracks are inside of jammo-*track-view
	if (JAMMO_IS_TRACK_VIEW(track_view->track_view) || JAMMO_IS_MIDITRACK_VIEW(track_view->track_view)) {
		g_object_get(track_view->track_view, "track", &jammotrack, NULL);
	} else if (TANGLE_IS_WIDGET(track_view->track_view)) {
		jammotrack = JAMMO_PLAYING_TRACK(g_object_get_data(G_OBJECT(track_view->track_view),"track"));
	} else  {
		return FALSE;
	}

	gfloat current_volume = jammo_playing_track_get_volume(jammotrack);
	//printf("volume of this track is :%f\n",current_volume);

	//When pressing already selected track, hide volume bar
	if (last_pressed_volume_button==tanglebutton) {
		clutter_actor_hide(volume_container);
		g_object_set_data(G_OBJECT(volume_scroller),"track",NULL);
		last_pressed_volume_button=NULL;
	}

	//Hide last pressed and put new value to volumebar from track
	else {
		clutter_actor_show(volume_container);
		//-50 is height of the visible marker.
		gfloat new_place = (clutter_actor_get_height(CLUTTER_ACTOR(volume_scroller))-50)*current_volume;
		//printf("new place: %f\n",new_place);
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-y", new_place, NULL);
		g_object_set_data(G_OBJECT(volume_scroller),"track",jammotrack);
		if (last_pressed_volume_button)
			tangle_button_set_selected(last_pressed_volume_button,FALSE);
		last_pressed_volume_button=tanglebutton;
		}

	return FALSE;
}




//JSON callback
void fullsequencer_on_cursor_notify_x(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	//printf("fullsequencer_on_cursor_notify_x\n");

	ClutterActor* scrolling_view = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	ClutterAction* scroll_action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);

	gfloat x, visible, offset, max;

	g_object_get(object, "x", &x, NULL);
	g_object_get(scrolling_view, "width", &visible, NULL);
	g_object_get(scroll_action, "offset-x", &offset, "max-offset-x", &max, NULL);
	//printf("x=%f, visible-width =%f, offset=%f, max=%f\n",x,visible,offset,max);

	if (x < offset) {
		offset = x - visible + 80.0;
		if (offset < 0.0) {
			offset = 0.0;
		}
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-x", offset, NULL);
	} else if (x > offset + visible - 80.0) {
		offset += 160.0;
		if (offset > max) {
			offset = max;
		}
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-x", offset, NULL);
	}
}

/***************************
Functions for json
**************************/



void fullsequencer_play_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Play-Stop-Button pressed\n");

	//tanglebutton is toggle-button.
	gboolean selected;
	g_object_get(tanglebutton, "selected", &selected,  NULL);

	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	if (selected) {
		jammo_sequencer_play(sequencer);
	}
	else {
		jammo_sequencer_stop(sequencer);
	}
}



//TODO
void fullsequencer_record_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Record pressed\n");
}



void fullsequencer_community_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Community pressed. Doesn't do anything\n");
}

void fullsequencer_home_clicked (TangleButton* tanglebutton, gpointer none){
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));

	jammo_sequencer_stop(sequencer);

	gchar* meta_data = g_strdup_printf
	("\"pitch\" : \"%s\",\n\"tempo\" : %d,\n",jammo_sequencer_get_pitch(sequencer),jammo_sequencer_get_tempo(sequencer));

	save_composition("7-12/", jammo_get_actor_by_id("fullsequencer-container-for-tracks"),meta_data);
	g_free(meta_data);
	clutter_actor_show(jammo_get_actor_by_id("startmenu-view"));
}


/*
Also prepare cursor.
*/
void sequencer_track_view_tune_width() {
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	guint64 duration;
	duration = jammo_sequencer_get_duration(sequencer);

	g_print("Duration: %" G_GUINT64_FORMAT "\n", duration);

	gint tempo_factory = 4;
	//We want operate whole time with guint64.
	guint64 temp=60*tempo_factory;
	guint64 one_second = 1000000000L;
	guint64 big = temp * one_second;
	guint64 duration_of_one_slot = big / jammo_sequencer_get_tempo(sequencer);

	gint n_slots = duration/duration_of_one_slot;
	printf("*number_of_slots (in backing-track / for editing-track): %d\n",n_slots);


	//Set static
	number_of_slots = n_slots;

	//CURSOR
	gfloat width_of_area = number_of_slots*width_of_slot;
	ClutterActor* cursor;
	cursor = jammo_get_actor_by_id("fullsequencer_cursor");
	clutter_actor_set_size(cursor, width_of_area, 80.0); //width is important, height is not used
}

