/**sequencer_track_view.h is part of JamMo.
License: GPLv2, read more from COPYING

SequencerTrackView is struct which contains jammo-track-view (or jammo-miditrack-view)
and buttons for volume, muting
and label
and some metadata.

*/

#ifndef SEQUENCER_SEQUENCER_H_
#define SEQUENCER_SEQUENCER_H_

#include <stdbool.h>

/*
 * Wraps TrackView and buttons & labels into one clean package
 * to add and remove TrackViews easily to sequencer
 */
typedef struct {
	ClutterActor *control_panel;
	ClutterActor *track_view;
	gint track_type;
} SequencerTrackView;

/*
 * Contains all possible SequencerTrackView types
 */
enum {
	INSTRUMENT_TRACK_VIEW = 1,
	SLIDER_TRACK_VIEW,
	AUDIO_TRACK_VIEW,
	EDITING_TRACK_VIEW,
	BACKING_TRACK_VIEW
};

//Types of editing track
enum {
	RHYTHM_TRACK,
	MELODY_TRACK,
	HARMONY_TRACK,
	EFFECT_TRACK
};

void sequencer_track_view_create_area_for_tracks(JammoSequencer* seq, guint n_slots, guint64 total_duration, gfloat slot_width, gfloat height);
ClutterActor* sequencer_track_view_add_backing_track(JammoTrack* track, gboolean muted);
ClutterActor* sequencer_track_view_add_with_type(gint track_view_type, gboolean muted, gint optional_parameter);

//void sequencer_sequencer_track_view_remove_last();
bool save_sequencer_state();

#endif /* SEQUENCER_SEQUENCER_H_ */
