/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"

ClutterActor* communitymenu_group=NULL;

//return to startmenu
void communitymenu_goto_startmenu (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
//	tangle_actor_hide_animated(TANGLE_ACTOR(actor));
	clutter_actor_hide (CLUTTER_ACTOR(communitymenu_group));

	show_startmenu();
}

gboolean start_communitymenu()
{
	printf("Starting communitymenu\n");


	ClutterActor* mainview;

	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);


	communitymenu_group = jammo_get_actor_by_id("communitymenu-view");
	clutter_actor_show (CLUTTER_ACTOR(communitymenu_group));

	return FALSE;
}
