#include <tangle.h>
#include <clutter/clutter.h>
#include <string.h>

#include "../configure.h" //e.g. DATA_DIR
#include "../jammo-sample-button.h"
#include "../jammo-track-view.h"

#include "theme.h"

/*
 Filename for saving are automatically generated,
 Iconfile is given as parameter.
 upper_track_view can be NULL (if there are only one track in use)
 prefix_for_saving contains themename and variation
*/
gboolean composition_game_file_helper_save_composition(gchar* name_of_icon, JammoTrackView* track_view ,JammoTrackView* upper_track_view, const gchar* name, gint variation) {
	printf("Saving composition, using icon file '%s'\n",name_of_icon);

	gchar* prefix_for_saving = g_strdup_printf("+%s+%d+%s",name,variation,upper_track_view? "a":"e"); //in easy game upper_track_view is NULL
	//example: +fantasy+2+e
	//printf("prefix is '%s'\n",prefix_for_saving);

	FILE *ofp;
	gchar *outputFilename;

	outputFilename = g_strdup_printf("%s/last_composition.txt", JAMMO_DIRECTORY);

	ofp = fopen(outputFilename, "w");
	g_free(outputFilename);
	g_return_val_if_fail(ofp != NULL, FALSE);

	//'Header'
	fprintf(ofp,"{ \n");

	//Metadata
	fprintf(ofp,"\"icon\" : \"%s\",\n",name_of_icon);
	fprintf(ofp,"\"Author\" : \"%s\",\n","author");   //TODO: add author
	fprintf(ofp,"\"theme\" : \"%s\",\n",name);
	fprintf(ofp,"\"variation\" : %d,\n",variation);
	//fprintf(ofp,"\n");

	fprintf(ofp,"\"tracks\" : [\n");
	//Tracks
	TangleWidget* widget;
	//Save both track_views if not NULL.
	int number_of_tracks = upper_track_view?2:1;
	int i;
	for (i = 1 ; i<=number_of_tracks;i++) {
		if (i==1){
			widget = TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(track_view)));
			fprintf(ofp,"\n");
		}
		else {
			widget = TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(upper_track_view)));
			fprintf(ofp,",\n\n");
		}



		fprintf(ofp,"\t{\n");
		fprintf(ofp,"\t\"track-type\" : \"EditingTrack\",\n");

		fprintf(ofp,"\t\"samples\" : [\n");

		gfloat slot_size;
		g_object_get(track_view,"slot-width",&slot_size,NULL);
		printf("slot_size '%lf'\n",slot_size);

		GList* children;
		JammoSampleButton* jsb;
		gboolean first = TRUE;

		for (children = tangle_widget_get_children_readonly(widget); children; children = children->next)
			{
			if (!first)
				fprintf(ofp,",\n");
			first=FALSE;
			jsb = JAMMO_SAMPLE_BUTTON(children->data);
			//printf("x: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb)));
			printf("slot: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
			fprintf(ofp,"\t\t{ \n");
			gint loop_id;
			g_object_get(jsb, "loop_id", &loop_id, NULL);
			fprintf(ofp,"\t\t\"loop_id\" : %d,\n",loop_id);

			gint slot = clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size;
			fprintf(ofp,"\t\t\"slot\" : %d\n",slot);
			fprintf(ofp,"\t\t}");
			}
	fprintf(ofp,"\n\t]\n\t}");

	} //Next track

	//'Footer'
	fprintf(ofp,"\n\n]\n}\n");
	fclose(ofp);

	//Saving to cupboard
	gchar* cmd;

	// Filenames look like this: _2010.02.22_21.16.27.wav
	cmd = g_strdup_printf("cp %s/last_composition.txt %s/%s-`date +%%Y.%%m.%%d_%%H.%%M.%%S`.txt",JAMMO_DIRECTORY,COMPOSITIONS_DIRECTORY,prefix_for_saving);
	if (system(cmd))
		printf("Error, can't call '%s'\n",cmd);

	g_free(cmd);

	return TRUE;
}


gboolean composition_game_file_helper_load_from_file(gpointer data,JammoTrackView* bottom_track_view ,JammoTrackView* upper_track_view) {

gchar* filename = (gchar*) data;
printf("Themeselection: Loading composition in file '%s'\n",filename);


JsonParser *parser;
parser = json_parser_new ();
g_assert (JSON_IS_PARSER (parser));

GError *error = NULL;
if (!json_parser_load_from_file (parser, filename, &error))
	{
		g_print ("Error: %s\n", error->message);
		g_error_free (error);
		g_object_unref (parser);
		return FALSE;
	}

JsonNode *root;
JsonObject *object;
JsonNode *node;

g_assert (NULL != json_parser_get_root (parser));

root = json_parser_get_root (parser);
g_assert_cmpint (JSON_NODE_TYPE (root), ==, JSON_NODE_OBJECT);

object = json_node_get_object (root);
g_assert (object != NULL);


gchar* theme_name ="";
gint variation =-1;

	//string
	node = json_object_get_member (object, "icon");
	if (node!=NULL && JSON_NODE_TYPE (node) == JSON_NODE_VALUE){
		gchar* icon_name =(gchar*)  json_node_get_string (node);
		printf("icon: '%s'\n",icon_name);
	}

	//string
	node = json_object_get_member (object, "theme");
	if (node!=NULL && JSON_NODE_TYPE (node) == JSON_NODE_VALUE){
		theme_name =(gchar*)  json_node_get_string (node);
		printf("theme: '%s'\n",theme_name);
	}

	//int
	node = json_object_get_member (object, "variation");
	if (node!=NULL && JSON_NODE_TYPE (node) == JSON_NODE_VALUE){
		variation = json_node_get_int (node);
		printf("variation: '%d'\n",variation);
	}

	gint track_counter =1;
	//Array
	node = json_object_get_member (object, "tracks");
	JsonArray* track_array;
	guint length_tracks = 0;
	if (node!=NULL && JSON_NODE_TYPE (node) == JSON_NODE_ARRAY){
		track_array =  json_node_get_array (node);
		length_tracks = json_array_get_length(track_array);
	}
	else {printf("Not any tracks\n"); }

	printf("length %d\n",length_tracks);
	int j;
	for (j=0;j<length_tracks;j++) {

		//Object
		JsonNode* track_node;
		track_node = json_array_get_element(track_array,j);


		if (track_node!=NULL && JSON_NODE_TYPE(track_node) == JSON_NODE_OBJECT){
			printf("Found another track\n");
			JammoTrackView* track_view = NULL;
			if (track_counter == 1)
				track_view = bottom_track_view;
			else if (track_counter == 2)
				track_view = upper_track_view;
			else {
				printf("problems with loading from file\n");
			}
			JsonObject* sub_object = json_node_get_object(track_node);
			JsonNode *sub_node;
			sub_node = json_object_get_member (sub_object, "track-type");
			if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_VALUE){
				gchar* track_type =(gchar*)  json_node_get_string (sub_node);
				printf("track-type: '%s'\n",track_type);
				}

			//Array
			sub_node = json_object_get_member (sub_object, "samples");
			if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_ARRAY){
				JsonArray* sample_array =  json_node_get_array (sub_node);

				guint length = json_array_get_length(sample_array);
				printf("length %d\n",length);
				int i;
				for (i=0;i<length;i++) {
					JsonNode* sample_node;
					sample_node = json_array_get_element(sample_array,i);
					if (sample_node!=NULL && JSON_NODE_TYPE(sample_node) == JSON_NODE_OBJECT){
						JsonObject* sample_object = json_node_get_object(sample_node);
						gint loop_id=-1;
						gint slot=-1;

						//int
						sub_node = json_object_get_member (sample_object, "loop_id");
						if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_VALUE){
							loop_id =  json_node_get_int (sub_node);
							printf("loop_id: '%d'\n",loop_id);
						}
						//int
						sub_node = json_object_get_member (sample_object, "slot");
						if (sub_node!=NULL && JSON_NODE_TYPE (sub_node) == JSON_NODE_VALUE){
							slot =  json_node_get_int (sub_node);
							printf("slot: '%d'\n",slot);
						}
						if (track_view==NULL)
								printf("track_view==NULL\n");
						ClutterActor* sample_button = theme_give_sample_button_for_this_theme_and_variation_for_this_id(theme_name,variation,loop_id);
						if (sample_button==NULL)
							printf("sample_button==NULL\n");
						jammo_track_view_add_jammo_sample_button(track_view,JAMMO_SAMPLE_BUTTON(sample_button),slot);

					} //This sample-object is ready

				} //Foreach in sample-array ready

			} //sample-array is ready

		} //Track is ready
		track_counter++;
	} //Next track

g_object_unref(parser);

return TRUE;
}
