#include <tangle.h>
#include <clutter/clutter.h>
#include <string.h>

#include "../configure.h" //e.g. DATA_DIR
#include "../jammo-sample-button.h"
#include "../jammo-track-view.h"

/*
 Filename for saving are automatically generated,
 Iconfile is given as parameter.
 upper_track_view can be NULL (if there are only one track in use)
 prefix_for_saving contains themename and variation
*/
gboolean composition_game_file_helper_save_composition(gchar* name_of_icon, JammoTrackView* track_view ,JammoTrackView* upper_track_view, gchar* prefix_for_saving) {
	printf("Saving composition, using icon file '%s'\n",name_of_icon);
	FILE *ofp;
	gchar *outputFilename;

	outputFilename = g_strdup_printf("%s/last_composition.txt", JAMMO_DIRECTORY);

	ofp = fopen(outputFilename, "w");
	g_free(outputFilename);
	g_return_val_if_fail(ofp != NULL, FALSE);

	//File starts with name of icon
	fprintf(ofp,"%s\n",name_of_icon);


	gfloat slot_size;
	g_object_get(track_view,"slot-width",&slot_size,NULL);
	printf("slot_size '%lf'\n",slot_size);

	GList* children;
	TangleWidget* widget;
	JammoSampleButton* jsb;
	widget = TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(track_view)));
	for (children = tangle_widget_get_children_readonly(widget); children; children = children->next)
		{
		jsb = JAMMO_SAMPLE_BUTTON(children->data);
		//printf("x: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb)));
		printf("slot: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
		fprintf(ofp,"%lf\n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
		gchar* sound;
		gchar* image;
		g_object_get(jsb, "sample-filename", &sound, NULL);
		g_object_get(jsb, "image-filename", &image, NULL);
		printf("image: '%s'. sound: '%s' \n",image,sound);
		fprintf(ofp,"%s\n",sound);
		fprintf(ofp,"%s\n",image);
		}

	if (upper_track_view!= NULL)
		{
		fprintf(ofp,"-1\n#\n#\n");
		track_view = upper_track_view;
		g_object_get(track_view,"slot-width",&slot_size,NULL);

		widget = TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(track_view)));
		for (children = tangle_widget_get_children_readonly(widget); children; children = children->next)
			{
			jsb = JAMMO_SAMPLE_BUTTON(children->data);
			//printf("x: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb)));
			printf("slot: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
			fprintf(ofp,"%lf\n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
			gchar* sound;
			gchar* image;
			g_object_get(jsb, "sample-filename", &sound, NULL);
			g_object_get(jsb, "image-filename", &image, NULL);
			printf("image: '%s'. sound: '%s' \n",image,sound);
			fprintf(ofp,"%s\n",sound);
			fprintf(ofp,"%s\n",image);
			}
		}

	fclose(ofp);

	//Saving to cupboard
	gchar* cmd;

	// Filenames look like this: _2010.02.22_21.16.27.wav
	cmd = g_strdup_printf("cp %s/last_composition.txt %s/%s-`date +%%Y.%%m.%%d_%%H.%%M.%%S`.txt",JAMMO_DIRECTORY,COMPOSITIONS_DIRECTORY,prefix_for_saving);
	if (system(cmd))
		printf("Error, can't call '%s'\n",cmd);

	g_free(cmd);

	return TRUE;
}


gboolean composition_game_file_helper_load_from_file(gpointer data,JammoTrackView* bottom_track_view ,JammoTrackView* upper_track_view) {

	gchar* inputFilename = (gchar*) data;
	printf("Themeselection: Loading composition in file '%s'\n",inputFilename);

	JammoTrackView* track_view = bottom_track_view;
	FILE *ifp;

	ifp = fopen(inputFilename, "r");
	g_return_val_if_fail(ifp != NULL, FALSE);

	int bytes_read;
	size_t nbytes = 100; //No field can have this many characters
	char *my_string;
	my_string = (char *) malloc (nbytes + 1);
	gboolean not_ready = TRUE;

	//First line is name of icon, just ignore it
	bytes_read = getline (&my_string, &nbytes, ifp);


	int slot;
	char* wav_name = malloc (nbytes + 1);
	char* png_name = malloc (nbytes + 1);
	while (not_ready)
		{

		//Slot number
		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0)
		{
			not_ready=FALSE;
			continue;
		}

		slot=atoi(my_string); //There are end-of-line ins string, but atoi works.
		printf("slot='%d'\n",slot);


		//sound filename
		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0)
		{
			not_ready=FALSE;
			continue;
		}
		strncpy(wav_name, my_string, strlen(my_string)-1); //throw end-of-line away
		wav_name[strlen(my_string)-1]='\0';                //Add string terminator

		printf("name of soundfile='%s'\n",wav_name);


		//image filename
		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0)
		{
			not_ready=FALSE;
			continue;
		}
		strncpy(png_name, my_string, strlen(my_string)-1); //throw end-of-line away
		png_name[strlen(my_string)-1]='\0';                //Add string terminator

		printf("name of pngfile='%s'\n",png_name);

		if (slot==-1 && strncmp(png_name,"#",1)==0 && strncmp(wav_name,"#",1)==0 ) //this means 'next-track'
			{
			printf("next track\n");
			if (track_view == upper_track_view) //Somebody tries use three tracks! (Not planned to support this)
				return FALSE;
			if (upper_track_view == NULL) //Somebody tries load 'two tracks'-file on easy-mode
				return FALSE;
			track_view = upper_track_view;
			}

		else
			{
			//Make sample_button and put it into track.
			ClutterActor* sample_button;
			sample_button = jammo_sample_button_new_from_files(png_name, wav_name);
			jammo_track_view_add_jammo_sample_button(JAMMO_TRACK_VIEW(track_view), JAMMO_SAMPLE_BUTTON(sample_button), slot);
			}
		//printf("This entry ready\n");
	}
	//printf("File readed\n");
	return TRUE;
}
