/*
 * gems_definitions.h
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Jussi Laakkonen <jussi.laakkonen@lut.fi>
 *	    Tommi Kallonen  <tommi.kallonen@lut.fi>
 */
 
 
#ifndef __GEMS_DEFINITIONS_
#define __GEMS_DEFINITIONS_

// Event list operation types for CHUM
// with these CHUM can specify what to do with a midi or slider event list
typedef enum
{
	GEMS_EVENTLIST_REPLACE
} GemsEventListOperation;

#define JAMMO_NETWORK_BUFFER_MAX_SIZE 1024
// TODO change to use sha256 -> 32 bytes
#define JAMMO_MESSAGE_DIGEST_SIZE 20 // 160 bit SHA1
// If no reply received the request is being sent every X seconds
#define PROFILE_REQUEST_INTERVAL 5.00
// Group info request interval, 15 seconds 
#define GROUP_REQUEST_INTERVAL 15.00
// Group adverting interval, 3 seconds
#define GROUP_ADVERT_INTERVAL 3.00
// Limit for removing group (from last advert)
#define GROUP_REMOVE_LIMIT 60.00
// Limit for removing from rejected list - 5 min
#define REJECTED_LIST_REMOVE_LIMIT 300.00
// Limit for errorous connections
#define CONNECTION_ERRORLIMIT 5
// Basic interval for connection attempts, each error increases this by 1 second
#define CONNECTION_INTERVAL 5.00
// Max size for group
#define GROUP_MAX_SIZE 4
// Group not assigned
#define FREE_SLOT 0
// Group not active
#define NOT_ACTIVE 0

// Used as return values when searching connections from various lists
#define NOT_IN_LIST 0
#define IN_INITIALIZED_LIST 1
#define IN_JAMMO_SERVICE_LIST 2
#define IN_CONNECTING_LIST 3
#define IN_CONNECTED_LIST 4
#define IN_REJECTED_LIST 5

// Group return velues
#define ADDED_TO_GROUP 0
#define REQUEST_SENT 1
#define ALREADY_IN_GROUP 2
#define CANNOT_ADD 3
#define REMOVED_OK 4
#define NOT_IN_GROUP 5
#define GROUP_LOCKED 6
#define CANNOT_CONNECT_TO_OWNER 7
#define NO_OWNER 8
#define NO_MATCHING_GROUP 9
#define GROUP_FULL 10
#define REQUEST_NOT_SENT 11

// Group status
#define IN_GROUP 111
#define JOINING 112
#define LEAVING 113
// NOT_ACTIVE in group = not in group

// Error type
#define ERROR_CONNECTION 21
#define ERROR_REJECTED 22
#define ERROR_ALREADY_CONNECTED 23

/* NETWORK DEFINITIONS */

#define JAMMO_PACKET_PRIVATE 10
#define JAMMO_PACKET_GROUP 11
#define JAMMO_PACKET_ADMIN 12

/*-----------  Service ID's ----------*/
#define JAMMO_SERVICE_ID 100
#define AA_SERVICE_ID 101
#define PROFILE_SERVICE_ID 102
#define GROUP_SERVICE_ID 103
#define COLLABORATION_SERVICE_ID 104
#define SONGBANK_SERVICE_ID 105
#define DATATRANSFER_SERVICE_ID 106
#define MENTOR_SERVICE_ID 107
#define CONTROL_SERVICE_ID 108
#define PROBE_SERVICE_ID 109

/*-----------  Service Names ----------*/
#define JAMMO_SERVICE_NAME "JamMo"
#define AA_SERVICE_NAME JAMMO_SERVICE_NAME ":AuthenticationAndAuthorization"
#define PROFILE_SERVICE_NAME JAMMO_SERVICE_NAME ":Profile"
#define GROUP_SERVICE_NAME JAMMO_SERVICE_NAME ":GroupManagement"
#define COLLABORATION_SERVICE_NAME JAMMO_SERVICE_NAME ":Collaboration"
#define SONGBANK_SERVICE_NAME JAMMO_SERVICE_NAME ":Songbank"
#define DATATRANSFER_SERVICE_NAME JAMMO_SERVICE_NAME ":DataTransfer"
#define MENTOR_SERVICE_NAME JAMMO_SERVICE_NAME ":Mentor"
#define CONTROL_SERVICE_NAME JAMMO_SERVICE_NAME ":Control"
#define PROBE_SERVICE_NAME JAMMO_SERVICE_NAME ":ProbeVerification"


/*-----------  Command types ----------*/

// ERROR
#define ERROR_MSG 10000
#define ERROR_NO_ERROR "No error" // When error id is invalid

// JAMMO SERVICE
#define CONNECT_REQ 1001
#define VERSION_REQ 1002
#define VERSION_REPLY 1003
#define CONNECT_REPLY 1004

// AUTHENTICATION & AUTHORIZATION
#define AUTH_CONNECTION 1011
#define GET_CERTIFICATE 1012
#define PUBLISH_CERTIFICATE 1013
#define CERTIFICATE_OK 1014
#define START_PEER_KEY_EXCHANGE 1015
#define KEY_DATA 1016
#define KEY_DATA_REPLY 1017
#define KEY_OK 1018

// PROFILE SERVICE
#define GET_PROFILE 1021
#define PROFILE_PUB 1022
#define PROFILE_FULL 1023
#define GET_PROFILE_PUB 1024
#define GET_PROFILE_FULL 1025

// GROUP SERVICE
#define REQUEST_MEMBERS 1030
#define OFFER_GROUP 1031
#define REQUEST_GROUP_INFO 1032
#define JOIN_GROUP 1033
#define MEMBER_LIST 1034
#define NEW_MEMBER 1035
#define LEAVE_GROUP 1036
#define REMOVED_FROM_GROUP 1037
#define MEMBER_DROPPED 1038
#define CURRENT_GROUP 1039
#define GROUP_IS_UNLOCKED 1028 // Unused by profile service messages
#define GROUP_IS_LOCKED 1029 // Unused by profile service messages

// COLLABORATION SERVICE
#define ACTION_VI_SINGLE 1040
#define ACTION_CONFIRMED 1041
#define SONG_INFO 1042
#define ACTION_LOOP 1043
#define ACTION_LOOP_SYNC 1044
#define ACTION_MIDI 1045
#define ACTION_SLIDER 1046

#define ADD_LOOP 1048
#define REMOVE_LOOP 1049
#define REPLACE_MIDI_SERIES 1050
#define REPLACE_SLIDER_SERIES 1051

// CONTROL SERVICE
#define CONTROL_MODE 1060
#define CONTROL_OK 1061

// Group types
#define GROUP_TYPE_PAIR 10311
#define GROUP_TYPE_CHAIN 10312
#define GROUP_TYPE_WS_NON_RT 10313
#define GROUP_TYPE_WS_RT 10314
#define GROUP_TYPE_WS_NET 10315




// Group themes
// TODO define group themes

/*-----------  ERROR MESSAGES ----------*/
#define ERROR_ALREADY_CONNECTED_TYPE 10001
#define ERROR_VERSION_MISMATCH_TYPE 10002
#define ERROR_INVALID_STATE_TYPE 10003
#define ERROR_INVALID_SERVICE_ID_TYPE 10004
#define ERROR_SERVICE_NOT_RUNNING_TYPE 10005
#define ERROR_CONNECTION_REJECTED_TYPE 10006
#define ERROR_NOT_IN_GROUP_TYPE 10007
#define ERROR_GROUP_NOT_ACTIVE_TYPE 10008
#define ERROR_INVALID_GROUP_ID_TYPE 10009
#define ERROR_GROUP_FULL_TYPE 10010
#define ERROR_ALREADY_IN_GROUP_TYPE 10011
#define ERROR_GROUP_LOCKED_TYPE 10012
#define ERROR_GROUP_ADD_ERROR_TYPE 10013
#define ERROR_NOT_GROUP_OWNER_TYPE 10014

#define ERROR_INVALID_ACCESS_TYPE 10036

#define ERROR_ALREADY_CONNECTED_MSG "Already connected or trying to connect."
#define ERROR_VERSION_MISMATCH_MSG "Versions mismatch."
#define ERROR_INVALID_STATE_MSG "Wrong message in current state."
#define ERROR_INVALID_SERVICE_ID_MSG "Invalid service id."
#define ERROR_SERVICE_NOT_RUNNING_MSG "Service with requested id is not running."
#define ERROR_CONNECTION_REJECTED_MSG "Connection was previously rejected."
#define ERROR_NOT_IN_GROUP_MSG "Not in group."
#define ERROR_GROUP_NOT_ACTIVE_MSG "Group is not active."
#define ERROR_INVALID_GROUP_ID_MSG "Given group id is not valid."
#define ERROR_GROUP_FULL_MSG "Group is full."
#define ERROR_ALREADY_IN_GROUP_MSG "User is already in the active group."
#define ERROR_GROUP_LOCKED_MSG "Group cannot be joined, group is locked."
#define ERROR_GROUP_ADD_ERROR_MSG "Cannot add to group."
#define ERROR_NOT_GROUP_OWNER_MSG "Not the owner of the group."

#define ERROR_INVALID_ACCESS_MSG "Not enough privileges to get full profile"

/*----------- PROFILE MANAGER ----------*/
#define JAMMOPROFILE ".jammo-profiles/"
#define PROFILETYPE ".csv"

// Profile parameters
#define PROF_PARAM_USERID "userID"
#define PROF_PARAM_USERNAME "username"
#define PROF_PARAM_AUTHLEVEL "authLevel"
#define PROF_PARAM_FIRSTNAME "firstName"
#define PROF_PARAM_LASTNAME "lastName"
#define PROF_PARAM_POINTS "gamePoints"
#define PROF_PARAM_AGE "age"

// Security - extraction of envelope return values
#define SECURITY_OK 10190
#define SECURITY_CORRUPT_MESSAGE 10191 // hash value in envelope doesn't match the content
#define SECURITY_VERIFY_FAILED 10192 // cannot verify the signature of hash

#endif //__GEMS_DEFINITIONS_
