/*
 * This file is part of JamMo.
 *
 * Instrument_gui is realtime 'jamming' UI.
 *
 * This is used with midi-instrument and slider. TODO:slider



Three cases:
A) not yet recording, just testing jamming
   there are ad-hoc sequencer containing ad-hoc-instrument-track
B) recording.
   this plays real-sequencer + real-instrument-track on recording mode
c) playback.
   this plays real_sequencer


 * (c) 2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */

#include <tangle.h>
#include <glib-object.h>
#include <ctype.h>
#include <string.h>
#include <clutter/clutter.h>

#include "../../meam/jammo-meam.h"
#include "../../meam/jammo-instrument-track.h"
#include "../../meam/jammo-slider-track.h"
#include "../../meam/jammo-midi.h"
#include "../jammo-chum.h"
#include "../jammo.h"
#include "../jammo-miditrack-view.h"

#include "midi_editor.h"

static int UPPER_OCTAVE=3;

static JammoSequencer* static_sequencer;

static JammoInstrumentTrack *ad_hoc_instrument_track;
static JammoSequencer* ad_hoc_sequencer;


static gboolean recording;

static JammoMiditrackView* static_jammo_miditrack_view;
//static JammoSliderTrack *slider_track; TODO.

/*
We got notevalue 0...96
if it is negative it means event_off.
keyboad name can be:
	instrument_key_c
	instrument_key_cs
	instrument_key_c2
	instrument_key_cs2
	s= sharp
	2= second row
*/
static void visualize_playback(JammoInstrumentTrack* track, gint note, gpointer none) {
	printf("visualize_playback: note_value: %d\n",note);
	gboolean sharp = FALSE;
	gboolean bottom = FALSE;
	gboolean event_off = FALSE;
	if (note<0) //OFF event
		{
		event_off=TRUE;
		note *=-1;
		}

	const char* notename = jammomidi_note_to_char(note);
	if (notename[1]=='#')
		sharp=TRUE;

	if (note>=12*UPPER_OCTAVE)
		bottom=TRUE;

	const char* id  = g_strdup_printf("instrument_key_%c%s%s",notename[0],sharp?"s":"",bottom?"2":"");
	//printf("looking for id '%s'\n",id);
	ClutterActor* key = jammo_get_actor_by_id(id);


	//Swap normal and interactive textures when note-ON.
	//And change back when note-OFF.
	ClutterActor* old_normal;
	ClutterActor* old_interactive;

	//This works even there are two ONs or two OFFs in a row (even there should not be)
	//first time for each key:
	if (g_object_get_data(G_OBJECT(key), "orig_normal")==NULL){
		//printf("first time\n");
		old_normal = tangle_button_get_normal_background_actor(TANGLE_BUTTON(key));
		old_interactive = tangle_button_get_interactive_background_actor(TANGLE_BUTTON(key));
		g_object_set_data(G_OBJECT(key), "orig_normal", old_normal);
		g_object_set_data(G_OBJECT(key), "orig_interactive", old_interactive);
	}

	if (event_off) {
		//printf(" OFF\n");
		old_normal = g_object_get_data(G_OBJECT(key), "orig_interactive");
		old_interactive = g_object_get_data(G_OBJECT(key), "orig_normal");
	}
	else  {
		//printf(" ON\n");
		old_normal = g_object_get_data(G_OBJECT(key), "orig_normal");
		old_interactive = g_object_get_data(G_OBJECT(key), "orig_interactive");
	}

	g_object_ref(old_interactive);
	g_object_ref(old_normal);
	tangle_button_set_interactive_background_actor(TANGLE_BUTTON(key), NULL);
	tangle_button_set_normal_background_actor(TANGLE_BUTTON(key), NULL);

	tangle_button_set_normal_background_actor(TANGLE_BUTTON(key),old_interactive);
	tangle_button_set_interactive_background_actor(TANGLE_BUTTON(key),old_normal);
	g_object_unref(old_normal);
	g_object_unref(old_interactive);
}


/*
Name of the pressed tanglebutton is three char lenght
first is notename c,d,e,f...
second is 's' = sharp, 't' = not sharp
third is '1'=upper octave, '2'= bottom octave
eg:
ct1
cs1
ct2
cs2

returns 0..96 notevalue
*/
static char notename_to_numericvalue(const gchar* name) {
	int octave=UPPER_OCTAVE; //TODO. use some good octave from sequencer or midi-track
	char note[2];  //We want pass given char to function which wants char* 
	note[0]= name[0];
	note[1] = '\0';

	if (name[2]!='2') //bottom row
		octave--;

  //this returns notevalue 0...96
	char playable_note = jammomidi_char_to_note(note,octave); 
	if (name[1]=='s') //sharp
		playable_note++;  //use next note-value

	printf(" which means note-value: %d\n",playable_note);
	return playable_note;
}

/*
Actually this gets all notifys, but we are using only 'interaction'
i.e pressing and releasing
*/
void instrument_key_interaction_notify (GObject *object, GParamSpec *pspec, gpointer user_data)  {
	if (!strcmp(g_param_spec_get_name(pspec), "interacting")){
		const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(object));
		printf("Keyboard '%s' pressed\n",name);
		TangleButton* button;

		JammoInstrumentTrack* instrument_track;
		if (recording){
			g_object_get(static_jammo_miditrack_view,"track",&instrument_track,NULL);
		}
		else {
			instrument_track = ad_hoc_instrument_track;
		}

		button = TANGLE_BUTTON(object);
		if (tangle_actor_get_interacting(TANGLE_ACTOR(button))) {
			jammo_instrument_track_note_on_realtime (instrument_track, notename_to_numericvalue(name));
		} else {
			jammo_instrument_track_note_off_realtime (instrument_track, notename_to_numericvalue(name));
		}
	}

}




//TODO
void instrument_metronome_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("on_metronome_button_clicked\n");
}


static void end_jamming() {
	jammo_sequencer_stop (JAMMO_SEQUENCER (static_sequencer));

	//hide instrument_view
	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
}

void instrument_goeditor_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("on_go_editor_button_clicked\n");
	end_jamming();

	//start editor
	midi_editor_start_with_miditrack_view(static_jammo_miditrack_view, static_sequencer);
}


void instrument_gosequencer_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("instrument_gosequencer_clicked\n");
	end_jamming();

	//show sequencer
	ClutterActor* view = jammo_get_actor_by_id("fullsequencer-view");
	clutter_actor_show(view);
}


void instrument_play_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("play pressed\n");

	//stop ad_hoc.
	jammo_sequencer_stop (JAMMO_SEQUENCER (ad_hoc_sequencer));

	//Start real-sequencer
	jammo_sequencer_play(JAMMO_SEQUENCER(static_sequencer));
}


void instrument_record_clicked (TangleButton *tanglebutton, gpointer user_data)  {
	printf("on_record_button_clicked\n");

	if (recording) {
		printf("STOP recording\n");
		jammo_sequencer_stop (JAMMO_SEQUENCER (static_sequencer));
	}

	else {
		printf("START recording\n");
		recording = TRUE;
		//TODO, there should be some prelude, or precount with metronome


		//stop ad_hoc.
		jammo_sequencer_stop (JAMMO_SEQUENCER (ad_hoc_sequencer));


		//clean original
		JammoTrack* track;
		g_object_get(static_jammo_miditrack_view,"track",&track,NULL);
		jammo_instrument_track_set_event_list(JAMMO_INSTRUMENT_TRACK(track),NULL);

		//set to realtime
		jammo_instrument_track_set_realtime (JAMMO_INSTRUMENT_TRACK(track), TRUE);

		//Now all content in sequencer will play and instrument_track is recording
		jammo_sequencer_play (JAMMO_SEQUENCER (static_sequencer));
	}

}

//TODO: this signal should be removed when changing view.
static void instrument_gui_on_sequencer_stopped(JammoSequencer* sequencer, gpointer user_data) {
	printf("instrument_gui_on_sequencer_stopped\n");

	if (recording) {
		recording = FALSE;

		JammoTrack* track;
		g_object_get(static_jammo_miditrack_view,"track",&track,NULL);

		//set to non-realtime (unless we cant use jammo_miditrack_view_add_event_list)
		jammo_instrument_track_set_realtime (JAMMO_INSTRUMENT_TRACK(track), FALSE);

		//take all note-events from track
		GList* list= jammo_instrument_track_get_event_list(JAMMO_INSTRUMENT_TRACK(track));
		//Clean track
		jammo_instrument_track_set_event_list(JAMMO_INSTRUMENT_TRACK(track),NULL);
		//And put them back via miditrack_view
		jammo_miditrack_view_add_event_list(static_jammo_miditrack_view,list);


		//Start ad-hoc-sequencer
		jammo_sequencer_play  (JAMMO_SEQUENCER (ad_hoc_sequencer));
	}

}


void instrument_gui_start (JammoMiditrackView* miditrack_view, JammoSequencer* parameter_sequencer, gboolean slider)
{
	static_sequencer = parameter_sequencer;
	g_signal_connect(static_sequencer, "stopped", G_CALLBACK(instrument_gui_on_sequencer_stopped), NULL);

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	ClutterActor *view  = jammo_get_actor_by_id("instrument-view");
	clutter_actor_show(view);

	recording = FALSE;

	ad_hoc_sequencer = jammo_sequencer_new ();


	if (slider){ //TODO
		clutter_actor_hide(jammo_get_actor_by_id("instrument-two-rows-keyboard"));
	}

	else {
		//Take miditrack_view safe to static variable
		static_jammo_miditrack_view=miditrack_view;


		JammoTrack* track;
		g_object_get(miditrack_view,"track",&track,NULL);
		g_signal_connect (track, "report-note", G_CALLBACK (visualize_playback),NULL);

		int type;
		g_object_get(track,"instrument-type",&type,NULL);

		ad_hoc_instrument_track = jammo_instrument_track_new (type);

		jammo_instrument_track_set_realtime (ad_hoc_instrument_track, TRUE);
		jammo_sequencer_add_track (ad_hoc_sequencer, JAMMO_TRACK (ad_hoc_instrument_track));
	}


	jammo_sequencer_play (JAMMO_SEQUENCER (ad_hoc_sequencer)); //this is the non-recording ad-hoc-sequencer
	return;
}



