#include <math.h> //sin
#include <tangle.h>
#include <clutter/clutter.h>
#include <fcntl.h> //we check some files
#include <string.h>

#include "../jammo-cursor.h"
#include "../configure.h" //e.g. DATA_DIR
#include "../jammo-sample-button.h"
#include "../jammo-track-view.h"
#include "../jammo-mentor.h"
#include "../jammo.h"

#include "../../gems/gems.h"
#include "../../gems/groupmanager.h"

#include "../jammo-collaboration-pair-composition.h"

#include "chum.h"
#include "trafficlight_dialog.h"
#include "composition_game.h"


/*
This function is called when user chooses and clicks one theme in theme_selection (defined on themeselection-view.json).
Selected theme is 'name'-property of clicked button.
*/
void themeselection_theme_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(source));
	
	//subthemes are 1,2,3.
	int variation = (rand () % 3) + 1;
	printf("Random variation is '%d'\n",variation);
	
	composition_game_start_theme(name,variation,jammo_get_actor_by_id("themeselection-view"));

	//This is a previous view (themeselection-view). Hide it.
	ClutterActor* old_view;
	if ((old_view = jammo_get_actor_by_id("themeselection-view"))) {
		tangle_actor_hide_animated(TANGLE_ACTOR(old_view));
	}

}


static gboolean join_selected_game(TangleButton* tanglebutton, gpointer data){
	printf("join_selected_game pressed\n");
	//set this to client and join game
	gems_group_info * group = (gems_group_info*)data;
	guint id = group->id;
	guint owner = group->owner;
	
	// JammoCollaborationPairComposition should be created and stored
	JammoCollaborationPairComposition * pair_composition = jammo_collaboration_pair_composition_new();

	// TODO
	// theme and variation should be in song file and parsed from that
	
	// JammoCollaborationPairComposition should be started. Its start function
	// could change view or changing can be done differently
	// not hosting
	jammo_collaboration_pair_composition_start(pair_composition, FALSE, id, owner);
	//TODO store game somewhere in chum. it is stored in also gems because gems can not see chum
	// however it may not be the most logical way to get it from gems to chum

	return TRUE;
}


void themeselection_going_to (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("composing game clicked\n");

	//check if there are another jammo running (or another peerhood?)
	gboolean is_another_jammo_running = FALSE;
	
	// get list of jammos
	GList* jammo_list =gems_list_jammo_connections();
	if (g_list_length(jammo_list)>0) {
		// there are jammos
		is_another_jammo_running = TRUE;
	}
	else {
		// no jammo
		is_another_jammo_running = FALSE;
	}
	g_list_free(jammo_list);
	if (is_another_jammo_running) {
		ClutterActor* mainview;
		mainview = jammo_get_actor_by_id("main-views-widget");
		clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);


		ClutterActor* menu = jammo_get_actor_by_id("pairgamemenu-view");
		clutter_actor_show (CLUTTER_ACTOR(menu));


		//check if there are games running
		//and add them to scroll-area
		GList* group_list = gems_group_list_other_groups();
		gint number_of_pair_games=0;
		GList* list;
		GList* pair_game_list =NULL;
		for (list=group_list;list;list=list->next) {
		
			if (((gems_group_info*)(list->data))->type == GROUP_TYPE_PAIR) {
				number_of_pair_games++;
				// store pair games in list, so they can be shown to user
				pair_game_list=g_list_append(pair_game_list, ((gems_group_info*)(list->data)));
			}
		}		
		if (number_of_pair_games) {
			ClutterActor* container = jammo_get_actor_by_id("pair_game_menu_game_list");

			ClutterActor* icon;
			int counter=0;
			while (counter<number_of_pair_games)  {//for-each running game.
				// show pair games
				icon=tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/themes/city/110/beatbox.png", NULL)); //TODO: use avatar
				g_object_set(icon, "x", 100.0,  "y", 100.0 *(counter+1), NULL);
				guint * group_id = &(((gems_group_info*)(g_list_nth(pair_game_list, counter)->data))->id );
				printf("pair game: counter %d, pair games %d, group_id %u\n", counter, number_of_pair_games, *group_id);
				// give group as parameter for callback
				g_signal_connect (icon, "clicked", G_CALLBACK (join_selected_game),(gems_group_info*)(g_list_nth(pair_game_list, counter)->data));
				tangle_widget_add(TANGLE_WIDGET(container), icon, NULL);
				tangle_actor_show(TANGLE_ACTOR(icon));
				counter++;
			}

			clutter_actor_set_size(container, 672.0, 100.0 * counter);
		}
		g_list_free(pair_game_list);
		g_list_free(group_list);


	}
	else {   //no another player, just start normal themeselection
		tangle_action_execute(TANGLE_ACTION(jammo_get_actor_by_id("main-menu-composing-action")));
	}


}



void themeselection_create_game (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("create game\n");
	tangle_action_execute(TANGLE_ACTION(jammo_get_actor_by_id("main-menu-composing-action")));

	// TODO theme and variation
	JammoCollaborationPairComposition * pair_composition = jammo_collaboration_pair_composition_new();

	// starting the game should be done after theme and variation have been selected
	// so not in this file
	// theme menu should be informed about pair game

	// TODO set theme and variation this way, NOTE THAT THIS ONLY STORES THEME AND VARIATION
	// if storing is needed this does not have to be done at all
	/*char * theme = "test_theme";
	g_object_set(G_OBJECT(pair_composition),"theme",theme, NULL);
	int variation = 8;
	g_object_set(G_OBJECT(pair_composition),"variation",variation, NULL);*/

	// TODO start this way	
	// pair_composition is game object, TRUE means host, 0 parameters are ignored because they are used
	// only when joining
	jammo_collaboration_pair_composition_start(pair_composition, TRUE, 0, 0);

	// note that jammo_collaboration_pair_composition_start needs some work, it does not do much yet
}


