/** cem.h is part of JamMo.
License: GPLv2, read more from COPYING
*/
#ifndef _CEM_H_
#define _CEM_H_

//Log-message types. Influenced by log4j-type levels.
//LOG_TRACE   More detailed information.  //any use of this?
enum {
  LOG_DEBUG,   /*Detailed information on the flow through the system */
  LOG_INFO,    /*Interesting runtime events (startup/shutdown) */
  LOG_FATAL,   /*Severe errors that cause premature termination */
  LOG_ERROR,   /*Other runtime errors or unexpected conditions */
  LOG_WARN,    /*'Almost' errors, other runtime situations that are undesirable or unexpected */
  LOG_USER_ACTION,
  LOG_NETWORK, /*Networking info, e.g. new connection establishments, game starting etc. */
  LOG_NETWORK_DEBUG /* Networking debug */
};

void cem_add_to_log(char *message,int type);

#endif  /* _CEM_H_ */
