/*
 * jammo-collaboration-pair-composition.c
 *
 * This file is part of JamMo.
 *
 * (c) 2010 Lappeenranta University of Technology
 *
 * Authors: Mikko Gynther <mikko.gynther@lut.fi>
 */

#include "jammo-collaboration-game.h"
#include "jammo-collaboration-pair-composition.h"

G_DEFINE_TYPE(JammoCollaborationPairComposition, jammo_collaboration_pair_composition, JAMMO_TYPE_COLLABORATION_GAME);

#include "../meam/jammo-sequencer.h"
#include "../meam/jammo-backing-track.h"
#include "../chum/jammo-track-view.h"

#include "../gems/gems_definitions.h"
#include "../gems/groupmanager.h"
#include "../gems/gems.h"
#include "../gems/collaboration.h"

enum {
	PROP_0,
	PROP_OWN_TRACK_VIEW,
	PROP_PEER_TRACK_VIEW
};

struct _JammoCollaborationPairCompositionPrivate {

	JammoTrackView * own_track_view;
	JammoTrackView * peer_track_view;
	guint peer_user_id;
};


JammoCollaborationPairComposition* jammo_collaboration_pair_composition_new() {
	return JAMMO_COLLABORATION_PAIR_COMPOSITION(g_object_new(JAMMO_TYPE_COLLABORATION_PAIR_COMPOSITION, NULL));
}

ClutterActor* user_id_to_track(guint user_id);

static void jammo_collaboration_pair_composition_add_jammo_sample_button_remote(GObject * game, guint user_id, guint loop_id, guint slot) {

	JammoCollaborationPairComposition * collaboration_pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(game);

	//ClutterActor* track_view = user_id_to_track(user_id);
	printf("remote sample, uid %u, loop_id %u, slot %u\n", user_id, loop_id, slot);

	//TODO: loop_id --> sample_button
	JammoSampleButton* sample_button = JAMMO_SAMPLE_BUTTON(jammo_sample_button_new_from_files(
"/opt/jammo/themes/animal/140/flamingo.png", "/opt/jammo/themes/animal/140/animalw_140_marimba_2.wav"));

	jammo_track_view_add_jammo_sample_button(collaboration_pair_composition->priv->peer_track_view, sample_button, slot);
}

static void jammo_collaboration_pair_composition_remove_jammo_sample_button_remote(GObject * game, guint user_id, guint slot) {
	JammoCollaborationPairComposition * collaboration_pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(game);

	jammo_track_view_remove_jammo_sample_button_from_slot(collaboration_pair_composition->priv->peer_track_view, slot);
}


static void jammo_collaboration_pair_composition_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec) {
	JammoCollaborationPairComposition * collaboration_pair_composition;
	
	collaboration_pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(object);

	
	switch (prop_id) {
		case PROP_OWN_TRACK_VIEW:
			if (collaboration_pair_composition->priv->own_track_view!=NULL) {
				g_object_unref(collaboration_pair_composition->priv->own_track_view);
			}
			if (JAMMO_IS_TRACK_VIEW(g_value_get_object(value))) {
				collaboration_pair_composition->priv->own_track_view = JAMMO_TRACK_VIEW(g_value_get_object(value));
			}
			else {
				collaboration_pair_composition->priv->own_track_view = NULL;
			}
			break;
		case PROP_PEER_TRACK_VIEW:
			if (collaboration_pair_composition->priv->peer_track_view!=NULL) {
				g_object_unref(collaboration_pair_composition->priv->peer_track_view);
			}
			if (JAMMO_IS_TRACK_VIEW(g_value_get_object(value))) {
				collaboration_pair_composition->priv->peer_track_view = JAMMO_TRACK_VIEW(g_value_get_object(value));
				//Callback for multiplaying
				gems_set_callback_add_loop(jammo_collaboration_pair_composition_add_jammo_sample_button_remote);
				gems_set_callback_remove_loop(jammo_collaboration_pair_composition_remove_jammo_sample_button_remote);
			}
			else {
				collaboration_pair_composition->priv->peer_track_view = NULL;
			}
			break;
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
			break;
	}
}

static void jammo_collaboration_pair_composition_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
	JammoCollaborationPairComposition * collaboration_pair_composition;
	
	collaboration_pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(object);

	switch (prop_id) {
		case PROP_OWN_TRACK_VIEW:
			g_value_set_object(value, collaboration_pair_composition->priv->own_track_view);
			break;
		case PROP_PEER_TRACK_VIEW:
			g_value_set_object(value, collaboration_pair_composition->priv->peer_track_view);
			break;
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
			break;
	}
}

// implementations for base class functions

// implementation for teacher exit
void jammo_collaboration_pair_composition_teacher_exit(JammoCollaborationGame * collaboration_game) {
	JammoCollaborationPairComposition * pair_composition;
	pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(collaboration_game);
	
	// TODO implement teacher exit
	printf("jammo_collaboration_pair_composition_teacher_exit called\n");
}

// create_song_file
// return values 0 success, 1 can not open file
int jammo_collaboration_pair_composition_create_song_file(JammoCollaborationGame * collaboration_game) {
	JammoCollaborationPairComposition * pair_composition;
	pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(collaboration_game);
	// TODO implement
	printf("jammo_collaboration_pair_composition_create_song_file called\n");

	return 0;
}

static GObject* jammo_collaboration_pair_composition_constructor(GType type, guint n_properties, GObjectConstructParam* properties) {
	GObject* object;
	JammoCollaborationPairComposition * collaboration_pair_composition;
	
	object = G_OBJECT_CLASS(jammo_collaboration_pair_composition_parent_class)->constructor(type, n_properties, properties);

	collaboration_pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(object);
	collaboration_pair_composition->priv->own_track_view=NULL;
	collaboration_pair_composition->priv->peer_track_view=NULL;
	collaboration_pair_composition->priv->peer_user_id=0;

	return object;
}


static void jammo_collaboration_pair_composition_finalize(GObject* object) {
	JammoCollaborationPairComposition* collaboration_pair_composition;
	
	collaboration_pair_composition = JAMMO_COLLABORATION_PAIR_COMPOSITION(object);

	G_OBJECT_CLASS(jammo_collaboration_pair_composition_parent_class)->finalize(object);
}

static void jammo_collaboration_pair_composition_dispose(GObject* object) {
	G_OBJECT_CLASS(jammo_collaboration_pair_composition_parent_class)->dispose(object);
}

static void jammo_collaboration_pair_composition_class_init(JammoCollaborationPairCompositionClass* collaboration_pair_composition_class) {
	printf("class init\n");
	GObjectClass* gobject_class = G_OBJECT_CLASS(collaboration_pair_composition_class);
	JammoCollaborationGameClass* collaboration_game_class = JAMMO_COLLABORATION_GAME_CLASS(collaboration_pair_composition_class);

	gobject_class->constructor = jammo_collaboration_pair_composition_constructor;
	gobject_class->finalize = jammo_collaboration_pair_composition_finalize;
	gobject_class->dispose = jammo_collaboration_pair_composition_dispose;
	gobject_class->set_property = jammo_collaboration_pair_composition_set_property;
	gobject_class->get_property = jammo_collaboration_pair_composition_get_property;

	collaboration_game_class->teacher_exit = jammo_collaboration_pair_composition_teacher_exit;
	collaboration_game_class->create_song_file = jammo_collaboration_pair_composition_create_song_file;

	g_object_class_install_property(gobject_class, PROP_OWN_TRACK_VIEW,
	                                g_param_spec_object("own-track-view",
	                                "Own track view",
	                                "Player's own track view",
	                                JAMMO_TYPE_TRACK_VIEW, G_PARAM_READABLE | G_PARAM_WRITABLE));

	g_object_class_install_property(gobject_class, PROP_PEER_TRACK_VIEW,
	                                g_param_spec_object("peer-track-view",
	                                "Peer track view",
	                                "Peer's track view",
	                                JAMMO_TYPE_TRACK_VIEW, G_PARAM_READABLE | G_PARAM_WRITABLE));

	g_type_class_add_private(gobject_class, sizeof(JammoCollaborationPairCompositionPrivate));
}

static void jammo_collaboration_pair_composition_init(JammoCollaborationPairComposition* collaboration_pair_composition) {
	collaboration_pair_composition->priv = G_TYPE_INSTANCE_GET_PRIVATE(collaboration_pair_composition, JAMMO_TYPE_COLLABORATION_PAIR_COMPOSITION, JammoCollaborationPairCompositionPrivate);
}

// function prototypes
void jammo_collaboration_pair_composition_on_sequencer_stopped_recording(JammoSequencer* sequencer, gpointer data);
int create_mix_of_pair_composition(gpointer data);
void exit_pair_composition(JammoCollaborationPairComposition * collaboration_pair_composition);
static void clean_up(JammoCollaborationPairComposition * collaboration_pair_composition);

// functions needed in pair composition

void jammo_collaboration_pair_composition_on_sequencer_stopped_recording(JammoSequencer* sequencer, gpointer data) {

	// uncomment to use object
	/*JammoCollaborationPairComposition * collaboration_pair_composition = (JammoCollaborationPairComposition *)data;*/

	// uncomment adding callback to start generating mix of pair composition
	/*g_timeout_add_full(G_PRIORITY_DEFAULT,100,(GSourceFunc)create_mix_of_pair_composition,collaboration_pair_composition,NULL);*/
	
}

int create_mix_of_pair_composition(gpointer data) {
	static JammoCollaborationPairComposition * collaboration_pair_composition;

	collaboration_pair_composition = (JammoCollaborationPairComposition *)data;

	JammoSequencer * sequencer;
	g_object_get(collaboration_pair_composition, "sequencer", &sequencer, NULL);

	gchar * mix_location;
	g_object_get(collaboration_pair_composition, "mix-location", &mix_location, NULL);

	// TODO check state and do not change mode many times
	if (0) {
		// change sequencer to file mode
		if (jammo_sequencer_file_mode(sequencer, mix_location)==0) {
			printf("sequencer changed to file mode successfully\n");
		}
	}

	// playback will now create a file
	jammo_sequencer_play(sequencer);

	if (1 /* stopped */){

		exit_pair_composition(collaboration_pair_composition);
		return 0;
	}

	// still generating mix file
	return 1;
}

// function for exiting pair_composition
// this can be used to call main menu or something else
void exit_pair_composition(JammoCollaborationPairComposition * collaboration_pair_composition) {
	// unref sequencer and tracks
	clean_up(collaboration_pair_composition);
}

int jammo_collaboration_pair_composition_start(JammoCollaborationPairComposition * collaboration_pair_composition, gboolean host) {

	// this is how to add callback functions to main loop
	/*g_timeout_add_full(G_PRIORITY_DEFAULT,100,(GSourceFunc)create_mix_of_pair_composition,collaboration_pair_composition,NULL);*/

	gems_components * gems_data = gems_get_data();

	if (host) {
		printf("***HOST\n");

		collaboration_start_pair_game(1, 1,gems_data);
		// use a callback to get peer_id when peer joins
		g_timeout_add_full(G_PRIORITY_DEFAULT,1000,(GSourceFunc)jammo_collaboration_pair_composition_peer_id_callback, collaboration_pair_composition, NULL);
	}

	else {
		printf("***CLIENT\n");
		// Returns a copy of the group list
		GList* list =gems_group_list_other_groups();
		printf("length %d\n",g_list_length(list));
		GList* l;
		for (l=list;l;l=l->next) {
		
			gems_group_join_to_group( ((gems_group_info*)(l->data))->id);
			collaboration_pair_composition->priv->peer_user_id = ((gems_group_info*)(l->data))->owner;
		}
		g_list_free(list); // Free the copy of the list
	}

	// set pair composition to gems
	gems_data->service_collaboration->collaboration_game=G_OBJECT(collaboration_pair_composition);

  return 0;
}

// unrefs sequencer and tracks which should cause deletion of those objects
static void clean_up(JammoCollaborationPairComposition * collaboration_pair_composition) {
	JammoSequencer * sequencer;
	g_object_get(collaboration_pair_composition,"sequencer",&sequencer, NULL);

	// unref sequencer. this unrefs the tracks also and should delete all objects
	g_object_unref(sequencer);
	g_object_set(G_OBJECT(collaboration_pair_composition),"sequencer",NULL, NULL);
}

int jammo_collaboration_pair_composition_peer_id_callback(JammoCollaborationPairComposition * collaboration_pair_composition) {
 
	guint32* plist = gems_group_get_group_members();
	printf("callback running\n");
	if(plist[0] != FREE_SLOT)
	{
		guint peer_user_id = plist[0];
		printf("got peer id %u\n", peer_user_id);
		collaboration_pair_composition->priv->peer_user_id=peer_user_id;
		return 0;
	}
	return 1;
}


