/*
 * This file is part of JamMo.
 *
 * Instrument_gui is realtime 'jamming' UI. Only way to start instrument_gui is
 * give JammoMiditrackView. During jamming it is not used, but there are own
 * tracks and sequencer.
 * When jamming is end, notes in internal track is added to given JammoMiditrackView.
 *
 * (c) 2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */

#include <tangle.h>
#include <glib-object.h>
#include <ctype.h>
#include <string.h>
#include <clutter/clutter.h>

#include "../../meam/jammo-meam.h"
#include "../../meam/jammo-instrument-track.h"
#include "../../meam/jammo-midi.h"
#include "../jammo-chum.h"
#include "../jammo.h"
#include "../jammo-miditrack-view.h"

#include "midi_editor.h"



static JammoInstrumentTrack *instrument_track;
static JammoSequencer *sequencer;

static gboolean jamming_started; //Not yet in use. TODO

static JammoMiditrackView* static_jammo_miditrack_view;


static void
instrument_click (ClutterActor * actor, ClutterEvent * event, gpointer data)
{
  //printf("instrument_pressed\n");
  int octave = GPOINTER_TO_INT (data) / 100;
  int note = GPOINTER_TO_INT (data) - 100 * octave;
  char notename = note+octave*12;

  jammo_instrument_track_note_on_realtime (instrument_track, notename);
}

static void
instrument_release (ClutterActor * actor, ClutterEvent * event, gpointer data)
{
  //printf("instrument_released\n");
  int octave = GPOINTER_TO_INT (data) / 100;
  int note = GPOINTER_TO_INT (data) - 100 * octave;
  char notename = note+octave*12;

  jammo_instrument_track_note_off_realtime (instrument_track, notename);
}


//TODO: keyboard buttons
static ClutterActor *
make_instrument_grid (int type)
{
  //regarding what instrument we are using, make boxes.
  int min_j, max_j;
  if (type == 0)
    {
      min_j = 3;
      max_j = 7;
    }
  else if (type == 1)
    {
      min_j = 1;
      max_j = 2;
    }
  else if (type == 2)
    {
      min_j = 2;
      max_j = 6;
    }
  else
    {
      min_j = 0;
      max_j = 8;
    }
  ClutterColor transparency = { 255, 255, 255, 0 };
  ClutterColor dark_color = { 25, 25, 12, 255 };
  ClutterActor *container = clutter_group_new ();
  int i;
  int j;
  // width / notes = 800/12 =66.  600/12 = 50
  // height / octaves = 480/8 = 60
  for (i = 0; i < 12; i++)
    {
      for (j = min_j; j < max_j; j++)
	{
	  if (type == 0 && j == 6 && i > 0)	//Flute doesn't have these notes
	    continue;
	  if ((type == 1 && i == 1) || (type == 1 && i == 3))	//Drumkit doesn't have these notes
	    continue;
	  if (type == 2 && j == 5 && i > 0)	//Ud doesn't have these notes
	    continue;
	  ClutterActor *box =
	    clutter_rectangle_new_with_color (&transparency);
	  clutter_rectangle_set_border_color (CLUTTER_RECTANGLE (box),
					      &dark_color);
	  clutter_rectangle_set_border_width (CLUTTER_RECTANGLE (box), 1);
	  clutter_actor_set_size (box, 50, 60);
	  clutter_actor_set_position (box, 50 * i, 60 * j);
	  clutter_actor_show (box);
	  clutter_container_add_actor (CLUTTER_CONTAINER (container), box);
	  clutter_actor_set_reactive (box, TRUE);
	  g_signal_connect (box, "button-press-event",
			    G_CALLBACK (instrument_click),
			    GINT_TO_POINTER (j * 100 + i));
		g_signal_connect (box, "button-release-event",
			    G_CALLBACK (instrument_release),
			    GINT_TO_POINTER (j * 100 + i));
	}
    }
  return container;
}

//TODO
void instrument_metronome_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("on_metronome_button_clicked\n");
}


static void end_jamming() {
	//hide instrument_view
	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), chum_hide_this_tangle_actor, NULL);

	//Copy played notes to track:
	GList* list= jammo_instrument_track_get_event_list(JAMMO_INSTRUMENT_TRACK(instrument_track));
	jammo_miditrack_view_add_event_list(static_jammo_miditrack_view,list);

}

void instrument_goeditor_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("on_go_editor_button_clicked\n");
	end_jamming();

	//start editor
	midi_editor_start_with_miditrack_view(static_jammo_miditrack_view);
}


void instrument_gosequencer_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("instrument_gosequencer_clicked\n");
	end_jamming();

	//show sequencer
	ClutterActor* view = jammo_get_actor_by_id("fullsequencer-view");
	clutter_actor_show(view);
}


void instrument_play_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("play pressed\n");
	//jammo_sequencer_play(JAMMO_SEQUENCER(user_data));


	//Make AD-HOC sequencer and track to listen realtime track.
	//In this way it will not brake any other tracks
	GList* list= jammo_instrument_track_get_event_list(JAMMO_INSTRUMENT_TRACK(instrument_track));

	JammoSequencer* seq= jammo_sequencer_new();
	JammoInstrumentTrack*  playback_instrument_track = jammo_instrument_track_new (2); //TODO. check type

	jammo_instrument_track_set_realtime (playback_instrument_track, FALSE);
	jammo_sequencer_add_track (seq, JAMMO_TRACK (playback_instrument_track));
	jammo_instrument_track_set_event_list(playback_instrument_track, list);

	jammo_sequencer_play(JAMMO_SEQUENCER(seq));
}


void instrument_record_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("on_record_button_clicked\n");
	jammo_sequencer_stop (JAMMO_SEQUENCER (sequencer));
	jammo_sequencer_play (JAMMO_SEQUENCER (sequencer));
}


void instrument_gui_start (JammoMiditrackView* miditrack_view)
{
	static_jammo_miditrack_view=miditrack_view;

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), chum_hide_this_tangle_actor, NULL);

	ClutterActor *view  = jammo_get_actor_by_id("instrument-view");
	clutter_actor_show(view);

	jamming_started = FALSE;

	int type = 2;  //0= flute, 1=drumkit ,2=ud
	sequencer = jammo_sequencer_new ();
	instrument_track = jammo_instrument_track_new (type);

	jammo_instrument_track_set_realtime (instrument_track, TRUE);
	jammo_sequencer_add_track (sequencer, JAMMO_TRACK (instrument_track));



	ClutterActor* keyboard_area = make_instrument_grid (type);
	clutter_container_add (CLUTTER_CONTAINER (view), keyboard_area, NULL);
	clutter_actor_set_size(keyboard_area, 600.0,480.0);
	clutter_actor_set_position(keyboard_area, 0.0,20.0); //Top of screen will be timeline/cursor. TODO

	jammo_sequencer_play (JAMMO_SEQUENCER (sequencer));

	return;
}
