/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */

#include <glib-object.h>
//#include <clutter/clutter.h>
#include <math.h>
#include <string.h>

#include <tangle.h>

#include "../../meam/jammo-meam.h"
#include "../jammo.h"
#include "../jammo-mentor.h"
#include "../jammo-track-view.h"
#include "../jammo-miditrack-view.h"


#include "sequencer.h"
#include "sequencer_loop.h"
#include "sequencer_general.h"
#include "sequencer_track_view.h"
#include "startmenu.h"


static void load_state_from_file(FILE *ifp) {
	gboolean not_ready = TRUE;

	int bytes_read;

	size_t nbytes = 256; //No field can have this many characters
	char *my_string;
	my_string = (char *) malloc (nbytes + 1);

	int slot;
	char* wav_name = malloc (nbytes + 1);
	char* png_name = malloc (nbytes + 1);

	while (not_ready) {

		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0)
		{
			not_ready=FALSE;
			continue;
		}
		ClutterActor* track_view = NULL; //Will be jammo_trac_view or jammo_miditrack_view

		if(strncmp(my_string, "Track-type:", 11) == 0) {
			printf("New track.\n");

			/* TODO: Do we know the total length of the song (and thus, this track)? */
			track_view=sequencer_track_view_add_with_type(my_string +12, JAMMO_DURATION_INVALID); //Ugly!
		} else {
				if (JAMMO_IS_MIDITRACK_VIEW(track_view)) {
					bytes_read = getline (&my_string, &nbytes, ifp);
					if (bytes_read <= 0) {
						not_ready=FALSE;
						continue;
					}
				char* note_file= malloc (nbytes + 1);
				strncpy(note_file, my_string, strlen(my_string)-1); //throw end-of-line away
				note_file[strlen(my_string)-1]='\0';                //Add string terminator

				printf("loading notes from file '%s'\n",note_file);
				GList* events = jammomidi_file_to_glist(note_file);
				jammo_miditrack_view_add_event_list(JAMMO_MIDITRACK_VIEW(track_view),events);

				} else {
						printf("New sample to slot.\n");
						slot = atoi(my_string);
						printf("Slot: %d\n", slot);
						//sound filename
						bytes_read = getline (&my_string, &nbytes, ifp);
						if (bytes_read <= 0)
						{
							not_ready=FALSE;
							continue;
						}
						strncpy(wav_name, my_string, strlen(my_string)-1); //throw end-of-line away
						wav_name[strlen(my_string)-1]='\0';                //Add string terminator

						printf("name of soundfile='%s'\n",wav_name);


						//image filename
						bytes_read = getline (&my_string, &nbytes, ifp);
						if (bytes_read <= 0)
							{
							not_ready=FALSE;
							continue;
							}
						strncpy(png_name, my_string, strlen(my_string)-1); //throw end-of-line away
						png_name[strlen(my_string)-1]='\0';                //Add string terminator

						printf("name of pngfile='%s'\n",png_name);

						//Make sample_button and put it into track.
						ClutterActor* sample_button;
						sample_button = jammo_sample_button_new_from_files(png_name, wav_name);
						printf("Sample button created\n");
						jammo_track_view_add_jammo_sample_button(JAMMO_TRACK_VIEW(track_view),JAMMO_SAMPLE_BUTTON(sample_button), slot);

						}
			}
	}
}



gboolean sequencer_change_to_loop_view(TangleActor *actor, gpointer data) {
	printf("changing view to loop \n");
	ClutterActor* scrolling_actor = jammo_get_actor_by_id("fullsequencer-scroller");
	clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-y", 0.0, NULL);
	return TRUE;
}

gboolean sequencer_change_to_sequencer_view(TangleActor *actor, gpointer data) {
	printf("changing view to sequencer \n");
	ClutterActor* scrolling_actor = jammo_get_actor_by_id("fullsequencer-scroller");
	clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-y", 480.0, NULL);
	return TRUE;
}

gboolean sequencer_change_to_bottom_view (TangleActor *actor, gpointer data) {
	printf("changing view to bottom \n");
	ClutterActor* scrolling_actor = jammo_get_actor_by_id("fullsequencer-scroller");
	clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-y", 960.0, NULL);
	return TRUE;
}

void start_sequencer(gpointer filename)
{
	JammoSequencer* sequencer = jammo_sequencer_new ();
	inputFilename = NULL; //from sequencer.h FIXME
	printf("Starting sequencer GUI\n");

	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), chum_hide_this_tangle_actor, NULL);

	ClutterActor* view = jammo_get_actor_by_id("fullsequencer-view");
	clutter_actor_show(view);


	//sequencer_track_view uses internally this just created area.
	ClutterActor* sequencer_view = sequencer_track_view_create_area_for_tracks(sequencer);
	tangle_widget_add(TANGLE_WIDGET(jammo_get_actor_by_id("fullsequencer-container-for-tracks")), sequencer_view,NULL);


	//Tune some things that can't be done with JSON only (TODO)
	sequencer_loop_tune_wheels();

	//TODO. these can be done with JSON
	sequencer_general_tune_containers();


	//Loading tracks from file:
	if(filename) {
		inputFilename = malloc(strlen((gchar*) filename) + 1);
		memcpy(inputFilename, (gchar*) filename, strlen((gchar*) filename) + 1);
		printf("The filename is '%s'\n",inputFilename);

		FILE *ifp;
		ifp = fopen(inputFilename, "r"); //currently open only for reading

		if(ifp != NULL) {
			load_state_from_file(ifp);
		}
	} else {
		printf("No file specified for sequencer.\n");
	}



	sequencer_change_to_sequencer_view(NULL,NULL); //Start to middle view.
}

/*
void leave_sequencer()
{
	clutter_actor_hide(CLUTTER_ACTOR(sequencer_view));

	start_startmenu();
}
*/

