/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "gamesmenu.h"
#include "startmenu.h"
#include "../jammo.h"

#include "../jammo-game-task.h"
#include "../jammo-game-level.h"
#include "../jammo-game-level-view.h"


/*  TODO: use signal in json
//return to startmenu
static gboolean goto_startmenu(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	clutter_actor_hide(gamesmenu_group);
	show_startmenu();
	return TRUE;
}*/

gboolean start_gamesmenu()
{
	printf("Starting gamesmenu\n");

	ClutterActor* mainview;

	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	//tangle_view_load_now(TANGLE_VIEW(jammo_get_actor_by_id("fullsequencer-view"))); //FIXME: If fullsequencer is loaded now, it will not be visible when showed.
	clutter_actor_show (jammo_get_actor_by_id("gamesmenu-view"));

	return FALSE;
}

void start_level_composing(TangleButton* button,gpointer data) {
	tangle_view_load_now(TANGLE_VIEW(jammo_get_actor_by_id("level1-view")));
	jammo_game_level_start_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")),"level1-task1.json");
	clutter_actor_show(jammo_get_actor_by_id("fullsequencer-view"));

	clutter_actor_hide(jammo_get_actor_by_id("gamesmenu-view"));
	tangle_view_unload(TANGLE_VIEW(jammo_get_actor_by_id("gamesmenu-view")));

}

gboolean on_start_button_clicked(JammoGameLevel* game_level, TangleButton* button) {
	const gchar* name;
	name = clutter_actor_get_name(CLUTTER_ACTOR(button));
	printf("name is '%s'\n",name);


	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);


	jammo_game_level_start_task(game_level, name);
	clutter_actor_show(jammo_get_actor_by_id("fullsequencer-view"));

	return FALSE;
}


void all_levels_completed(JammoGameLevel* game_level) {
	g_print("MENTOR: Now you have gone through all game levels! Feel free to do whatever you want now on...\n");
}
