#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <clutter/clutter.h>
#include <string.h>
#include "../../gems/gems_profile_manager.h"
#include "config.h"
#include "screens.h"
#include "../jammo.h"


char* pg_itoa(int value, char* result, int base) {
		// check that the base if valid
		if (base < 2 || base > 36) { *result = '\0'; return result; }
	
		char* ptr = result, *ptr1 = result, tmp_char;
		int tmp_value;
	
		do {
			tmp_value = value;
			value /= base;
			*ptr++ = "zyxwvutsrqponmlkjihgfedcba9876543210123456789abcdefghijklmnopqrstuvwxyz" [35 + (tmp_value - value * base)];
		} while ( value );
	
		// Apply negative sign
		if (tmp_value < 0) *ptr++ = '-';
		*ptr-- = '\0';
		while(ptr1 < ptr) {
			tmp_char = *ptr;
			*ptr--= *ptr1;
			*ptr1++ = tmp_char;
		}
		return result;
}

gchar convert_to_char(int i)
{
	switch(i)
	{
		case 1:
			return '1';
		case 2:
			return '2';
		case 3:
			return '3';
		case 4:
			return '4';
		case 5:
			return '5';
		case 6:
			return '6';
		case 7:
			return '7';
		case 8:
			return '8';
		case 9:
			return '9';
		default:
			return '0';
		
	}
	

}

gchar *pg_convert_points_to_string(int *array, int array_len)
{	
		
	int i;
	int j;	
	int k=0;
	
	gchar *password=g_malloc((array_len+1) * sizeof(gchar));
	//buff_char =pg_itoa(array[1],buff_char,10);

	for (i=0; i<array_len; i++)
	{
		j=array[i];
		//	pg_itoa(j,c,10);	
		password[i]=convert_to_char(j);
		//g_print("NEW PASSWORD:%c\n",c);
		k++;			
	}	
	
	
	password[k]='\0';
	
	
	return password;
}


gboolean pg_save_passwd (gchar *passwd)
{
	FILE *passwd_F;
	gchar *filepath = PG_PASSWORD_TEXT_FILE;
	passwd_F = fopen(filepath, "w");
  	if(passwd_F ==NULL) {
    		g_print("Cannot open passwords file..\n");
    		exit(EXIT_FAILURE);
	}	
	g_fprintf(passwd_F, "%s",passwd);
	fclose(passwd_F);
	return TRUE;
}

gchar *pg_read_passwd_from_file()
{
	FILE *passwd_F;
	gchar *filepath = PG_PASSWORD_TEXT_FILE;
	passwd_F=fopen(filepath,"rt");
	if ( passwd_F != NULL ) 
	{
		gchar string[100];
		gchar *buffer = g_malloc(40*sizeof(gchar));
		gchar* result = fgets(string, 20, passwd_F);
		printf("Fgets returns: '%s' \n",result);
		
		fclose(passwd_F);		
		buffer=string;
		
		//g_print("READ PASSWORD: %s\n", buffer);
		return buffer;
		//return "1236";
	} else {
		 perror (filepath);
		return "error cannot read file";
	}
}

gboolean pg_validate_passwd (ClutterActor *stage, gchar *password, int is_new)
{
	//is_new 0 for reset password, 1 for existing password
	if (is_new==1) {
		//VALIDATE PASSWORD MISSING 

		pg_save_passwd (password);		
		pg_set_reset_success_screen(stage, PG_RESET_PASSWORD_SUCCESS);		
		//pg_set_error_screen(stage, PG_RESET_PASSWORD_ERROR);
		
		return TRUE;
	}else //if(is_new==1)
	{
		gchar *user_passwd;//=g_malloc(40*sizeof(gchar));				
		user_passwd=pg_read_passwd_from_file();		
		if (strcmp(password,user_passwd)==0) {
			 clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
 			clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));				
		}
		else
		{
			pg_set_error_screen(stage, PG_PASSWORD_ERROR);
		}
		return TRUE;	
	}
	
}


int *get_user_passwd()
{
	//Should read passwords as strings from profiler


	int user_id;
	gchar *username="Guest";
	gchar *passworddata="password";
	gint dummy_login;
	user_id = gems_profile_manager_get_userid(NULL);
	dummy_login=gems_profile_manager_login(user_id, username,passworddata);
	if(dummy_login)
	{
		//g_print("DUMMY LOGIN BAD\n");
	} else {
		//g_print("DUMMY LOGIN GOOD\n");
	}
	int *pass_arr;
	pass_arr=malloc(4*sizeof*pass_arr);
	pass_arr[0]=1;
	pass_arr[1]=2;
	pass_arr[2]=3;
	pass_arr[3]=6;
	return pass_arr;
}

