#include "jammo-chum.h"
#include <tangle.h>

#include "../configure.h" //e.g. DATA_DIR
#include "jammo-track-view.h"
#include "jammo-miditrack-view.h"
#include "../meam/jammo-slider-track.h"
#include "../meam/jammo-backing-track.h"


//These macros are there because there could be something extra in sequencer_widget which is passed as parameter.
//We do not do anything unless we are sure we have correct real JAMMO_TRACK.

//With first track, start only with linebreak, another add comma and then linebreak
#define FIRST_TRACK_STARTS_WITHOUT_COMMA \
	fprintf(ofp,first_track?"":",\n"); \
	first_track=FALSE;

#define WRITE_VOLUME_AND_MUTED \
	gboolean something_writted=FALSE; \
	if (jammo_playing_track_get_volume(JAMMO_PLAYING_TRACK(track))!= 1.0) {\
		gint buf_len = 10; \
		gchar buffer[buf_len]; \
		gchar* volume = g_ascii_dtostr (buffer, buf_len,jammo_playing_track_get_volume(JAMMO_PLAYING_TRACK(track))); \
		fprintf(ofp,",\n\t\"volume\" : %s\n",volume); \
		something_writted=TRUE; \
		}\
	if (jammo_playing_track_get_muted(JAMMO_PLAYING_TRACK(track))) {\
			fprintf(ofp,",\n\t\"muted\" : \"true\"\n"); \
			something_writted=TRUE; \
			} \
	if (!something_writted) {\
		fprintf(ofp,"\n"); \
	}

/*
-Final filename starts with JAMMO_DIRECTORY,COMPOSITIONS_DIRECTORY
-sequencer_widget must be TangleWdiget and contain track_views and miditrack_view, etc.

-user_metadata will be something differencies between 3-6 game and 7-12 game.
 3-6 game contains info about theme_name and variation
 7-12 game contains info about pitch and tempo
*/

gboolean save_composition(gchar* to_filename, ClutterActor* sequencer_widget, gchar* user_metadata) {
	printf("Saving composition.\n");

	//Generate filename baesd on timestamp
	time_t rawtime;
	struct tm * timeinfo;
	char timestamp_now [80];
	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
	strftime (timestamp_now,80,"%Y.%m.%d_%H.%M.%S",timeinfo);


	guint miditrack_count=0;
	guint slidertrack_count=0;

	FILE* ofp;
	gchar* outputFilename;

	outputFilename = g_strdup_printf("%s/last_composition.json", JAMMO_DIRECTORY);

	ofp = fopen(outputFilename, "w");
	g_free(outputFilename);
	g_return_val_if_fail(ofp != NULL, FALSE);

	//'Header'
	fprintf(ofp,"{\n");

	//Metadata
	fprintf(ofp,"%s\n",user_metadata);

	fprintf(ofp,"\"Author\" : \"%s\",\n","author");   //TODO: add author
	fprintf(ofp,"\n");


	//Tracks
	fprintf(ofp,"\"tracks\" : [");
	JammoTrack* track;

	gboolean first_track = TRUE;
	GList* children_view;
	for (children_view = tangle_widget_get_children_readonly(TANGLE_WIDGET(sequencer_widget)); children_view; children_view = children_view->next) {

		ClutterActor* track_view = children_view->data;
		/* //There are something non-track_views on container. FIXME
		if (TANGLE_IS_SCROLLING_ACTOR(track_view)){
			fprintf(ofp,"(scroller)\n");
			continue;
		}
		*/


		if (JAMMO_IS_TRACK_VIEW(track_view)){
			FIRST_TRACK_STARTS_WITHOUT_COMMA

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"EditingTrack\",\n");

			g_object_get(track_view,"track",&track,NULL);

			JammoSampleType type;
			g_object_get(track_view,"sample-type", &type,NULL);

			GEnumClass* enum_class = G_ENUM_CLASS(g_type_class_ref(JAMMO_TYPE_SAMPLE_TYPE));
			GEnumValue* enum_value = g_enum_get_value(enum_class, type);
			g_type_class_unref(enum_class);
			if (enum_value) {
				const gchar* nick = enum_value->value_nick;
				fprintf(ofp,"\t\"editing-track-type:\" : \"%s\",\n",nick);
			}

			fprintf(ofp,"\t\"samples\" : [\n");

			gfloat slot_size;
			g_object_get(track_view,"slot-width",&slot_size,NULL);
			printf("slot_size '%lf'\n",slot_size);

			GList* children;
			JammoSampleButton* jsb;
			gboolean first = TRUE;

			for (children = tangle_widget_get_children_readonly(TANGLE_WIDGET(track_view)); children; children = children->next)
				{
				if (!first)
					fprintf(ofp,",\n");
				first=FALSE;
				jsb = JAMMO_SAMPLE_BUTTON(children->data);
				//printf("x: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb)));
				printf("slot: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
				fprintf(ofp,"\t\t{\n");
				gint loop_id;
				g_object_get(jsb, "loop_id", &loop_id, NULL);
				fprintf(ofp,"\t\t\"loop_id\" : %d,\n",loop_id);

				gint slot = clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size;
				fprintf(ofp,"\t\t\"slot\" : %d\n",slot);
				fprintf(ofp,"\t\t}");
				}
		fprintf(ofp,"\n\t]");
		WRITE_VOLUME_AND_MUTED
		fprintf(ofp,"\t}");
		} //Jammo-Track-View ends


		else if (JAMMO_IS_MIDITRACK_VIEW(track_view)){
			 FIRST_TRACK_STARTS_WITHOUT_COMMA

			g_object_get(track_view,"track",&track,NULL);
			int type;
			g_object_get(track,"instrument-type",&type,NULL);

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"VirtualInstrumentTrack\",\n");
			fprintf(ofp,"\t\"instrument\" : %d",type);

			GList* list= jammo_instrument_track_get_event_list(JAMMO_INSTRUMENT_TRACK(track));
			if (list) {
				//fullpath!
				gchar* name_for_notes = g_strdup_printf("%s/%s%s-midi%d.txt",COMPOSITIONS_DIRECTORY,to_filename,timestamp_now,miditrack_count);
				miditrack_count++;
				jammomidi_glist_to_file(list, name_for_notes);

				fprintf(ofp,",\n\t\"note-file\" : \"%s\"",name_for_notes);
				g_free(name_for_notes);
			}
			WRITE_VOLUME_AND_MUTED
			fprintf(ofp,"\t}");
		}//Jammo-Midtrack-View ends

		else if (TANGLE_IS_WIDGET(track_view)){

			track = g_object_get_data(G_OBJECT(track_view), "track");

			if (JAMMO_IS_SLIDER_TRACK(track)) {
			FIRST_TRACK_STARTS_WITHOUT_COMMA
			int type;
			g_object_get(track,"slider-type",&type,NULL);

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"SliderTrack\",\n");
			fprintf(ofp,"\t\"instrument\" : \"%d\"",type);

			GList* list= jammo_slider_track_get_event_list(JAMMO_SLIDER_TRACK(track));
			if (list) {
				//fullpath!
				gchar* name_for_events = g_strdup_printf("%s/%s%s-slider%d.txt",COMPOSITIONS_DIRECTORY,to_filename,timestamp_now,slidertrack_count);
				slidertrack_count++;
				jammo_slider_event_glist_to_file(list, name_for_events);

				fprintf(ofp,",\n\t\"note-file\" : \"%s\"",name_for_events);
				g_free(name_for_events);
			}

			WRITE_VOLUME_AND_MUTED
			fprintf(ofp,"\t}");
			}//Jammo-Slider-Track ends

			else if (JAMMO_IS_BACKING_TRACK(track)) {
			FIRST_TRACK_STARTS_WITHOUT_COMMA
			gchar *filename;
			g_object_get(track,"filename",&filename,NULL);

			fprintf(ofp,"\n\t{\n");
			fprintf(ofp,"\t\"track-type\" : \"BackingTrack\",\n");
			fprintf(ofp,"\t\"audio-file\" : \"%s\"",filename);
			WRITE_VOLUME_AND_MUTED
			fprintf(ofp,"\t}");
			}//Jammo-Backing-Track ends


		}


	else {
		//There can be some scrollers or something
	}

}//Next track

	//'Footer'
	fprintf(ofp,"\n\n]\n}\n");
	fclose(ofp);

	//Saving to cupboard
	gchar* cmd;

	cmd = g_strdup_printf("mv %s/last_composition.json %s/%s%s.json",JAMMO_DIRECTORY,COMPOSITIONS_DIRECTORY,to_filename,timestamp_now);

	//printf("Executing: '%s'\n",cmd);
	if (system(cmd))
		printf("Error, can't call '%s'\n",cmd);

	g_free(cmd);

	return TRUE;
}

