#include "collaboration.h"
#include "communication.h"
#include "groupmanager.h"
#include "messages.h"
#include "gems_structures.h"
#include "gems_message_functions.h"
#include "../cem/cem.h"
#include <stdlib.h>
#include <string.h>
#include "../chum/jammo-collaboration-pair-composition.h"

int groupwork=0;//0=stand-alone, other=number of users in game
int classroom=0;//0=not connected to teacher, 1=is connected to teacher
Game currentgame;
UserList users;


void collaboration_add_new_sample_to_track(guint loop_id, guint slot)
{
	gems_message * msg = gems_create_message_collaboration_action_loop(ADD_LOOP, loop_id, slot);
		
	gems_group_send_to_group(msg);
	gems_clear_message(msg);
}
void collaboration_remove_sample_from_slot(guint slot)
{
	gems_message * msg = gems_create_message_collaboration_action_loop(REMOVE_LOOP, 0, slot);
		
	gems_group_send_to_group(msg);
	gems_clear_message(msg);
}
void collaboration_midi_events_to_track(GemsEventListOperation operation, gint16 instrument_id, GList * list)
{
	int type=0;
	if (operation==GEMS_EVENTLIST_REPLACE)
	{
		type = REPLACE_MIDI_SERIES;
	}
	gems_message * msg = gems_create_message_collaboration_action_midi_series(type, instrument_id, list);

	gems_group_send_to_group(msg);
	gems_clear_message(msg);	
}
void collaboration_slider_events_to_track(GemsEventListOperation operation,gint16 instrument_id, GList * list)
{
	int type=0;
	if (operation==GEMS_EVENTLIST_REPLACE)
	{
		type = REPLACE_SLIDER_SERIES;
	}
	gems_message * msg = gems_create_message_collaboration_action_slider_series(type, instrument_id, list);

	gems_group_send_to_group(msg);
	gems_clear_message(msg);	
}

void collaboration_user_info_request(int connectionid, ip_communication* communicationdata)
{
	char *message;
	gint16 le,length;
	gint16 messageid;
	char location=0;

	le=sizeof(gint16)+sizeof(gint16);
	message=(char *)malloc(le);
	length=g_htons(le);
	messageid=g_htons(USER_INFO_REQUEST);
	memcpy(message+location,&messageid,sizeof(gint16));
	location=location+sizeof(gint16);
	memcpy(message+location,&length,sizeof(gint16));
	location=location+sizeof(gint16);
	communication_send_data(connectionid, message,location, communicationdata);
	free(message);
}

void collaboration_theme_info(char* themename, int themevariation, int id, ip_communication* communicationdata)
{
	char *message;
	gint16 le,length;
	gint16 messageid;
	gint32 variation;
	char location=0;

	le=sizeof(gint16)+sizeof(gint16)+g_utf8_strlen(themename,-1)+sizeof(gint32);
	message=(char *)malloc(le);
	length=g_htons(le);
	messageid=g_htons(THEME_INFO);
	memcpy(message+location,&messageid,sizeof(gint16));
	location=location+sizeof(gint16);
	memcpy(message+location,&length,sizeof(gint16));
	location=location+sizeof(gint16);
	memcpy(message+location,themename,g_utf8_strlen(themename,-1)+1);
	location=location+g_utf8_strlen(themename,-1)+1;
	variation=g_htonl(themevariation);
	memcpy(message+location,&variation,sizeof(gint32));

	communication_send_data(id, message,location, communicationdata);
	free(message);
}

void collaboration_start_game_request(int id, ip_communication* communicationdata)
{
	char *message;
	gint16 le,length;
	gint16 messageid;
	char location=0;

	le=sizeof(gint16)+sizeof(gint16);
	message=(char *)malloc(le);
	length=g_htons(le);
	messageid=g_htons(START_GAME_REQUEST);
	memcpy(message+location,&messageid,sizeof(gint16));
	location=location+sizeof(gint16);
	memcpy(message+location,&length,sizeof(gint16));
	location=location+sizeof(gint16);
	communication_send_data(id, message,location, communicationdata);
	free(message);

}

void collaboration_start_game_response(int status, int id, ip_communication* communicationdata)
{
	char *message;
	gint16 le,length;
	gint16 messageid, stat;
	char location=0;

	le=sizeof(gint16)+sizeof(gint16)+sizeof(gint16);
	message=(char *)malloc(le);
	length=g_htons(le);
	messageid=g_htons(START_GAME_RESPONSE);
	memcpy(message+location,&messageid,sizeof(gint16));
	location=location+sizeof(gint16);
	memcpy(message+location,&length,sizeof(gint16));
	location=location+sizeof(gint16);
	stat=g_htons(status);
	memcpy(message+location,&stat,sizeof(gint16));
	location=location+sizeof(gint16);
	communication_send_data(id, message,location, communicationdata);
	free(message);

}

void collaboration_handle_message(char* message,int length, int connectionid, ip_communication* communicationdata)
{
	gint16 messageid, id;
	int ret=0;
	memcpy(&id,message,sizeof(gint16));
	messageid=g_ntohs(id);
	printf("Got message with id: %d, length: %d\n",messageid, length);
	switch (messageid)
	 {
		case ADD_NEW_SAMPLE_TO_TRACK:
			ret=decode_add_new_sample_to_track(message, length);
			break;	
		case REMOVE_SAMPLE_FROM_SLOT:
			ret=decode_remove_sample_from_slot(message, length);
			break;
		case USER_INFO_REQUEST:
			//ret=decode_user_info_request(message, length, connectionid, communicationdata);
			break;
		case USER_INFO_RESPONSE:
			ret=decode_user_info_response(message, length, connectionid);
			break;	
		case THEME_INFO:
			ret=decode_theme_info(message, length, connectionid);
			break;	
		case START_GAME_REQUEST:
			ret=decode_start_game_request(message, length, connectionid);
			break;
		case START_GAME_RESPONSE:
			ret=decode_start_game_response(message, length, connectionid);
			break;

	}
	if (ret<length && ret>0)
	{
		collaboration_handle_message(message+ret,length-ret, id, communicationdata);
	}
	
}

int decode_add_new_sample_to_track(char* message,int length)//length==size of received data
{
	gint32 track_number;
	gchar* srcLocation;
	guint64 startTime;
	char location;
	gint16 messagelength; //Real size of message
	
	location=sizeof(gint16);//MessageID
	memcpy(&messagelength,message+location,sizeof(gint16));
	location=location+sizeof(gint16);
	if(length<g_ntohs(messagelength))	
		return -1;

	memcpy(&track_number,message+location,sizeof(gint32));
	location=location+sizeof(gint32);

	srcLocation=(gchar *)malloc(g_utf8_strlen(message+location,-1)+1);
	memcpy(srcLocation,message+location,g_utf8_strlen(message+location,-1)+1);
	location=location+g_utf8_strlen(message+location,-1)+1;
	memcpy(&startTime,message+location,sizeof(guint64));
	location=location+sizeof(guint64);

	//call upper level function with these parameters
	printf("\nTrack number: %d, id: %s, starttime: %lld, message length: %d\n",track_number, srcLocation, startTime, location);
	//chum_add_new_sample_to_track_remote(g_ntohl(track_number), srcLocation, GUINT64_FROM_BE(startTime));
	
	return location;
}


int decode_remove_sample_from_slot(char* message,int length)
{
	gint32 track_number;
	gint32 slot;
	char location;
	gint16 messagelength; //Real size of message
	gint16 messageid;



	location=sizeof(gint16);//MessageID
	memcpy(&messagelength,message+location,sizeof(gint16));
	location=location+sizeof(int);
	if(length<g_ntohs(messagelength))	
		return -1;

	memcpy(&track_number,message+location,sizeof(gint32));
	location=location+sizeof(gint32);

	memcpy(&slot,message+location,sizeof(gint32));
	location=location+sizeof(gint32);

	//call upper level function with these parameters
	printf("\nTrack number: %d, slot: %d, message length: %d",track_number, slot, location);
	//chum_remove_sample_from_slot_remote(g_ntohl(track_number),g_ntohl(slot));
	return location;
}

int decode_user_info_request(char* m,int l, int id, ip_communication* communicationdata, gems_peer_profile* my_profile)//Test function - Nothing to decode, just send response 
{
	char *rspmessage;
	char location=0;
	gint16 messageid;
	gint16 le, length;
	guint32 uid;
	gchar* username;
	guint16 avatarid;
	guint16 age;


	le=sizeof(gint16)+sizeof(gint16)+sizeof(guint32)+g_utf8_strlen(my_profile->username,-1)+sizeof(guint16)+sizeof(guint16)+1;
	rspmessage=(char *)malloc(le);
	length=g_htons(le);
	
	//Send the info of this user
	messageid=g_htons(USER_INFO_RESPONSE);
	memcpy(rspmessage+location,&messageid,sizeof(gint16));
	location=location+sizeof(gint16);
	memcpy(rspmessage+location,&length,sizeof(gint16));
	location=location+sizeof(gint16);
	uid=GUINT32_TO_BE(my_profile->id);
	memcpy(rspmessage+location,&uid,sizeof(guint32));
	location=location+sizeof(guint32);
	memcpy(rspmessage+location, my_profile->username,g_utf8_strlen(my_profile->username,-1)+1);
	location=location+g_utf8_strlen(my_profile->username,-1)+1;
	avatarid=GUINT16_TO_BE(my_profile->avatarid);
	memcpy(rspmessage+location,&avatarid,sizeof(guint16));
	location=location+sizeof(guint16);
	age=GUINT16_TO_BE(my_profile->age);
	memcpy(rspmessage+location,&age,sizeof(guint16));
	location=location+sizeof(guint16);

	communication_send_data(id, rspmessage,location, communicationdata);

	//return the (possible )rest of the message
	location=sizeof(short);
	return location;
}

int decode_user_info_response(char* message,int length, int id)
{
	gems_peer_profile* pair_profile;
	char location;
	gint16 messagelength;
	guint32 uid;
	guint16 avatarid;
	guint16 age;

	location=sizeof(gint16);//MessageID
	memcpy(&messagelength,message+location,sizeof(gint16));
	location=location+sizeof(gint16);
	if(length<g_ntohs(messagelength))	
		return -1;


	pair_profile = (gems_peer_profile*)g_malloc(sizeof(gems_peer_profile));
	memcpy(&uid,message+location,sizeof(guint32));
	location=location+sizeof(guint32);
	pair_profile->id = GUINT32_FROM_BE(uid);
	memcpy(pair_profile->username, message+location,g_utf8_strlen(message+location,-1)+1);
	location=location+g_utf8_strlen(pair_profile->username,-1)+1;
	memcpy(&avatarid,message+location,sizeof(guint16));
	location=location+sizeof(guint16);
	pair_profile->avatarid = GUINT32_FROM_BE(avatarid);
	memcpy(&age,message+location,sizeof(guint16));
	location=location+sizeof(guint16);
	pair_profile->age = GUINT32_FROM_BE(age);
	


	printf("\nUser info, name: %s",pair_profile->username );

	return location;
}

int decode_theme_info(char* message,int length, int id)
{
	char location;
	char *themename;
	gint16 messagelength;
	gint32 variation, var;

	location=sizeof(gint16);//MessageID
	memcpy(&messagelength,message+location,sizeof(gint16));
	location=location+sizeof(gint16);
	if(length<g_ntohs(messagelength))	
		return -1;

	themename=(char *)malloc(strlen(message+location)+1);
	memcpy(themename,message+location,strlen(themename+location)+1);
	location=location+strlen(themename+location)+1;

	memcpy(&var,message+location,sizeof(gint32));
	location=location+sizeof(gint32);
	variation=g_ntohl(var);

	//call chum? function with themename and variation
return 1;
}


int decode_start_game_request(char* message,int length, int id)
{
	//Nothing to decode
	//Send information about request to chum?
	return 1;
}

int decode_start_game_response(char* message,int length, int id)
{
	char location;
	gint16 messagelength;
	gint16 stat, status;

	location=sizeof(gint16);//MessageID
	memcpy(&messagelength,message+location,sizeof(gint16));
	location=location+sizeof(gint16);
	if(length<g_ntohs(messagelength))	
		return -1;
	
	memcpy(&stat,message+location,sizeof(gint16));
	location=location+sizeof(gint16);
	status=g_ntohs(stat);


	//Send information about request to chum?
	return 1;
}

void collaboration_start_pair_game(gint16 theme, gint16 variation, gems_components* data)//TODO do we need variation?
{	

	//Start new group
	if(gems_group_create_pair_game(theme)) printf("group created\n");

	//Create game object
	//data->service_collaboration->collaboration_pair_composition = jammo_collaboration_pair_composition_new();
	//TODO set real wav files 
	//jammo_collaboration_pair_composition_set_backing_track_location(collaboration_pair_composition,"/opt/jammo/songs/easy/boat/comping.ogg");
	//jammo_collaboration_pair_composition_set_mix_location(collaboration_pair_composition,"pair_composition_out.wav");

	//Playing may start?
	data->service_collaboration->active=TRUE;
}
void collaboration_pair_game_joined(gems_components* data)
{
	//Create game object
	//data->service_collaboration->collaboration_pair_composition = jammo_collaboration_pair_composition_new();
	
	//Still waiting for song file
}

void collaboration_got_song_info(gems_components* data, const gchar song_info[])
{
	gchar* logmsg = NULL;

	logmsg = g_strdup_printf("collaboration_got_song_info: Got song file, ready to start game");
	cem_add_to_log(logmsg,LOG_DEBUG);
	g_free(logmsg);

	//TODO handle the file contents and start correct UI


	data->service_collaboration->active=TRUE;
}

// Changes in member list
void collaboration_member_list_updated(gems_components* data, gems_connection* element, gboolean owner)
{
	gems_message* msg = NULL;
	gchar* logmsg = NULL;
	gchar* song_info_data = g_strdup_printf("song info string");//TODO get real song file contents

	
		
	if(owner)//If we created this group->send song file to new member
	{
		msg = gems_create_message_collaboration_action_song_info(SONG_INFO, song_info_data);
		if(gems_communication_write_encrypted_data(JAMMO_PACKET_PRIVATE, element, msg) == FALSE)
		{
			logmsg = g_strdup_printf("collaboration_member_list_updated: cannot send group message to device %d user %d",
				ph_c_connection_get_device_checksum(element->connection), element->jammoid);
			cem_add_to_log(logmsg,LOG_ERROR);
			g_free(logmsg);
		}
		else
		{	
			logmsg = g_strdup_printf("collaboration_member_list_updated: New user joined group");
			cem_add_to_log(logmsg,LOG_DEBUG);
			g_free(logmsg);
		}
		g_free(msg);
	}
	else
	{
		logmsg = g_strdup_printf("collaboration_member_list_updated: New user joined group");
		cem_add_to_log(logmsg,LOG_DEBUG);
		g_free(logmsg);
		//TODO Inform the user about new members?
	}
}

int collaboration_create_game_client(char *address, int port, ip_communication* communicationdata)
{
	int result,serverresult;

	//Even in this case, start listening server (with default port)
	serverresult=communication_start_server(currentgame.users[0], 5555, communicationdata);

	currentgame.users[0]=1;
	result=communication_create_connection(address, port, communicationdata);
	if (result)
		groupwork=1;
	return result;
}
int collaboration_create_game_server(int port, ip_communication* communicationdata)
{
	int result;


	currentgame.users[0]=1;
	result=communication_start_server(currentgame.users[0], port, communicationdata);
	if (result)
		groupwork=1;

	return result;
}

int collaboration_send_to_current_group(char* message,int length, ip_communication* communicationdata)
{
	int i;

	if (classroom)//send to teacher
	{
		communication_send_data(0, message,length, communicationdata);
	}
	for(i=0;i<groupwork;i++)//send to other members of group
	{
		communication_send_data(i+1, message,length, communicationdata);
	}
	return 0;

}
