/*
 * gems_service_profile.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Jussi Laakkonen <jussi.laakkonen@lut.fi>
 */
 
#include <glib.h>
#include <string.h>
#include "gems_service_profile.h"
#include "gems_message_functions.h"
#include "gems_security.h"
#include "communication.h"
#include "../cem/cem.h"

gems_service_profile* gems_service_profile_init()
{
	gems_service_profile* data = (gems_service_profile*)g_malloc(sizeof(gems_service_profile));
	data->enabled = FALSE;
	data->port = 0;
	return data;
}

void gems_service_profile_cleanup()
{
	gems_service_profile* data = gems_get_data()->service_profile;
	g_free(data);
	data = NULL;
}

gboolean gems_service_profile_process_request(gems_connection* element)
{
	gboolean success = TRUE;
	gint16 command = gems_connection_get_16(element,(sizeof(gint16)+sizeof(gint32)));
	gint position = 0;
	gchar* logmsg = NULL;
	
	switch(command)
	{
		case GET_PROFILE:
		
			if(gems_connection_get_16(element,(sizeof(gint16)+sizeof(gint32)+sizeof(gint16))) == GET_PROFILE_PUB)
			{
				gems_message* profilemsg = gems_create_message_service_profile(PROFILE_PUB);
				
				if(profilemsg != NULL)
				{					
					// Send
					if(gems_communication_write_encrypted_data(JAMMO_PACKET_PRIVATE,element,profilemsg) == FALSE)
						logmsg = g_strdup_printf("gems_service_profile_process_request: cannot write PROFILE_PUB");
						cem_add_to_log(logmsg,LOG_ERROR);
						g_free(logmsg);
					
					// Free message
					gems_clear_message(profilemsg);
				}
			}
			else
			{
				logmsg = g_strdup_printf("gems_service_profile_process_request: requesting other than PROFILE_PUB");
				cem_add_to_log(logmsg,LOG_NETWORK_DEBUG);
				g_free(logmsg);
				//success = FALSE;
			}
			break;
			
		case PROFILE_PUB:
			// stop timer
			g_timer_stop(element->profile_request_timer);
			
			position = sizeof(gint16) + sizeof(gint32) + sizeof(gint16);
			// Username
			gchar* uname = gems_connection_get_char(element,position);
			position = position + strlen(uname) + 1; // username is followed by '\0'
			
			// User id
			guint32 uid = gems_connection_get_32(element,position);
			position = position + sizeof(guint32);
			
			// age
			guint16 age = gems_connection_get_16(element,position);
			position = position + sizeof(guint16);
			
			// avatar id
			guint16 aid = gems_connection_get_16(element,position);
			
			// Already created?
			if(element->profile == NULL) element->profile = gems_new_peer_profile(uname,uid,age,aid);
			else gems_peer_profile_set_values(element->profile,uname,uid,age,aid);
			
			logmsg = g_strdup_printf("gems_service_profile_process_request: Got profile:\n\tId:\t%u\n\tName:\t%s\n\tAge:\t%d\n\tAvtr:\t%d",
				element->profile->id,element->profile->username,element->profile->age,element->profile->avatarid);
			cem_add_to_log(logmsg,LOG_NETWORK_DEBUG);
			g_free(logmsg);
			
			success = TRUE;
			break;
		//case PROFILE_FULL:
		default:
			success = FALSE;
			break;
	}
	
	return success;
}
