/*
 * communication.h
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Tommi Kallonen <tommi.kallonen@lut.fi>
 *          Jussi Laakkonen <jussi.laakkonen@lut.fi>
 */
 
#ifndef _COMMUNICATION_H_
#define _COMMUNICATION_H_

#include "messages.h"
#include "gems_definitions.h"
#include "gems_structures.h"
#include "gems.h"
#include "gems_service_profile.h"

#include <netinet/in.h>



typedef struct connection{
	int userid;
	struct sockaddr_in Address;  /* Internet socket address stuct */
	int sockethandle;
} connection;

int communication_init();
int communication_create_connection(char *address, int port, ip_communication* communicationdata);
int communication_send_data(int id, char *message, int size, ip_communication* communicationdata);
int communication_start_server(int id, int port, ip_communication* communicationdata);
int communication_close_connection();
int communication_list_users();

gems_communication_data* gems_communication_init();
void gems_communication_cleanup();

gboolean gems_communication_already_connected(int checksum);

gint gems_communication_search_from_list(GList* list, int checksum);

gems_connection* gems_communication_get_connection(GList* list, int checksum);
gems_connection* gems_communication_get_connection_with_userid(GList* list, guint32 userid);


void print_list(GList* list);
void print_group(gems_group_info* info);

gint gems_communication_search_jammos();
gint gems_communication_retrieve_profiles();

gint gems_communication_request_groups();
gint gems_communication_advert_group();
gint gems_communication_sanitize_grouplist();

gint gems_communication_process_connections();
void gems_communication_process_connected();

gboolean gems_communication_process_data(gems_connection* element);
void gems_communication_process_error(gems_connection* element);

gboolean gems_communication_establish_connection(MAbstractDevice* device);

void gems_communication_process_new(gems_connection* element);
void gems_communication_process_new_rejected(gems_connection* element);

// Write data as envelope to element
gboolean gems_communication_write_encrypted_data(gint16 type, gems_connection* element, gems_message* data);

// Write message to socket
gint gems_communication_write_data(gint socket, gems_message* data);

// Read data from socket, place data in gpointer* data
gint gems_communication_read_data(gint socket, void* data, gint length);

#endif  /* _COMMUNICATION_H_ */
