/*
 * test-mentor.c
 *
 * This file is part of JamMo.
 *
 * (c) 2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#include <chum/jammo-chum.h>
#include <chum/jammo-mentor.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* texture;
	ClutterActor* mentor;
	
	jammo_meam_init(&argc, &argv);
	jammo_chum_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	//clutter_stage_set_fullscreen(CLUTTER_STAGE(stage), TRUE);
	clutter_actor_set_size(stage, 800.0, 480.0);

	texture = clutter_texture_new_from_file("test_image_100x74.jpg", NULL);
	g_assert(texture != NULL);
	
	mentor = jammo_mentor_new(texture, 1.0, 2.0);
	jammo_mentor_set_idle_speech(JAMMO_MENTOR(mentor), "test_sound.wav");
	
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), mentor);
	
	clutter_actor_show_all(stage);
	clutter_main();
	
	return 0;
}
