#include <tangle.h>
#include <clutter/clutter.h>
#include "chum.h" //e.g. DATA_DIR
#include "jammo-sample-button.h"
#include "jammo-track-view.h"
#include "string.h"
#include <fcntl.h> //we check some files
#include "jammo-mentor.h"
#include <math.h> //sin
#include <chum/jammo-cursor.h>
#include "trafficlight_dialog.h"


static JammoSequencer* composing_sequencer;
static JammoTrackView* bottom_track_view;
static JammoTrackView* upper_track_view; //this is not used in 'easy' mode

static ClutterActor* view_to_go_when_end; //After start this points themeselection or cupboard

static gchar* prefix_for_saving; //This will contain theme-name, -variation and easy/advanced-mode

static GList* animation_timelines; /*This is container for animation timelines of samplebuttons*/

static gboolean only_playing_mode=FALSE; //When editing this is FALSE. When coming from cupboard, only listen is allowed

static ClutterActor* container_for_buttons = NULL; //This contains icons and buttons for saving
static int x_place_for_icon = 0; //Used for container_for_select_icon_buttons

static void stop_all_icon_animations();
static void play_all_icon_animations();
static void remove_all_icon_animations();

/*
 Filename for saving are automatically generated,
 but iconfile is given as parameter.
*/
static gboolean save_composition(gchar* name_of_icon) {
	printf("Saving composition, using icon file '%s'\n",name_of_icon);
	FILE *ofp;
	gchar *outputFilename;

	outputFilename = g_strdup_printf("%s/last_composition.txt", JAMMO_DIRECTORY);

	ofp = fopen(outputFilename, "w");
	g_free(outputFilename);
	g_return_val_if_fail(ofp != NULL, FALSE);

	//File starts with name of icon
	fprintf(ofp,"%s\n",name_of_icon);

	JammoTrackView* track_view = bottom_track_view;

	gfloat slot_size;
	g_object_get(track_view,"slot-size",&slot_size,NULL);
	printf("slot_size '%lf'\n",slot_size);
	
	GList* children;
	TangleWidget* widget;
	JammoSampleButton* jsb;
	widget = TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(track_view)));
	for (children = tangle_widget_get_children_readonly(widget); children; children = children->next)
		{
		jsb = JAMMO_SAMPLE_BUTTON(children->data);
		//printf("x: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb)));
		printf("slot: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
		fprintf(ofp,"%lf\n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
		gchar* sound;
		gchar* image;
		g_object_get(jsb, "sample-filename", &sound, NULL);
		g_object_get(jsb, "image-filename", &image, NULL);
		printf("image: '%s'. sound: '%s' \n",image,sound);
		fprintf(ofp,"%s\n",sound);
		fprintf(ofp,"%s\n",image);
		}

	if (upper_track_view!= NULL) 
		{
		fprintf(ofp,"-1\n#\n#\n");
		track_view = upper_track_view;
		g_object_get(track_view,"slot-size",&slot_size,NULL);
		
		widget = TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(track_view)));
		for (children = tangle_widget_get_children_readonly(widget); children; children = children->next)
			{
			jsb = JAMMO_SAMPLE_BUTTON(children->data);
			//printf("x: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb)));
			printf("slot: '%lf' \n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
			fprintf(ofp,"%lf\n",clutter_actor_get_x(CLUTTER_ACTOR(jsb))/slot_size);
			gchar* sound;
			gchar* image;
			g_object_get(jsb, "sample-filename", &sound, NULL);
			g_object_get(jsb, "image-filename", &image, NULL);
			printf("image: '%s'. sound: '%s' \n",image,sound);
			fprintf(ofp,"%s\n",sound);
			fprintf(ofp,"%s\n",image);
			}
		}

	fclose(ofp);
	
	//Saving to cupboard 
	gchar* cmd;

	// Filenames look like this: _2010.02.22_21.16.27.wav
	cmd = g_strdup_printf("cp %s/last_composition.txt %s/%s-`date +%%Y.%%m.%%d_%%H.%%M.%%S`.txt",JAMMO_DIRECTORY,COMPOSITIONS_DIRECTORY,prefix_for_saving);
	if (system(cmd)) 
		printf("Error, can't call '%s'\n",cmd);

	g_free(cmd);
	
	return FALSE;
}


static void close_themeselection(){
	//g_free(prefix_for_saving);  //FIXME. this causes often seg fault
	only_playing_mode=FALSE; //for next round
	x_place_for_icon = 0; //for next round
	clutter_actor_destroy(container_for_buttons);
	clutter_container_foreach(CLUTTER_CONTAINER(jammo_get_actor_by_id("main-views-widget")), chum_hide_this_tangle_actor, NULL);
	clutter_actor_show(view_to_go_when_end);
	clutter_actor_show(CLUTTER_ACTOR(jammo_mentor_get_default())); /*This is needed when coming from cupboard, and mentor is hided*/
}


#ifdef saving_trafficlights /*deprecated*/
static gboolean yes_save_clicked ( gpointer data) {
	printf("yes_save selected\n");
	save_composition();
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(),"/opt/jammo/mentor_speech/mentor_save_confirmed_fi.ogg",close_themeselection,NULL);
	return FALSE;
}

static gboolean no_save_clicked ( gpointer data) {
	printf("no_save selected\n");
	close_themeselection();
	return FALSE;
}
#endif



static void hide_save_menu(){
	clutter_actor_hide(container_for_buttons);
	play_all_icon_animations();
}


static gboolean back_to_game_pressed(TangleButton *tanglebutton, gpointer null){
	printf("CANCEL\n");
	hide_save_menu();
	return FALSE;
}


/*
Draw cupboard with two doors. It is placed far right.
Right-door will open little.
Clicked button will move inside cupboard. (over left door, but under right).
*/
static void animate_icon_to_cupboard(JammoMentor* mentor, const gchar* speech, gpointer button){
	int x_for_cupboard = 510;
	//Cupboard itself
	ClutterActor* cupboard = clutter_texture_new_from_file("/opt/jammo/cupboard.png", NULL);
	clutter_actor_set_x(cupboard,x_for_cupboard);
	clutter_actor_set_y(cupboard,0);
	tangle_widget_add(TANGLE_WIDGET(clutter_actor_get_parent(CLUTTER_ACTOR(button))), cupboard, NULL);

	//Left door. this will be closed
	ClutterActor* cupboard_left = clutter_texture_new_from_file("/opt/jammo/cupboard_leftdoor.png", NULL);
	clutter_actor_set_x(cupboard_left,x_for_cupboard);
	clutter_actor_set_y(cupboard_left,60);
	tangle_widget_add(TANGLE_WIDGET(clutter_actor_get_parent(CLUTTER_ACTOR(button))), cupboard_left, NULL);

	//Raise clicked button (also over all other buttons)
	clutter_actor_raise_top(CLUTTER_ACTOR(button));

	//Right door. This will be animated. This will be topmost actor
	ClutterActor* cupboard_right = clutter_texture_new_from_file("/opt/jammo/cupboard_rightdoor.png", NULL);
	clutter_actor_set_anchor_point(cupboard_right, clutter_actor_get_width(cupboard_right), 0.0);  //anchor is on right side
	clutter_actor_set_x(cupboard_right,x_for_cupboard+clutter_actor_get_width(cupboard_left)+clutter_actor_get_width(cupboard_right));
	clutter_actor_set_y(cupboard_right,60);
	tangle_widget_add(TANGLE_WIDGET(clutter_actor_get_parent(CLUTTER_ACTOR(button))), cupboard_right, NULL);
	ClutterAnimation* animation_for_door = clutter_actor_animate(cupboard_right, CLUTTER_LINEAR, 3000, "rotation-angle-y", 10.0,  NULL);

	//Animate (=move) clicked button inside cupboard
	ClutterAnimation* animation;
	ClutterTimeline* timeline;
	animation = clutter_actor_animate(button, CLUTTER_LINEAR, 4000, "x", 700.0, NULL);
	timeline = clutter_animation_get_timeline(animation);
	g_signal_connect(timeline, "completed", G_CALLBACK(close_themeselection), NULL);
}

static gboolean save_image_pressed(TangleButton *tanglebutton, gpointer filename){
	printf("Selected '%s'\n",(gchar*)filename);
	save_composition((gchar*)filename);
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(),"/opt/jammo/mentor_speech/mentor_save_confirmed_fi.ogg",animate_icon_to_cupboard,tanglebutton);
	return FALSE;
}


/*
This is called when user click 'cross' / 'back_to_theme_selection'
Give view to hide as parameter.
*/
static void back_to_theme_selection_clicked (ClutterTexture *actor, ClutterEvent *event, gpointer data){
	/*
	When cross is clicked, saving menu is showed. There are couple of situations when menu is not showed
	-We are coming from cupboard, no edit has happened
	-Track1 is empty and it is only track
	-Track1 is empty and there are also empty track2
	*/
	gboolean pop_menu = TRUE;
	if (only_playing_mode)
		pop_menu = FALSE;

	if (tangle_widget_get_n_children(TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(bottom_track_view)))) ==0) { //track1 empty
		if  (upper_track_view == NULL)  //only one track
			pop_menu = FALSE;
		else  //There are two tracks
			if (tangle_widget_get_n_children(TANGLE_WIDGET(tangle_wrapper_actor_get_wrapped(TANGLE_WRAPPER_ACTOR(upper_track_view)))) ==0) { //track2 empty
				pop_menu = FALSE;
			}
		}
	jammo_sequencer_stop(composing_sequencer);
	stop_all_icon_animations();

	if (pop_menu){
		#ifdef use_lights_when_quitting    /*deprecated*/
		trafficlight_dialog(CLUTTER_ACTOR(clutter_actor_get_parent(CLUTTER_ACTOR(actor))),
					"/opt/jammo/mentor_speech/mentor_ask_for_saving_composing_fi.ogg",
					"/opt/jammo/mentor_speech/mentor_ask_for_saving_composing_fi.ogg",
					yes_save_clicked,NULL,
					no_save_clicked, NULL
				);
		#else
		clutter_actor_raise_top(container_for_buttons);
		clutter_actor_show(container_for_buttons);
		//TODO: speak
		//jammo_mentor_speak(jammo_mentor_get_default(),"");
		//TODO: speak
		jammo_mentor_set_idle_speech(jammo_mentor_get_default(),"");
		#endif
	}
	else
		close_themeselection();

}



static gdouble phasing(gdouble start_value, int phase) {
	gdouble value = start_value;
	value += phase/100.0;
	if (value>=1) value -= 1;
	return value;
}

static void stop_all_icon_animations() {
	GList *timeline;
	for (timeline = animation_timelines;timeline;timeline = timeline->next)
		{
		clutter_timeline_pause(CLUTTER_TIMELINE(timeline->data));
		}
}
static void play_all_icon_animations() {
	GList *timeline;
	for (timeline = animation_timelines;timeline;timeline = timeline->next)
		{
		clutter_timeline_start(CLUTTER_TIMELINE(timeline->data));
		}
}
static void remove_all_icon_animations() {
	GList *timeline;
	for (timeline = animation_timelines;timeline;timeline = timeline->next)
		{
		clutter_timeline_set_loop (CLUTTER_TIMELINE(timeline->data),FALSE); //Animations will stop and send completed, and then they are free'ed
		}
}


/*
clutter_timeline_get_progress returns value between [0,1]
with phasing we can shift it always same amount
*/
static gdouble sine_wave (ClutterAlpha *alpha,gpointer user_data) {
return sin (phasing(clutter_timeline_get_progress (clutter_alpha_get_timeline (alpha)),GPOINTER_TO_INT(user_data)) * G_PI);
}


/*
This function creates new jammo_sample_button from given parameters and put it to given parent ClutterActor.
*/
//static void create_samplebutton(gchar* themename, gchar* variation, gchar* imagefile, gchar* soundfile, gfloat x, gfloat y,ClutterActor* parent){
static void create_samplebutton(gchar* themename, gchar* variation, gchar* imagefile, gchar* soundfile, gfloat x, gfloat y,TangleWidget* parent){
	gchar *full_image = g_strdup_printf("%s/themes/%s/%s/%s",DATA_DIR,themename,variation,imagefile);
	//printf("image file: '%s'\n",full_image);


	/* If we are in listening mode, we do not need:
	*pushable
	*draggable
	*animated
	   sample_buttons
	just make textures*/
	if (only_playing_mode) {
		ClutterActor* icon = clutter_texture_new_from_file(full_image, NULL);
		clutter_actor_set_position(icon, x, y);
		tangle_widget_add(parent, icon, NULL);
		return;
		}


	//This is good place to do menu for selecting icon for saved composition
	if (x_place_for_icon<500) { //if 500px is used do not add anymore
		ClutterActor* icon_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(full_image, NULL));
		gchar* name_for_callback = g_strdup_printf("%s",full_image); //FIXME: this is not free'ed!
		g_signal_connect (icon_button, "clicked", G_CALLBACK (save_image_pressed),name_for_callback);
		clutter_actor_set_x(icon_button,x_place_for_icon);
		clutter_actor_set_y(icon_button,200);
		clutter_actor_set_width(icon_button,80); //This is the size/ratio when it is in cupboard
		tangle_widget_add(TANGLE_WIDGET(container_for_buttons), icon_button, NULL);
		x_place_for_icon+=clutter_actor_get_width(icon_button)+5;
	}

	gchar *full_sound = g_strdup_printf("%s/themes/%s/%s/%s",DATA_DIR,themename,variation,soundfile);
	//printf("sound file: '%s'\n",full_sound);

	ClutterActor* sample_button;
	sample_button = jammo_sample_button_new_from_files(full_image, full_sound);

	//Each animation has own phase
	int phase = (rand () % 100) + 1;
	//printf("phase %d\n",phase);
	
	//Each animation has own wobbling 'mode'-function
	gulong sine_function;
	sine_function = clutter_alpha_register_func (sine_wave, GINT_TO_POINTER(phase));

	ClutterTimeline *timeline1 = tangle_timeline_new(3000+phase*20);  //each has own rhythm (use same random number than phase)

	animation_timelines = g_list_append(animation_timelines,timeline1);
	ClutterAnimation* animation;
	animation = clutter_actor_animate_with_timeline (sample_button, 
            sine_function, 
            timeline1,
            "height", 50.0,  //add some vertical scaling, it doesn't disturb movement
            NULL);
	clutter_animation_set_loop (animation,TRUE);
	g_object_unref(timeline1);

	g_free(full_image);
	g_free(full_sound);
	clutter_actor_set_position(sample_button, x, y);
	tangle_widget_add(parent, sample_button, NULL);
}

//soundfamily is button containing samplebuttons.
static ClutterActor* soundfamily[4]; //This can be GList, but now we know that we use always four.

/*
actor is button, not interested.
event is not interested.
user_data is container/warehouse.
*/
static void menu_clicked(ClutterTexture *actor, ClutterEvent *event, gpointer user_data){	
	//check if this menu is clicked already (is it visible)
	
	if (CLUTTER_ACTOR_IS_VISIBLE(CLUTTER_ACTOR(user_data))) {
		//printf("hiding\n");
		tangle_actor_hide_animated(TANGLE_ACTOR(user_data));
	}
	else {
		int i;
		for (i=0;i<4;i++)
			{
			tangle_actor_hide_animated(TANGLE_ACTOR(soundfamily[i]));
			}
		//printf("showing\n");
		tangle_actor_show(TANGLE_ACTOR(user_data));
	}
}


static void on_cursor_notify_x(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	TangleVault* vault;
	TangleScrollingActor* scrolling_actor;
	JammoCursor* cursor;
	gfloat x, visible, offset, max;
	
	vault = TANGLE_VAULT(user_data);
	tangle_vault_get(vault, 2, TANGLE_TYPE_SCROLLING_ACTOR, &scrolling_actor, JAMMO_TYPE_CURSOR, &cursor);
	g_object_get(object, "x", &x, NULL);
	g_object_get(scrolling_actor, "width", &visible, "scrolling-offset-x", &offset, "scrolling-width", &max, NULL);
	if (x < offset) {
		offset = x - visible + 80.0;
		if (offset < 0.0) {
			offset = 0.0;
		}
		clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-x", offset, NULL);	
	} else if (x > offset + visible - 80.0) {
		offset += 160.0;
		if (offset > max) {
			offset = max;
		}
		clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-x", offset, NULL);
	}
}


static gboolean on_play_button_clicked(TangleButton* tanglebutton, gpointer sequencer){
	const gchar* name = clutter_actor_get_name (CLUTTER_ACTOR(tanglebutton));
	
	//If user press play-button when first sample is playing (triggering mentor to give instructions for dragging)
	//Mentor jumps and talks sametime than track.
	//This is fixes it:
	jammo_mentor_speak_once(jammo_mentor_get_default(), "/opt/jammo/mentor_speech/mentor_composing_first_click_fi.ogg");
	jammo_mentor_shut_up(jammo_mentor_get_default());


	if (strncmp(name,"play",4)==0)
		{
		stop_all_icon_animations();
		printf("Play button pressed (play)\n");
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));

		jammo_sample_stop_all();
		jammo_sequencer_play(JAMMO_SEQUENCER(sequencer));

		tangle_button_set_normal_background_actor(tanglebutton,clutter_texture_new_from_file("/opt/jammo/buttons/stop-button.png", NULL));
		g_object_set(tanglebutton, "x", 720.0,  NULL);
		tangle_button_set_interactive_background_actor(tanglebutton,clutter_texture_new_from_file("/opt/jammo/buttons/stop-button.png", NULL));
		clutter_actor_set_name(CLUTTER_ACTOR(tanglebutton),"stop");
		}

	else if (strncmp(name,"stop",4)==0)
		{
		printf("Play button pressed (stop)\n");
		jammo_sequencer_stop(JAMMO_SEQUENCER(sequencer)); //This will automatically cause 'on_sequencer_stopped'
		}


	return FALSE;
}

#ifdef asking_it_is_ready /*deprecated*/
static gboolean yes_ready_clicked (gpointer data) {
	printf("yes_ready selected\n");
	//Ask saving
	trafficlight_dialog(CLUTTER_ACTOR(clutter_actor_get_parent(CLUTTER_ACTOR(data))),
                      "/opt/jammo/mentor_speech/mentor_ask_for_saving_composing_fi.ogg",
                      "/opt/jammo/mentor_speech/mentor_ask_for_saving_composing_fi.ogg",
                      yes_save_clicked,NULL,
                      no_save_clicked, NULL
                     );
	return FALSE;
}

static gboolean no_ready_clicked ( gpointer data) {
	printf("no_ready selected\n");
	return FALSE;
}
#endif

static gboolean mentor_has_asked_is_it_ready = FALSE;
static void on_sequencer_stopped(JammoSequencer* sequencer, gpointer play_button) {
	if (only_playing_mode)
		{
		close_themeselection();
		return;
		}

	const gchar* last_state_of_button = clutter_actor_get_name(CLUTTER_ACTOR(play_button));
	if (strncmp(last_state_of_button,"play",4)==0) //False alert
		return;
	
	printf("Sequencer stopped\n");
	tangle_actor_show(TANGLE_ACTOR(jammo_mentor_get_default()));

	play_all_icon_animations();

	//Change button to play
	tangle_button_set_normal_background_actor(TANGLE_BUTTON(play_button),clutter_texture_new_from_file("/opt/jammo/buttons/play-button.png", NULL));
	tangle_button_set_interactive_background_actor(TANGLE_BUTTON(play_button),clutter_texture_new_from_file("/opt/jammo/buttons/play-button.png", NULL));
	clutter_actor_set_name(CLUTTER_ACTOR(play_button),"play");
	g_object_set(play_button, "x", 0.0,  NULL);

	#ifdef ask_about_is_it_ready /*deprecated*/
	if (mentor_has_asked_is_it_ready==FALSE)
		{
		trafficlight_dialog(CLUTTER_ACTOR(clutter_actor_get_parent(CLUTTER_ACTOR(play_button))),
                      "/opt/jammo/mentor_speech/mentor_composing_is_it_ready.ogg",
                      "/opt/jammo/mentor_speech/mentor_composing_is_it_ready_idle.ogg",
                      yes_ready_clicked,play_button,
                      no_ready_clicked, NULL
                     );
		mentor_has_asked_is_it_ready=TRUE;
		}
	#endif
}


static gboolean load_from_file(gpointer data) {
	gchar* inputFilename = (gchar*) data;
	printf("Themeselection: Loading composition in file '%s'\n",inputFilename);
	
	JammoTrackView* track_view = bottom_track_view;
	FILE *ifp;

	ifp = fopen(inputFilename, "r");
	g_return_val_if_fail(ifp != NULL, FALSE);

	int bytes_read;
	size_t nbytes = 100; //No field can have this many characters
	char *my_string;
	my_string = (char *) malloc (nbytes + 1);
	gboolean not_ready = TRUE;

	//First line is name of icon, just ignore it
	bytes_read = getline (&my_string, &nbytes, ifp);


	int slot;
	char* wav_name = malloc (nbytes + 1);
	char* png_name = malloc (nbytes + 1);
	while (not_ready)
		{
			
		//Slot number
		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0) 
		{
			not_ready=FALSE;
			continue;
		} 

		slot=atoi(my_string); //There are end-of-line ins string, but atoi works.
		printf("slot='%d'\n",slot);


		//sound filename
		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0) 
		{
			not_ready=FALSE;
			continue;
		} 
		strncpy(wav_name, my_string, strlen(my_string)-1); //throw end-of-line away
		wav_name[strlen(my_string)-1]='\0';                //Add string terminator

		printf("name of soundfile='%s'\n",wav_name);


		//image filename
		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0) 
		{
			not_ready=FALSE;
			continue;
		} 
		strncpy(png_name, my_string, strlen(my_string)-1); //throw end-of-line away
		png_name[strlen(my_string)-1]='\0';                //Add string terminator

		printf("name of pngfile='%s'\n",png_name);

		if (slot==-1 && strncmp(png_name,"#",1)==0 && strncmp(wav_name,"#",1)==0 ) //this means 'next-track'
			{
			printf("next track\n");
			if (track_view == upper_track_view) //Somebody tries use three tracks! (Not planned to support this)
				return FALSE;
			if (upper_track_view == NULL) //Somebody tries load 'two tracks'-file on easy-mode
				return FALSE;
			track_view = upper_track_view;
			}

		else  
			{
			//Make sample_button and put it into track.
			ClutterActor* sample_button;
			sample_button = jammo_sample_button_new_from_files(png_name, wav_name);
			jammo_track_view_add_jammo_sample_button(JAMMO_TRACK_VIEW(track_view), JAMMO_SAMPLE_BUTTON(sample_button), slot);
			}
		//printf("This entry ready\n");
	}
	//printf("File readed\n");
	return FALSE;
}

static gpointer filename_for_loading;
gboolean themeselection_load(gpointer data) {
	//printf("preparing to load \n");
	only_playing_mode=TRUE;
	filename_for_loading = data;
	return FALSE;
}

static void do_actual_loadind_now(){
	//printf("loading now\n");
	load_from_file(filename_for_loading);
	//printf("loaded\n");

	//printf("hide mentor\n");
	clutter_actor_hide(CLUTTER_ACTOR(jammo_mentor_get_default()));

	//printf("start sequencer\n");
	jammo_sequencer_play(composing_sequencer);
	//printf("do_actual_loadind_now ready\n");
}


/*
Make colored rectangles and add them to given parent.
Returns number of used slots (length of color_coding).
white=# because it has special meaning. Samples can't be dropped on this slot. (TODO)
*/
static int create_backing_track_color_coding(gchar* color_coding, gfloat slot_size, gfloat y_offset,TangleWidget* parent) {
	ClutterActor* actor;
	ClutterColor white  = { 255,255,255,   255 };
	ClutterColor yellow = { 255, 255, 0,   255 };
	ClutterColor green  = { 0, 255, 0,     255 };
	ClutterColor orange = { 255, 165, 0,   255 };
	ClutterColor blue   = { 25, 25, 112,   255 };
	ClutterColor red    = { 255, 0, 0,     255 };
	ClutterColor lblue  = { 100, 149, 237, 255 };
	ClutterColor violet = { 148,0,211,     255 };
	ClutterColor pink   = { 255,105,180,   255 };

	int max=strlen(color_coding);
	int i;
	for (i=0;i<max;i++) 
		{
		actor = tangle_widget_new();
		ClutterColor* color;
		switch (color_coding[i])
			{
			case '#': color =  &white         ;break;
			case 'y': color =  &yellow        ;break;
			case 'g': color =  &green         ;break;
			case 'o': color =  &orange        ;break;
			case 'b': color =  &blue          ;break;
			case 'r': color =  &red           ;break;
			case 'l': color =  &lblue         ;break;
			case 'v': color =  &violet        ;break;
			case 'p': color =  &pink          ;break;
			default: color = &white;
			}

		tangle_widget_set_background_color(TANGLE_WIDGET(actor), color);	
		g_object_set(actor, "width", slot_size, "height", 40.0, "x", i* slot_size, "y", 80.0+y_offset, NULL);
		clutter_container_add_actor(CLUTTER_CONTAINER(parent), actor);
		}
	return max;
}


static ClutterActor* create_soundfamily_button(const gchar* theme_name, const gchar* button_name, gfloat x, gfloat y,TangleWidget* parent){
	ClutterActor* widget = tangle_widget_new();
	clutter_container_add(CLUTTER_CONTAINER(parent), widget, NULL);
	ClutterActor *menu;
	gchar* filename = g_strdup_printf("%s/%s/advanced/%s", THEMES_DIR, theme_name,button_name);
	menu=clutter_texture_new_from_file(filename, NULL);
	g_object_set(menu, "x",x, "y", y, NULL);
	clutter_container_add(CLUTTER_CONTAINER(parent), menu, NULL);
	clutter_actor_set_reactive(menu,TRUE);
	g_signal_connect (menu, "button-press-event", G_CALLBACK (menu_clicked),widget);
	clutter_actor_hide(widget);
	g_free(filename);
	return widget;
}

static gboolean first_time_transition_completed=TRUE;
static gulong handler_for_view_transition;
static void quitting_composing(TangleActor *actor, ClutterActorBox *arg1, ClutterActorBox *arg2, gpointer sequencer){
	if (first_time_transition_completed)
		{
		printf("showing composing view\n");
		first_time_transition_completed=FALSE;
		if (only_playing_mode) //this means we have something to load
			do_actual_loadind_now();
		}
	else
		{
		printf("hiding -> destroy\n");
		g_signal_handler_disconnect (actor,handler_for_view_transition);

		remove_all_icon_animations();

		g_list_free(animation_timelines);

		clutter_actor_destroy(CLUTTER_ACTOR(actor));
		first_time_transition_completed=TRUE; //For next round.
		}
}

#define WIDTH_OF_SLOT 40.0
void themeselection_start_theme(const gchar* name, int variation, ClutterActor* where_to_go_after){
	view_to_go_when_end = where_to_go_after; //We set this static ClutterActor, so we know where to go when composition game is quitted.
	
	printf("Theme '%s' starting.\n",name);

	GError* error = NULL;
	animation_timelines=NULL;
	mentor_has_asked_is_it_ready=FALSE;
	
	prefix_for_saving = g_strdup_printf("+%s+%d+%s",name,variation,chum_is_easy_game()? "e":"a");
	//example: +fantasy+2+e
	//printf("prefix is '%s'\n",prefix_for_saving);
	
	//Background for this theme
	gchar *background_image_name = g_strdup_printf("%s/themes/%s/background.png",DATA_DIR,name);
	ClutterActor *background;
	if(!(background=clutter_texture_new_from_file(background_image_name, &error))){
	fprintf(stderr, "%s\n",  error->message);
            g_error_free(error);
	}
	g_free(background_image_name);

	//Make new view and put it to 'main'-view.
	ClutterActor* view;
	if ((view = tangle_view_new())) {
		handler_for_view_transition = g_signal_connect(view, "transition-completed", G_CALLBACK(quitting_composing), NULL);
		g_object_set(view, "background-actor", background, NULL);	
		ClutterActor* mainview;
		if ((mainview = jammo_get_actor_by_id("main-views-widget"))){
			printf("Will add 'view' to 'mainview'\n");	
			clutter_container_add(CLUTTER_CONTAINER(mainview), view, NULL);
			clutter_actor_show(view);
			printf("succesfully made new view and put it to mainview\n");
		}
	}

	//This is a previous view (themeselection-view). Hide it.
	ClutterActor* old_view;
	if ((old_view = jammo_get_actor_by_id("themeselection-view"))) {	
		tangle_actor_hide_animated(TANGLE_ACTOR(old_view));
	}


	jammo_mentor_speak_once(jammo_mentor_get_default(), "/opt/jammo/mentor_speech/mentor_composing_welcome_fi.ogg");
	jammo_mentor_set_idle_speech(jammo_mentor_get_default(), "/opt/jammo/mentor_speech/mentor_composing_idle_fi.ogg");

	
	ClutterActor *back_to_theme_selection;
	back_to_theme_selection=clutter_texture_new_from_file("/opt/jammo/cross_icon.png", NULL);
	g_object_set(back_to_theme_selection, "x", 719.0,  "y", 16.0, NULL);
	clutter_container_add(CLUTTER_CONTAINER(view), back_to_theme_selection, NULL);
	clutter_actor_set_reactive(back_to_theme_selection,TRUE);
	g_signal_connect (back_to_theme_selection, "button-press-event", G_CALLBACK (back_to_theme_selection_clicked),view);




	//Make dialog/menu for select icon for composition when saving


	//This will contain every buttons on this dialog
	container_for_buttons = tangle_widget_new();
	clutter_container_add_actor(CLUTTER_CONTAINER(view),container_for_buttons);

	//Dimm background
	ClutterActor* mask = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/themeselection_background.png", NULL));
	clutter_actor_set_opacity(mask ,200);
	tangle_widget_add(TANGLE_WIDGET(container_for_buttons), mask, NULL);

	//back button //BACK TO GAME
	ClutterActor* back_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/buttons/next-button.png", NULL));
	g_signal_connect (back_button, "clicked", G_CALLBACK (back_to_game_pressed),view);
	clutter_actor_set_x(back_button,650);
	clutter_actor_set_y(back_button,340);
	tangle_widget_add(TANGLE_WIDGET(container_for_buttons), back_button, NULL);

	//cancel button //DO NOT SAVE, JUST QUIT THIS SESSION
	ClutterActor* cancel_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/cross_icon.png", NULL));
	g_signal_connect (cancel_button, "clicked", G_CALLBACK (close_themeselection),view);
	clutter_actor_set_x(cancel_button,719);
	clutter_actor_set_y(cancel_button,16);
	tangle_widget_add(TANGLE_WIDGET(container_for_buttons), cancel_button, NULL);

	clutter_actor_hide(container_for_buttons);
	clutter_actor_raise_top(container_for_buttons);





	int tempo_table[] = {0,140,110,90};
	gchar* background_color_code = "some_default";
	gchar* backing_track_filepath = "no_any_backing_track";
	
	int disabled_slots_for_begin = 0;
	int disabled_slots_for_end = 0;
	int tempo_factory = 4;    //4 is default
	int beats_per_minute=90; //This value should be overwritten.
	
	//Advanced game sets this to TRUE
	gboolean use_two_tracks=FALSE;

	if (chum_is_easy_game()) {
	backing_track_filepath = g_strdup_printf("%s/%s/%d/backing_track.wav", THEMES_DIR, name, tempo_table[variation]);
	beats_per_minute = tempo_table[variation];
		
	//Add samplebuttons. There are three themes, and each has three variations.
	if (strncmp(name,"fantasy",7)==0 && variation==1){
	create_samplebutton("fantasy","140","donkey.png",  "castle_140_drums_2.wav",        296.0, 103.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","140","faun.png",    "castle_140_synth_melody_2.wav", 574.0, 233.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","140","kangaroo.png","castle_140_synth_riff_2.wav",   626.0, 155.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","140","potion.png",  "castle_140_glockenspiel_1.wav", 129.0, 252.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","140","snake.png",   "castle_140_synth_glide_4.wav",  332.0, 197.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","140","witch.png",   "castle_140_melody_2.wav",       545.0,  31.0,TANGLE_WIDGET(view));
	
	background_color_code = "#yyyyyyyyppppppppyyyyyyyypppppppp###";
	disabled_slots_for_begin = 1;
	disabled_slots_for_end = 3;
	}
	else if (strncmp(name,"fantasy",7)==0 && variation==2){
	create_samplebutton("fantasy","110","dragon.png","castle_110_clarinet_4.wav",      221.0,  39.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","110","faerie.png","castle_110_glockenspiel_2.wav",  506.0, 201.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","110","flower.png","castle_110_piano_2.wav",         631.0, 243.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","110","ghost.png", "castle_110_flute_2.wav",         548.0,  26.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","110","owl.png",   "castle_110_owl_2.wav",           627.0, 158.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","110","wolf.png",  "castle_110_wolf_4.wav",           21.0, 204.0,TANGLE_WIDGET(view));
	
	background_color_code = "bbbbbbbbbbbbbbbbrrrrrrrrvvvvvvvvbbbbbbbb##";
	disabled_slots_for_end = 2;
	tempo_factory = 3;
	}
  else if (strncmp(name,"fantasy",7)==0 && variation==3){
	create_samplebutton("fantasy","90", "bird.png",    "castle_90_whistle_4.wav",    511.0, 107.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","90", "frog.png",    "castle_90_vibraphone_2.wav",  71.0, 245.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","90", "specter.png", "castle_90_triangle_4.wav",   217.0,  21.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","90", "mermaid.png", "castle_90_chimes_4.wav",     434.0, 274.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","90", "prince.png",  "castle_90_brass_2.wav",      628.0, 188.0,TANGLE_WIDGET(view));
	create_samplebutton("fantasy","90", "unicorn.png", "castle_90_oboe_2.wav",       318.0, 111.0,TANGLE_WIDGET(view));
	
	background_color_code = "llllvvvvvvvvllllllllvvvvvvvvrrrrrrrrvvvv";
	tempo_factory = 3;
	}

  else if (strncmp(name,"city",4)==0 && variation==1){
	create_samplebutton("city","140","bicycle.png",    "city_140_guitar1_2.wav",     574.0, 136.0,TANGLE_WIDGET(view));
	create_samplebutton("city","140","bucket.png",     "city_140_drum_fill_1.wav",   604.0, 235.0,TANGLE_WIDGET(view));
	create_samplebutton("city","140","bus.png",        "city_140_guitar_solo_4.wav",  84.0, 157.0,TANGLE_WIDGET(view));
	create_samplebutton("city","140","guitarhero.png", "city_140_guitar_riff_2.wav", 377.0, 102.0,TANGLE_WIDGET(view));
	create_samplebutton("city","140","kids.png",       "city_140_yell_claps_2.wav",  689.0, 185.0,TANGLE_WIDGET(view));
	create_samplebutton("city","140","motorcycle.png", "city_140_guitar2_2.wav",     306.0, 205.0,TANGLE_WIDGET(view));
	
	background_color_code = "yyyyyyyybbyyyyyyyybbgggggggbyyyyyyyy##";
	disabled_slots_for_end = 2;
	}
  else if (strncmp(name,"city",4)==0 && variation==2){
	create_samplebutton("city","110",  "beatbox.png", "city_110_beatbox_1.wav",       594.0, 169.0,TANGLE_WIDGET(view));
	create_samplebutton("city","110",  "crane.png",   "city_110_synth_melody_2.wav",  449.0,  23.0,TANGLE_WIDGET(view));
	create_samplebutton("city","110",  "robot.png",   "city_110_fx_2.wav",            292.0, 204.0,TANGLE_WIDGET(view));
	create_samplebutton("city","110",  "sign.png",    "city_110_trumpet_2.wav",       479.0, 144.0,TANGLE_WIDGET(view));
	create_samplebutton("city","110",  "skate.png",   "city_110_gliss_bass_2.wav",    161.0, 121.0,TANGLE_WIDGET(view));
	create_samplebutton("city","110",  "zeppelin.png","city_110_bass_strings_2.wav",  299.0,   0.0,TANGLE_WIDGET(view));
	
	background_color_code = "bbbbbbbbrrrrbbbbrrrrbbbbrrrr##";
	disabled_slots_for_end = 2;
	}
	else if (strncmp(name,"city",4)==0 && variation==3){
	create_samplebutton("city","90",  "car.png",         "city_90_bass_shaker_2.wav",  286.0, 183.0,TANGLE_WIDGET(view));
	create_samplebutton("city","90",  "chopper.png",     "city_90_melody1_2.wav",      387.0,   0.0,TANGLE_WIDGET(view));
	create_samplebutton("city","90",  "flower.png",      "city_90_synth_chords_2.wav", 471.0, 237.0,TANGLE_WIDGET(view));
	create_samplebutton("city","90",  "icecreamvan.png", "city_90_bell_melody_2.wav",  114.0, 155.0,TANGLE_WIDGET(view));
	create_samplebutton("city","90",  "jumpingrope.png", "city_90_melody2_2.wav",      651.0, 193.0,TANGLE_WIDGET(view));
	create_samplebutton("city","90",  "ufo.png",         "city_90_fx_2.wav",           264.0,  11.0,TANGLE_WIDGET(view));
	
	background_color_code = "ggggggggyyyyllllgggggggg##";
	disabled_slots_for_end = 2;
	}

	else if (strncmp(name,"animal",6)==0 && variation==1){
	create_samplebutton("animal","140",  "flamingo.png", "animalw_140_marimba_2.wav",   679.0, 165.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","140",  "gnome.png",    "animalw_140_vocal1_2.wav",    136.0, 220.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","140",  "gnomes.png",   "animalw_140_singing_2.wav",   297.0, 165.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","140",  "mouse.png",    "animalw_140_ud_2.wav",        310.0, 269.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","140",  "raven.png",    "animalw_140_vocal2_2.wav",    530.0,  71.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","140",  "snake.png",    "animalw_140_rainstick_1.wav", 600.0, 249.0,TANGLE_WIDGET(view));
	
	background_color_code = "yyyyyyyyoooooooorrrrrrrryyyyyyyy";
	}
	else if (strncmp(name,"animal",6)==0 && variation==2){
	create_samplebutton("animal","110",  "crocodile.png",   "animalw_110_percussion2_2.wav", 186.0, 141.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","110",  "dragonfly.png",   "animalw_110_guitar_2.wav",      320.0,  47.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","110",  "elephant.png",    "animalw_110_bass_2.wav",        315.0, 226.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","110",  "salamander.png",  "animalw_110_percussion1_2.wav", 133.0, 251.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","110",  "snake.png",       "animalw_110_vibraslap_2.wav",   448.0, 117.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","110",  "spider.png",      "animalw_110_pluck_2.wav",       617.0, 222.0,TANGLE_WIDGET(view));
	
	background_color_code = "ggggggggbbbbbbbbgggggggg#";
	disabled_slots_for_end = 1;
	}
	else if (strncmp(name,"animal",6)==0 && variation==3){
	create_samplebutton("animal","90",  "bluebird.png",  "animalw_90_accordion2_2.wav",      533.0,  68.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","90",  "butterfly.png", "animalw_90_guitar1_2.wav",         122.0,  29.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","90",  "flower.png",    "animalw_90_guitar2_2.wav",         337.0, 281.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","90",  "goril.png"  ,   "animalw_90_percussion_bass_2.wav", 329.0, 173.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","90",  "greenbird.png", "animalw_90_accordion1_2.wav",       74.0, 150.0,TANGLE_WIDGET(view));
	create_samplebutton("animal","90",  "monkey.png"    ,"animalw_90_percussion_2.wav",      328.0,  30.0,TANGLE_WIDGET(view));
	
	background_color_code = "yyyyyyyyggggggggoooooooo##";
	disabled_slots_for_end = 2;
	}

	} //easy game





else { //advanced
	//Make buttons and containers for samplebuttons.
	soundfamily[0] = create_soundfamily_button(name,"rhythmic_icon.png", 296.0, 103.0,TANGLE_WIDGET(view));
	soundfamily[1] = create_soundfamily_button(name,"melodic_icon.png",  101.0, 164.0,TANGLE_WIDGET(view));
	soundfamily[2] = create_soundfamily_button(name,"harmonic_icon.png", 631.0, 199.0,TANGLE_WIDGET(view));
	soundfamily[3] = create_soundfamily_button(name,"effect_icon.png",   548.0,  26.0,TANGLE_WIDGET(view));

	if (strncmp(name,"fantasy",7)==0){
	//Rhythmic loops
	create_samplebutton( "fantasy","advanced","donkey_1.png",  "Rh_90__34_1_shaker2.wav",   216.0,  20.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "fantasy","advanced","donkey_2.png",  "Rh_90__34_2_bassdrum.wav",  296.0,  20.0,TANGLE_WIDGET(soundfamily[0])); 
	create_samplebutton( "fantasy","advanced","donkey_3.png",  "Rh_90__34_1_triangle.wav",  216.0, 103.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "fantasy","advanced","donkey_4.png",  "Rh_90__34_1_cajon.wav",     396.0,  20.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "fantasy","advanced","donkey_5.png",  "Rh_90__34_1_shaker.wav",    396.0, 103.0,TANGLE_WIDGET(soundfamily[0]));

	//Melodic loops
	create_samplebutton("fantasy","advanced","potion_1.png",  "Me_90_F_34_1_piano.wav",        120.0, 80.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("fantasy","advanced","potion_2.png",  "Me_90_D_34_1_synth.wav",        51.0, 110.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("fantasy","advanced","potion_3.png",  "Me_90_A_34_2_vibraphone.wav",   190.0, 204.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("fantasy","advanced","potion_4.png",  "Me_90_A_34_2_whistle.wav",      190.0, 120.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("fantasy","advanced","potion_5.png",  "Me_90_C_34_2_flute.wav",        190.0,  35.0,TANGLE_WIDGET(soundfamily[1]));

	//Harmonic loops
	create_samplebutton( "fantasy","advanced", "unicorn_1.png", "Ha_90_Dm_34_2_synth.wav",     721.0, 203.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "fantasy","advanced", "unicorn_2.png", "Ha_90_Dm_34_2_guitar.wav",    721.0, 115.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "fantasy","advanced", "unicorn_3.png", "Ha_90_D_34_2_accordion.wav",  621.0, 110.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "fantasy","advanced", "unicorn_4.png", "Ha_90_Am_34_2_elpiano.wav",   545.0, 110.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "fantasy","advanced", "unicorn_5.png", "Ha_90_Am_34_2_cello.wav",     465.0, 95.0,TANGLE_WIDGET(soundfamily[2]));

	//Effect loops
	create_samplebutton( "fantasy","advanced", "ghost_1.png",  "Fx_90__34_1_vibraslap.wav",   648.0, 26.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "fantasy","advanced", "ghost_2.png",  "Fx_90__34_2_chimes.wav",      450.0,  26.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "fantasy","advanced", "ghost_3.png",  "Fx_90__34_2_gong.wav",        450.0, 110.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "fantasy","advanced", "ghost_4.png",  "Fx_90_Dm_34_2_crystal.wav",    548.0, 110.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "fantasy","advanced", "ghost_5.png",  "Fx_90_Dn_34_2_synth.wav",      648.0, 110.0,TANGLE_WIDGET(soundfamily[3]));

	if (variation==1)
		{
		background_color_code = "rrrrrrrrbbbbbbbbrrrrrrrrbbbbbbbbrrrrrrrr"; //'rhythmic'
		tempo_factory=3;
		}
	if (variation==2)
		{
		background_color_code = "bbbbvvvvbbbbvvvvrrrrbbbbvvvvbbbbvvvvrrrr";  //'strings'
		tempo_factory=3;
		}
	if (variation==3)
		{
		background_color_code = "vvvvbbbbvvvvbbbbvvvvbbbbllllvvvvvvvv####";  //'synth'
		tempo_factory=3;
		disabled_slots_for_end = 3;
		}
	beats_per_minute = 90;  //All advanced fantasy variations use same set of samples, so they have same bpm
	
	}
	
	else if (strncmp(name,"animal",6)==0){
	//Rhythmic loops
	create_samplebutton( "animal","advanced","monkey_1.png",  "Rh_110__54_1_bongo.wav",      216.0,  20.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "animal","advanced","monkey_2.png",  "Rh_110__54_1_cajon.wav",      296.0,  20.0,TANGLE_WIDGET(soundfamily[0])); 
	create_samplebutton( "animal","advanced","monkey_3.png",  "Rh_110__54_1_darabouka.wav",  216.0, 103.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "animal","advanced","monkey_4.png",  "Rh_110__54_1_percussion.wav", 396.0,  20.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "animal","advanced","monkey_5.png",  "Rh_110__54_1_tabla.wav",      396.0, 103.0,TANGLE_WIDGET(soundfamily[0]));

	//Melodic loops
	create_samplebutton("animal","advanced","salamander_1.png",  "Me_110_A_54_1_clarinet.wav",  120.0,  80.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("animal","advanced","salamander_2.png",  "Me_110_C_54_1_flute.wav",      51.0, 110.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("animal","advanced","salamander_3.png",  "Me_110_D_54_1_marimba.wav",   190.0, 204.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("animal","advanced","salamander_4.png",  "Me_110_D_54_1_oud.wav",       190.0, 120.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("animal","advanced","salamander_5.png",  "Me_110_F_54_1_pluck.wav",     190.0,  35.0,TANGLE_WIDGET(soundfamily[1]));

	//Harmonic loops
	create_samplebutton( "animal","advanced", "dragonfly_1.png", "Ha_110_A_54_1_accordion.wav",  721.0, 203.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "animal","advanced", "dragonfly_3.png", "Ha_110_D_54_1_guitar.wav",     721.0, 115.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "animal","advanced", "dragonfly_2.png", "Ha_110_D_54_1_zither.wav",     651.0, 110.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "animal","advanced", "dragonfly_4.png", "Ha_110_G_54_1_guitar.wav",     605.0, 110.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "animal","advanced", "dragonfly_5.png", "Ha_110_G_54_1_marimba.wav",    575.0, 203.0,TANGLE_WIDGET(soundfamily[2]));

	//Effect loops
	create_samplebutton( "animal","advanced", "bird_1.png",  "Fx_110__54_1_birdshout.wav",     648.0,  26.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "animal","advanced", "bird_2.png",  "Fx_110__54_1_monkeyshout.wav",   480.0,  26.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "animal","advanced", "bird_3.png",  "Fx_110__54_1_parrot.wav",        480.0, 110.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "animal","advanced", "bird_4.png",  "Fx_110__54_1_shaker.wav",        548.0, 110.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "animal","advanced", "bird_5.png",  "Fx_110__54_4_rainstick.wav",     618.0, 110.0,TANGLE_WIDGET(soundfamily[3]));

	if (variation==1)
		{
		background_color_code = "ggggyyyyvvvvyyyygggggggg#"; //'drumming/percussion'  //this is one slot shorter than another tracks!
		tempo_factory=5;
		}
	if (variation==2)
		{
		background_color_code = "rrrrrrrroooooooorrrrrrrr##";  //'flute'
		tempo_factory=5;
		}
	if (variation==3)
		{
		background_color_code = "yyyyggggyyyyggggyyyygggg##";  //'marimba'
		tempo_factory=5;
		}
		
	disabled_slots_for_end = 2; //each variations has same
	beats_per_minute = 110;  //All advanced animal variations use same set of samples, so they have same bpm
	}


	else if (strncmp(name,"city",4)==0){
	//Rhythmic loops 
	create_samplebutton( "city","advanced","bucket_1.png",  "Rh_140__44_2_cowbell.wav",      216.0,  20.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "city","advanced","bucket_2.png",  "Rh_140__44_2_eldrums1.wav",     296.0,  20.0,TANGLE_WIDGET(soundfamily[0])); 
	create_samplebutton( "city","advanced","bucket_3.png",  "Rh_140__44_2_eldrums2.wav",     216.0, 103.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "city","advanced","bucket_4.png",  "Rh_140__44_2_rockdrums1.wav",   396.0,  20.0,TANGLE_WIDGET(soundfamily[0]));
	create_samplebutton( "city","advanced","bucket_5.png",  "Rh_140__44_2_rockdrums2.wav",   396.0, 103.0,TANGLE_WIDGET(soundfamily[0]));

	//Melodic loops 
	create_samplebutton("city","advanced","guitar_1.png",  "Me_140_D_44_2_bass2.wav",     140.0,  80.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("city","advanced","guitar_2.png",  "Me_140_D_44_2_guitar2.wav",    71.0,  80.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("city","advanced","guitar_3.png",  "Me_140_F_44_2_guitar1.wav",   210.0, 204.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("city","advanced","guitar_4.png",  "Me_140_F_44_2_synth.wav",     210.0, 120.0,TANGLE_WIDGET(soundfamily[1]));
	create_samplebutton("city","advanced","guitar_5.png",  "Me_140_G_44_2_bass1.wav",     210.0,  35.0,TANGLE_WIDGET(soundfamily[1]));

	//Harmonic loops 
	create_samplebutton( "city","advanced", "cycle_5.png", "Ha_140_C_44_2_synth2.wav",      716.0, 203.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "city","advanced", "cycle_3.png", "Ha_140_D_44_2_guitar2.wav",     721.0, 115.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "city","advanced", "cycle_2.png", "Ha_140_D_44_2_organ.wav",       611.0, 120.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "city","advanced", "cycle_4.png", "Ha_140_G_44_2_guitar1.wav",     525.0, 125.0,TANGLE_WIDGET(soundfamily[2]));
	create_samplebutton( "city","advanced", "cycle_1.png", "Ha_140_G_44_2_synth1.wav",      535.0, 203.0,TANGLE_WIDGET(soundfamily[2]));

	//Effect loops
	create_samplebutton( "city","advanced", "chopper_1.png",  "Fx_140__44_2_claps.wav",       628.0,  26.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "city","advanced", "chopper_2.png",  "Fx_140_G_44_2_highsynth.wav",  440.0,  26.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "city","advanced", "chopper_3.png",  "Fx_140_G_44_2_robot.wav",      460.0, 110.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "city","advanced", "chopper_4.png",  "Fx_140_G_44_2_synth.wav",      548.0, 110.0,TANGLE_WIDGET(soundfamily[3]));
	create_samplebutton( "city","advanced", "chopper_5.png",  "Fx_140_G_44_2_trumpet.wav",    638.0, 110.0,TANGLE_WIDGET(soundfamily[3]));

	if (variation==1)
		{
		background_color_code = "yyyyrrrryyyyyyyyrrrrrrrryyyyyyyyrrrrrrrr##"; //'drums'
		tempo_factory=4;
		}
	if (variation==2)
		{
		background_color_code = "rrrrrrrrooooyyyyyyyyrrrrrrrryyyyyyyyoooo##";  //'guitar'
		tempo_factory=4;
		}
	if (variation==3)
		{
		background_color_code = "rrrroooorrrroooorrrroooorrrroooorrrroooo##";  //'synth'
		tempo_factory=4;
		}
		
	disabled_slots_for_end = 2; //each variations has same
	beats_per_minute = 140;  //All advanced city variations use same set of samples, so they have same bpm
	}
		
		
		
	backing_track_filepath = g_strdup_printf("%s/%s/advanced/backing_track_variation_%d.wav", THEMES_DIR, name,variation);
	use_two_tracks=TRUE;
} //advanced game


int y_offset =0;
if (use_two_tracks) y_offset=80;

	JammoSequencer* sequencer = jammo_sequencer_new();
	composing_sequencer = sequencer; //needed when closing composing game

	//Container for tracks (one or two) and backing_track
	ClutterActor *container_for_tracks = tangle_widget_new();
	

	//Backing track
	printf("backingtrack filename: '%s'\n",backing_track_filepath);
	int fd = open(backing_track_filepath,O_RDONLY);
	if (fd != -1) { //Found it.
		JammoEditingTrack* backing_track = jammo_editing_track_new();
		jammo_sequencer_add_track(sequencer, JAMMO_TRACK(backing_track));
		jammo_editing_track_add_sample(backing_track, jammo_sample_new_from_file(backing_track_filepath), 0);
		g_free(backing_track_filepath);
	}


	ClutterActor *container_for_backingtrack_blocks = tangle_widget_new();
	clutter_actor_set_position(container_for_backingtrack_blocks, 0.0, 0.0);

	int number_of_slots = create_backing_track_color_coding(background_color_code,WIDTH_OF_SLOT,y_offset,TANGLE_WIDGET(container_for_backingtrack_blocks));
	tangle_widget_add(TANGLE_WIDGET(container_for_tracks), container_for_backingtrack_blocks, NULL);
	
	//Tune width of containers
	clutter_actor_set_size(container_for_backingtrack_blocks,number_of_slots*WIDTH_OF_SLOT, 38.0);
	clutter_actor_set_size(container_for_tracks,number_of_slots*WIDTH_OF_SLOT, 120.0+y_offset); //track is 80 and backingtrack is 40
	

	printf("tempo_factory (time_sig): %d, beats_per_minute: %d\n",tempo_factory,beats_per_minute);

	//We want operate whole time with guint64.
	guint64 temp=60*tempo_factory;
	guint64 one_second = 1000000000L;
	guint64 big = temp * one_second;
	guint64 slot_duration = big / beats_per_minute;


	//Bottom track. Below of this there will be place for scrollbar.
	JammoEditingTrack* editing_track_theme = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(editing_track_theme));
	ClutterActor*	track_view = jammo_track_view_new(editing_track_theme, number_of_slots,slot_duration, WIDTH_OF_SLOT);
	g_object_set(track_view, "disabled-slots-begin", disabled_slots_for_begin, "disabled-slots-end", disabled_slots_for_end,NULL);
	clutter_actor_set_reactive(track_view, TRUE);
	g_object_set(track_view, "line-every-nth-slot", 2, NULL);
	clutter_actor_set_position(track_view, 0.0, 2.0+y_offset);
	tangle_widget_add(TANGLE_WIDGET(container_for_tracks), track_view, NULL);

	bottom_track_view = JAMMO_TRACK_VIEW(track_view); //This is needed when loading/saving
	upper_track_view = NULL; //This will be NULL, if use_two_tracks is not TRUE.
	
	if (use_two_tracks){
	//Upper track.
	JammoEditingTrack* editing_track_theme2 = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(editing_track_theme2));
	ClutterActor*	track_view2 = jammo_track_view_new(editing_track_theme2, number_of_slots,slot_duration, WIDTH_OF_SLOT);
	g_object_set(track_view2, "disabled-slots-begin", disabled_slots_for_begin, "disabled-slots-end", disabled_slots_for_end,NULL);
	clutter_actor_set_reactive(track_view2, TRUE);
	g_object_set(track_view2, "line-every-nth-slot", 2, NULL);
	clutter_actor_set_position(track_view2, 0.0, 2.0);
	tangle_widget_add(TANGLE_WIDGET(container_for_tracks), track_view2, NULL);
	
	upper_track_view = JAMMO_TRACK_VIEW(track_view2); //This is needed when loading/saving
	}

	//Scrolling area for track (or tracks)
	ClutterActor* scrolling_actor;
	scrolling_actor = tangle_scrolling_actor_new(container_for_tracks);
	clutter_actor_set_position(scrolling_actor, 0.0, 360.0-y_offset);
	clutter_actor_set_size(scrolling_actor, 800.0, 120.0+y_offset);
	clutter_container_add_actor(CLUTTER_CONTAINER(view), scrolling_actor);




	//Play-button
	ClutterActor *play_button;
	play_button = tangle_button_new_with_background_actors(clutter_texture_new_from_file("/opt/jammo/buttons/play-button.png", NULL), clutter_texture_new_from_file("/opt/jammo/buttons/play-button.png", NULL));
	g_object_set(play_button, "x", 0.0,  "y", 195.0, NULL);
	clutter_container_add(CLUTTER_CONTAINER(view), play_button, NULL);
	clutter_actor_set_reactive(play_button,TRUE);
	g_signal_connect (play_button, "clicked", G_CALLBACK (on_play_button_clicked),sequencer);
	clutter_actor_set_name (play_button,"play");
	
	g_signal_connect(sequencer, "stopped", G_CALLBACK(on_sequencer_stopped), play_button);
	
	if (only_playing_mode)
		clutter_actor_hide(play_button);

	ClutterColor red = { 255, 0, 0, 128 };
	ClutterActor* texture;
	ClutterActor* cursor;
	
	texture = clutter_rectangle_new_with_color(&red);
	clutter_actor_set_size(texture, 10.0, 80.0 +y_offset);
	cursor = jammo_cursor_new(sequencer, texture);
	tangle_actor_set_depth_position(TANGLE_ACTOR(cursor), 1);
	clutter_actor_set_position(cursor, 0.0, 0.0);
	clutter_actor_set_size(cursor, number_of_slots*WIDTH_OF_SLOT, 80.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(container_for_tracks), cursor);

	TangleVault* vault;

	vault = tangle_vault_new(2, TANGLE_TYPE_SCROLLING_ACTOR, scrolling_actor, JAMMO_TYPE_CURSOR, cursor);
	tangle_signal_connect_vault(texture, "notify::x", G_CALLBACK(on_cursor_notify_x), vault);
}


/*
This function is called when user chooses and clicks one theme in theme_selection (defined on themeselection-view.json).
Selected theme is 'name'-property of clicked button.
*/
void themeselection_theme_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(source));
	
	//subthemes are 1,2,3.
	int variation = (rand () % 3) + 1;
	printf("Random variation is '%d'\n",variation);
	
	themeselection_start_theme(name,variation,jammo_get_actor_by_id("themeselection-view"));
}
