
#include <iostream>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sstream>
#include <cstdlib>
#include "ProfileManager.h"
#include "../cem/cem.h"

using namespace std;

ProfileManager* ProfileManager::iInstance = NULL;

ProfileManager* ProfileManager::GetInstance() 
{
	// No instance->create
	if (iInstance == NULL) iInstance = new ProfileManager;
	
	return iInstance;
}

// Constructor
ProfileManager::ProfileManager()
{
	iStorageAgent = new StorageAgent();
	// process agent not yet used.
	//iProcessAgent = NULL;
}

// Destructor
ProfileManager::~ProfileManager()
{
	if(iStorageAgent != NULL)
	{
		delete iStorageAgent;
		iStorageAgent = NULL;
	}
	/*if(iProcessAgent != NULL)
	{
		delete iProcessAgent;
		iProcessAgent = NULL;
	}*/
}

// Login, calls StorageAgent to retrieve the user
// profile data
bool ProfileManager::Login(int userID)
{
	// Store the id
	iUser = userID;
	
	string msg = "User Profile ";
	// C++ type int to string conversion
	stringstream user;
	user << userID;
	msg.append(user.str());
	
	// If profile can be retrieved correctly,
	// create a server for displaying the profile
	// to other users
	if (iStorageAgent->Retrieve(iUser) == true)
	{
		msg.append(" succesfully retrieved");
		log_wrap((char*)msg.c_str(),LOG_INFO);
		return true;
	}
	else
	{
		//cout << "Error while retrieving user profile data";
		msg.append(" cannot be found.");
		log_wrap((char*)msg.c_str(),LOG_INFO);
		return false;
	}
	
}

// Logout
bool ProfileManager::Logout()
{

	// Store the user data
	
	if (iStorageAgent->Store(iUser) == true)
	{
	
		// Clear the user from the memory
		iUser = 0;
		iStorageAgent->clearDetails();
	
		// If everything worked correctly, return true
		// Again... not implemented correctly
		return true;
	}
	
}

string ProfileManager::ViewDetails()
{
	// View my details here
	return iStorageAgent->getDetails();
}

string ProfileManager::ViewDetail(string& detail)
{
	return iStorageAgent->getDetail(detail);
}

// Edit user details. Takes the name of the detail and the new Value
// as a string
bool ProfileManager::EditDetails(string& detail, string& newValue)
{
	// If the detail changing operation is failure, function return false
	return iStorageAgent->setDetails(detail, newValue);
}

// This function is used to Force another user in to the
// profile manager. Requires admin level in the profile
bool ProfileManager::ForceUser(int userID)
{
	string auth;
	// Get detail authLevel from the profile
	// if it is admin, the user is allowed to force
	// another user to the machine
	string param = string("authLevel");
	auth = iStorageAgent->getDetail(param);
	if (auth == "admin")
	{
		// Logout the admin and login wit the
		// wanted userID
		if (Logout() == true)
		{
			Login(userID);
			return true;
		}
		else return false;
	}
	else return false;
}

void log_wrap(char* msg, int info)
{
	//cem_add_to_log(msg,info);
	//printf("message: %s (%d)\n",msg,info);
}

// New manager object
ProfileManager* gems_profilemanager_new_manager()
{
	return ProfileManager::GetInstance();
}

// Delete manager object
void gems_profilemanager_delete_manager(ProfileManager* _aManager)
{
	delete _aManager;
}

// Login to manager (no auth checking yet)
int gems_profilemanager_login(ProfileManager* _aManager, int _userId)
{
	// When true, return 1
	return (_aManager->Login(_userId)) ? 1 : 0;
}

// Logout from manager
int gems_profilemanager_logout(ProfileManager* _aManager)
{
	// When true return 1
	return (_aManager->Logout()) ? 1 : 0;
}

// View one information
const char* gems_profilemanager_view_info(ProfileManager* _aManager, char* _parameter)
{
	string param = string(_parameter);
	return (_aManager->ViewDetail(param)).c_str();
}

// Edit own info
int gems_profilemanager_edit_info(ProfileManager* _aManager, char* _parameter, char* _value)
{
	string param = string(_parameter);
	string value = string(_value);
	return (_aManager->EditDetails(param,value)) ? 1 : 0;
}

// Get own username
const char* gems_profilemanager_get_username(ProfileManager* _aManager)
{
	string param = string(PROF_PARAM_USERNAME);
	return (_aManager->ViewDetail(param)).c_str();
}

// Get first name
const char* gems_profilemanager_get_firstname(ProfileManager* _aManager)
{
	string param = string(PROF_PARAM_FIRSTNAME);
	return (_aManager->ViewDetail(param)).c_str();
}

// Get last name
const char* gems_profilemanager_get_lastname(ProfileManager* _aManager)
{
	string param = string(PROF_PARAM_LASTNAME);
	return (_aManager->ViewDetail(param)).c_str();
}

// Get age
const char* gems_profilemanager_get_age(ProfileManager* _aManager)
{
	string param = string(PROF_PARAM_AGE);
	return (_aManager->ViewDetail(param)).c_str();
}

unsigned int gems_profilemanager_get_points(ProfileManager* _aManager)
{
	string param = string(PROF_PARAM_POINTS);
	return (unsigned int)atoi(_aManager->ViewDetail(param).c_str());
}

int gems_profilemanager_set_username(ProfileManager* _aManager, char* _value)
{
	string param = string(PROF_PARAM_USERNAME);
	string value = string(_value);
	return (_aManager->EditDetails(param,value)) ? 1 : 0;
}

int gems_profilemanager_set_firstname(ProfileManager* _aManager, char* _value)
{
	string param = string(PROF_PARAM_FIRSTNAME);
	string value = string(_value);
	return (_aManager->EditDetails(param,value)) ? 1 : 0;
}

int gems_profilemanager_set_lastname(ProfileManager* _aManager, char* _value)
{
	string param = string(PROF_PARAM_LASTNAME);
	string value = string(_value);
	return (_aManager->EditDetails(param,value)) ? 1 : 0;
}

int gems_profilemanager_set_age(ProfileManager* _aManager, unsigned int _value)
{
	stringstream strvalue;
	string param = string(PROF_PARAM_AGE);
	
	if(_value > 120) return -1;
	
	strvalue << _value;
	string value = strvalue.str();
	
	return (_aManager->EditDetails(param,value)) ? 1 : 0;
}

int gems_profilemanager_add_points(ProfileManager* _aManager, unsigned int _value)
{
	string param = string(PROF_PARAM_POINTS);
	int points = atoi((_aManager->ViewDetail(param)).c_str());
	
	points += _value;
	
	stringstream strvalue;
	strvalue << points;
	
	string value = strvalue.str();
	
	return (_aManager->EditDetails(param,value)) ? 1 : 0;
}

int gems_profilemanager_remove_points(ProfileManager* _aManager, unsigned int _value)
{
	string param = string(PROF_PARAM_POINTS);
	int points = atoi((_aManager->ViewDetail(param)).c_str());
	
	if((points - (int)_value) < 0) return -1;
	points = points - _value;
	
	stringstream strvalue;
	strvalue << points;
	
	string value = strvalue.str();
	
	return (_aManager->EditDetails(param,value)) ? 1 : 0;	
}

void gems_profilemanager_reset_points(ProfileManager* _aManager)
{
	string param = string(PROF_PARAM_POINTS);
	string value = "0";
	_aManager->EditDetails(param,value);
}
