#include "gems.h"
#include "collaboration.h"
#include "messages.h"
#include "messagehandler.h"

/* Initializes components of GEMS and stores them into struct gems_components
 *
 * Return: gems_components containing pointers to gems components
 */
gems_components* jammo_gems_init(int* argc, char** argv[])
{
	gems_components* components = (gems_components*)malloc(sizeof(gems_components));
	
	// Profile manager
	components->pm = gems_profilemanager_new_manager();
	
	/* PeerHood - not yet used */
	
	// Define function pointers for notify and new connection functions
	//void (*notify)(short, const char*,void*) = NULL;
	//void (*newconnection)(const unsigned short, MAbstractConnection*, int,void*) = NULL;
	
	//notify = &gems_ph_callback_notify;
	//newconnection = &gems_ph_callback_newconnection;
	
	//components->ph_cb = ph_c_create_callback(notify, newconnection, NULL, NULL);
	//components->ph = ph_c_get_instance(components->ph_cb);
	//ph_c_init(components->ph,&argc,argv);
	return components;
}

/* Delete the components and free the struct
 */
void jammo_gems_cleanup(gems_components* components)
{
	gems_profilemanager_delete_manager(components->pm);
	
	/* PeerHood - not yet used */
	//ph_c_delete_peerhood(components->ph);
	//ph_c_delete_callback(components->ph_cb);
	free(components);
}


void gems_list_profile_parameters(ProfileManager* pm)
{
	printf("username:\t%s\nfull name:\t%s %s\nuser age:\t%s\ntotal points:\t%d\n",
		gems_profilemanager_get_username(pm),
		gems_profilemanager_get_firstname(pm),
		gems_profilemanager_get_lastname(pm),
		gems_profilemanager_get_age(pm),
		gems_profilemanager_get_points(pm));
}

/*Forward the messages to collaboration module */
void gems_add_new_sample_to_track(int track_number, const gchar srcLocation[], guint64 startTime)
{
	collaboration_add_new_sample_to_track(track_number, srcLocation, startTime);
}
void gems_add_new_sample_to_track_nth_slot(int track_number, const gchar srcLocation[], guint slot)
{
	collaboration_add_new_sample_to_track_nth_slot(track_number, srcLocation, slot);
}
void gems_remove_sample_from_slot(guint track_number,int slot)
{
	collaboration_remove_sample_from_slot(track_number,slot);
}
void gems_start_pair_game()
{

}
int gems_create_game_server(int port)
{
	return collaboration_create_game_server(port);
}
int gems_create_game_client(char *address, int port)
{
	return collaboration_create_game_client(address, port);
}

/**
 * Notify callback - called by C_Callback when notify event occurs 
 */
/*
void gems_ph_callback_notify(short aEvent, const char* aAddress,void* aData)
{
	printf("Some event notify (%d) from %s.\n", aEvent,aAddress);
}
*/

/**
 * New connection callback - called by C_Callback when new connection is established
 */
/*
void gems_ph_callback_newconnection(const unsigned short aPort, MAbstractConnection* aConnection, int aConnectionId, void* aData)
{
		ph_c_connection_delete(aConnection);
}
*/

