/*
 * jammo-meam.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#include "jammo-meam.h"
#include "jammo-pipeline.h"
#include "gst-jammo-plugins/pitchdetect-plugin/gstjammopitchdetect.h"
#include "gst-jammo-plugins/sampler-plugin/gstjammosampler.h"
#include "gst-jammo-plugins/slider-plugin/gstjammoslider.h"

#include <gst/gst.h>
#include <gst/controller/gstcontroller.h>

void jammo_meam_init(int* argc, char** argv[]) {
	gst_init(argc, argv);
	
	gst_controller_init (NULL, NULL);

	gst_element_register(NULL, "jammopipeline", 0, JAMMO_TYPE_PIPELINE);
	gst_element_register(NULL, "pitchdetect", 0, GST_TYPE_PITCHDETECT);
	gst_element_register(NULL, "jammosampler", 0, GST_TYPE_JAMMO_SAMPLER);
	gst_element_register(NULL, "jammoslider", 0, GST_TYPE_JAMMO_SLIDER);
}

void jammo_meam_cleanup(void) {
	gst_deinit();
}
