
#include <iostream>
#include "ProfileManager.h"
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include "../cem/cem.h"

using namespace std;

// Constructor
ProfileManager::ProfileManager()
{
	storageAgent = new StorageAgent();
}

// Destructor
ProfileManager::~ProfileManager()
{
	delete storageAgent;
	storageAgent = 0;
}

// Login, calls StorageAgent to retrieve the user
// profile data
bool ProfileManager::Login(int userID)
{
	user = userID;
	string msg = "User Profile ";
	msg += user;
	
	// If profile can be retrieved correctly,
	// create a server for displaying the profile
	// to other users
	if (storageAgent->Retrieve(user) == true)
	{
		msg += " succesfully retrieved";
		// TODO mystic error, undef. ref. when using c-function from c++
		//cem_add_to_log((char*)msg.c_str(),LOG_INFO);
		return true;
	}
	else
	{
		//cout << "Error while retrieving user profile data";
		msg += " cannot be found.";
    // TODO mystic error, undef. ref. when using c-function from c++
		//cem_add_to_log((char*)msg.c_str(),LOG_INFO);
		return false;
	}
	
}

// Logout
bool ProfileManager::Logout()
{

	// Store the user data
	
	if (storageAgent->Store(user) == true)
	{
	
	// Clear the user from the memory
	user = 0;
	storageAgent->clearDetails();
	
	// If everything worked correctly, return true
	// Again... not implemented correctly
	return true;
	}
	
}

string ProfileManager::ViewDetails()
{
	// View my details here
	return storageAgent->getDetails();
	
}

string ProfileManager::ViewDetail(string detail)
{
	return storageAgent->getDetail(detail);
}

// Edit user details. Takes the name of the detail and the new Value
// as a string
bool ProfileManager::EditDetails(string detail, string newValue)
{
	// If the detail changing operation is failure, return false
	if ( (storageAgent->setDetails(detail, newValue)) == false)
	{
		return false;
	}
	return true;
}


/*************** C API WRAPPERS ****************/

// New manager object
ProfileManager* gems_profilemanager_new_manager()
{
	return new ProfileManager;
}

// Delete manager object
void gems_profilemanager_delete_manager(ProfileManager* _aManager)
{
	delete _aManager;
}

// Login to manager (no auth checking yet)
int gems_profilemanager_login(ProfileManager* _aManager, int _userId)
{
	// When true, return 1
	return (_aManager->Login(_userId)) ? 1 : 0;
}

// Logout from manager
int gems_profilemanager_logout(ProfileManager* _aManager)
{
	// When true return 1
	return (_aManager->Logout()) ? 1 : 0;
}

// View one information
const char* gems_profilemanager_view_info(ProfileManager* _aManager, char* _parameter)
{
	return (_aManager->ViewDetail(string(_parameter))).c_str();
}

// Edit own info
int gems_profilemanager_edit_info(ProfileManager* _aManager, char* _parameter, char* _value)
{
	return (_aManager->EditDetails(string(_parameter),string(_value))) ? 1 : 0;
}

// Init the profile with given info
int gems_profilemanager_init_info(ProfileManager* _aManager, char* _username,char* _firstname,	char* _lastname, char* _age)
{
  if(_aManager->EditDetails(string("userName"),string(_username)) &&
     _aManager->EditDetails(string("firstName"),string(_firstname)) &&
     _aManager->EditDetails(string("lastName"),string(_lastname)) &&
     _aManager->EditDetails(string("age"),string(_age))) return 1;
  else return 0;
}

const char* gems_profilemanager_get_username(ProfileManager* _aManager)
{
	return (_aManager->ViewDetail(string("userName"))).c_str();
}
const char* gems_profilemanager_get_firstname(ProfileManager* _aManager)
{
	return (_aManager->ViewDetail(string("firstName"))).c_str();
}
const char* gems_profilemanager_get_lastname(ProfileManager* _aManager)
{
	return (_aManager->ViewDetail(string("lastName"))).c_str();
}
const char* gems_profilemanager_get_age(ProfileManager* _aManager)
{
	return (_aManager->ViewDetail(string("age"))).c_str();
}

