/**object.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
Objects are those icons which user can drag from playing area to timeline area.
*/

#include <clutter/clutter.h>
#include <stdlib.h>
#include <stdio.h>
#include "clutter_jammo.h"
#include "config.h"
#include "object.h"
#include "jammo-texture.h"
#include "composing_game.h"

#include "../chum/chum.h"

//private functions
static void input_actions (JammoTexture *actor, ClutterEvent *event, gpointer data);

JammoTexture *dragging = NULL;		     /*object which is currently dragged*/
gint x_start_of_dragging, y_start_of_dragging, x_drag_offset, y_drag_offset;   /*these are related to dragging also*/

JammoTexture *get_dragging_object() { //is this used. FIXME
return dragging;
}


/*
Every time mouse moves on stage we check if dragging is going. Is so we move the
dragged object. This is because only watching dragged object we lost it if mouse
moves too fast and isn't anymore top of object.
*/
//void mouse_motion_on_stage(ClutterActor *actor, ClutterEvent *event, gpointer data) {
void motion_on_object(ClutterActor *actor, ClutterEvent *event, gpointer data) {
  gint x_mouse_position, y_mouse_position;
/*
clutter_event_get_coords (event,&x_mouse_position, &y_mouse_position);
clutter_actor_set_position (CLUTTER_ACTOR(actor), x_mouse_position, y_mouse_position);
return;
*/
  if (CLUTTER_IS_ACTOR(dragging) && dragging != NULL) {
      clutter_event_get_coords (event,&x_mouse_position, &y_mouse_position);
      //printf("X=%d, Y=%d\n",x_mouse_position, y_mouse_position);
      gint new_x, new_y;

      //If object are over valid_area, use SNAPPING.
      if (is_inside_valid_area(x_mouse_position, y_mouse_position)) {
	  int slot_number =  (x_mouse_position + x_drag_offset) / WIDTH_OF_SLOT;
	  new_x = slot_number*WIDTH_OF_SLOT;
	  new_y=Y_PLACE_OF_TIMELINE;
      } else {
	  new_x=x_mouse_position + x_drag_offset;
	  new_y=y_mouse_position + y_drag_offset;
      }

      clutter_actor_set_position (CLUTTER_ACTOR(dragging), new_x, new_y);		
  }
}

/*When we want stop behaviour, we add signal to timeline which triggers when frame 1 starts.
Then this function is called and we stop behaviour for this actor.*/
static void start_of_loop(ClutterTimeline *timeline,  gchar *name, gint frame, gpointer data) {
//We want this happens only once, so remove it.
clutter_timeline_remove_marker(timeline,name); 
//printf("frame 1 reached: %s\n",name);

    ActorBehaviour *ab = (ActorBehaviour*)data;
    ClutterActor *actor = ab->actor;
    ClutterBehaviour *behaviour = ab->behaviour;

    clutter_behaviour_remove (behaviour,actor);
}


/*
Use this function when actor is placed in valid-area.
This handles only places of graphical actors.
*/
void put_in_timeline(JammoTexture *dropped_actor, gint release_x)  {
//This new will take asked place.
clutter_actor_set_position (CLUTTER_ACTOR(dropped_actor), release_x, Y_PLACE_OF_TIMELINE);

gint width_of_new=clutter_actor_get_width(CLUTTER_ACTOR(dropped_actor));
int slots_of_new= width_of_new / WIDTH_OF_SLOT; //how many slot this takes.
//printf("put_in_timeline starts: x=%d, width=%d\n",release_x,width_of_new);

int i,j;

  //Loop over all actors
  ClutterActor *stage=clutter_actor_get_parent(CLUTTER_ACTOR(dropped_actor));
  GList* children= clutter_container_get_children (CLUTTER_CONTAINER (stage));
  GList *l;
  for (l = children; l; l = l->next){
    JammoTexture *actor = l->data;
       gint x0,y0; //objects coordinates
       clutter_actor_get_position (CLUTTER_ACTOR(actor),&x0,&y0);
       //we are interested in only objects in valid_area (but not current_actor)
       if (is_inside_valid_area(x0,y0) && actor != dropped_actor){
             //printf("x=%d, y=%d\n",x0,y0);
	     gint x0_width=clutter_actor_get_width(CLUTTER_ACTOR(actor));
	     gint x0_slots=x0_width/ WIDTH_OF_SLOT;
	     for (i=0;i<slots_of_new;i++) {
		  for (j=0;j<x0_slots;j++) {
		      //check if new actor has any common slots with this
		      if ((x0+j*WIDTH_OF_SLOT==release_x+i*WIDTH_OF_SLOT)) { 
			  //move it too
			  put_in_timeline(actor,x0+(slots_of_new-i+j)*WIDTH_OF_SLOT);
			  //break;
		      }
		  }
	    }
      }
  }

}


/**
dropped_actor = actor which is just placed valid_area
release_x, release_y = its coordinates (they are in valid_area)
*/
void object_add_to_timeline(JammoTexture *dropped_actor, gint release_x,gint sukka_y){
int slot_number = release_x / WIDTH_OF_SLOT;
gint icon_place_of_dropped = slot_number*WIDTH_OF_SLOT;   //this is x coordinate of dropped

printf ("slot number %d\n",slot_number);
put_in_timeline(dropped_actor,icon_place_of_dropped);

//Put sound
 gchar *sound;
  g_object_get(G_OBJECT(dropped_actor), "sound-file", &sound, NULL);

  gchar* buffer0;
  buffer0 = g_strdup_printf("../share/jammo/themes/%s/%s",chum_get_theme_folder(chum_get_current_theme()), sound);

  chum_add_new_sample_to_track_nth_slot(0,buffer0,slot_number);


//stop behaving
  GList *behaviours_and_actors = get_current_behaviours_and_actors();
  GList *l_counter;
  int counter=0;

  for (l_counter = behaviours_and_actors; l_counter; l_counter = l_counter->next){
    counter++;
    ActorBehaviour *ab = l_counter->data;
    ClutterActor *actor = ab->actor;
    if (dropped_actor==actor)	{
	printf("found\n");
	ClutterAlpha* alpha=clutter_behaviour_get_alpha(ab->behaviour);
	ClutterTimeline *tl=clutter_alpha_get_timeline (alpha);

	clutter_timeline_add_marker_at_frame (tl,"first_frame",1);
	g_signal_connect (tl, "marker-reached", G_CALLBACK (start_of_loop),ab);

	//some mysterious reason, we can't remove first entry from list
	//just let it here (this isn't cumulative bloat)
	if (counter==1)
	    {}
	else
	  behaviours_and_actors=g_list_remove(behaviours_and_actors,l_counter->data);

	break; //we can stop when actor is founded
    }
    else printf("not\n");
  }

}


/**
 * This function is connected to mouse clicking signals, thus being
 * called every time when mouse button is pressed or released.
 * 
 * @param	actor		Target object
 * 
 * @param 	event		this parameter contains all info
 * 				about every event that happens when the program
 * 				gets some input from mouse etc
 * 
 * @param	data		this pointer holds information about coordinates
 * 				of the events and such
 */

void sukka_do_dragging_ends(gint x_release, gint y_release) {
//if user drags object over button, dragging is forced to stop. 
//Then user release mousebutton and this function is executed  again.
if (dragging == NULL){
  return;
}
JammoTexture *actor =dragging;

/*There are four possibilities.
A) Dragged object starts from valid_area and it is moved another place in valid_area
B) Dragged object starts from valid_area and it is removed out from valid_area
C) Dragged object starts from stage and lands on valid_area
D) Dragged object starts from stage and lands on stage

*/

//check are we handling already placed objects
//we need better way to solve this. FIXME
if (is_inside_valid_area((x_start_of_dragging += x_drag_offset), (y_start_of_dragging += y_drag_offset))) {
  int slot_number = (x_start_of_dragging - x_drag_offset) / WIDTH_OF_SLOT;
  chum_remove_sample_from_slot(0,slot_number); //first parameter is track_number

  //moving valid_area to valid_area.
  if ((is_inside_valid_area( (x_release + x_drag_offset), (y_release + y_drag_offset)))) {
    //use this (if there are something in way, they are handled too)
    object_add_to_timeline(actor,x_release + x_drag_offset, (y_release + y_drag_offset));
  }
  else  {
    clutter_container_remove_actor(CLUTTER_CONTAINER(clutter_actor_get_parent(CLUTTER_ACTOR(actor))), CLUTTER_ACTOR(actor));
    }
}else {

//We are handling object from stage 
      if (is_inside_valid_area( (x_release + x_drag_offset), (y_release + y_drag_offset))) {
	//it is allowed to place here
	object_add_to_timeline(actor,x_release + x_drag_offset, (y_release + y_drag_offset));
	  //object_add_to_timeline(actor,x_release, (y_release ));

///////////////////
	  //Spawn new object in stage.
	  ClutterActor* parent_group = clutter_actor_get_parent(CLUTTER_ACTOR(dragging));
	  const gchar* id_of_actor;
	  id_of_actor = clutter_get_script_id(G_OBJECT(actor));

	  ClutterActor* new_actor;
	  new_actor = config_get_configured_actor(chum_get_theme_folder(chum_get_current_theme()),  (gchar*)id_of_actor);
	
	  if (new_actor ==NULL)
	      printf("new_actor is NULL\n");
	  if (parent_group ==NULL)
	    printf("parent_group is NULL\n");

	  clutter_container_add_actor(CLUTTER_CONTAINER(parent_group), new_actor);
	  clutter_actor_set_reactive(new_actor, TRUE);
	  g_signal_connect (new_actor, "button-press-event", G_CALLBACK (input_actions), NULL);
	  g_signal_connect (new_actor, "button-release-event", G_CALLBACK (input_actions), NULL);

      } else {
	  //Forbidden place to drop object, move it back where it comes.
	  clutter_actor_set_position (CLUTTER_ACTOR(dragging), x_start_of_dragging, y_start_of_dragging );
     }
  }
    //And now dragging is over
    dragging = NULL;
}

/**
When  mouse is pressed or released over object this function is called.
*/
static void input_actions (JammoTexture *actor, ClutterEvent *event, gpointer data) {
	// the actions below take place when the mouse event is a button press
	if (event->type == CLUTTER_BUTTON_PRESS) {

	    clutter_event_get_coords (event, &x_start_of_dragging, &y_start_of_dragging);
	    // puts the actor clicked to the dragging actor
	    dragging=actor;
	    x_drag_offset = (clutter_actor_get_x (CLUTTER_ACTOR(dragging)) - x_start_of_dragging);
	    y_drag_offset = (clutter_actor_get_y (CLUTTER_ACTOR(dragging)) - y_start_of_dragging);

	 


	// the actions below take place when the mouse event is button release
	} else if (event->type == CLUTTER_BUTTON_RELEASE) {
	  
	}
}


/**
 * This function checks the coordinates to determine whether the given 
 * location is inside valid area (dropping area) and returns a boolean
 *
 * @param	x_release	this is the x-coordinate 
 * 
 * @param	y_release	this is the y-coordinate 
 * 
 * @return	gboolean	this just returns a boolean is this coordinate inside area
 */
gboolean is_inside_valid_area (gint asked_x, gint asked_y) {
	ClutterActor* valid_area = get_drop_area();

	gint valid_area_x = clutter_actor_get_x(CLUTTER_ACTOR(valid_area));
	gint valid_area_y = clutter_actor_get_y(CLUTTER_ACTOR(valid_area));
	guint valid_area_width = clutter_actor_get_width(CLUTTER_ACTOR(valid_area));
	guint valid_area_height = clutter_actor_get_height(CLUTTER_ACTOR(valid_area));

	//printf("valid_area: x=%d, y=%d, width=%d, heigth=%d\n",valid_area_x,valid_area_y,valid_area_width,valid_area_height);
	//printf("in_valid_area? x=%d, y=%d\n",x_release,y_release);

	gboolean r =FALSE;
	// returns true if the position is inside the given values
	if( asked_x > valid_area_x && asked_x < (valid_area_x + valid_area_width) ) {
	  if( asked_y > valid_area_y && (asked_y) < (valid_area_y + valid_area_height) ) {
			r=TRUE;
		}
	}
return r;
}


static void object_pressed (JammoTexture *actor, ClutterEvent *event, gpointer data) {
  clutter_event_get_coords (event, &x_start_of_dragging, &y_start_of_dragging);
  dragging=actor;// puts the actor clicked to the dragging actor
  x_drag_offset = (clutter_actor_get_x (CLUTTER_ACTOR(dragging)) - x_start_of_dragging);
  y_drag_offset = (clutter_actor_get_y (CLUTTER_ACTOR(dragging)) - y_start_of_dragging);

  //even this object is not focused it still gets the mouse events
  clutter_grab_pointer(CLUTTER_ACTOR(actor)); 
}



static void object_released (JammoTexture *actor, ClutterEvent *event, gpointer data) {
  //If object are clicked but not moved, we play its sound
  gint x_release, y_release;
  clutter_event_get_coords (event, &x_release, &y_release);
 
  clutter_ungrab_pointer(); //even this object is not focused it still gets the event

if (x_release==x_start_of_dragging && y_release==y_start_of_dragging) 
//  if (!(is_inside_valid_area(x_release, y_release)))
    {
printf("aani triggas\n");
    gchar *sound;
      g_object_get(G_OBJECT(actor), "sound-file", &sound, NULL);
      gchar* buffer0;
      buffer0 = g_strdup_printf("../share/jammo/themes/%s/%s",chum_get_theme_folder(chum_get_current_theme()), sound);

      chum_play_one_sample(buffer0);
    

//And now dragging is over
    dragging = NULL;
return;
}

//if user drags object over button, dragging is forced to stop. 
//Then user release mousebutton and this function is executed  again.
if (dragging == NULL){
  printf("dragging == NULL\n");
  return;
}
//JammoTexture *actor =dragging;

/*There are four possibilities.
A) Dragged object starts from valid_area and it is moved another place in valid_area
B) Dragged object starts from valid_area and it is removed out from valid_area
C) Dragged object starts from stage and lands on valid_area
D) Dragged object starts from stage and lands on stage

*/

//check are we handling already placed objects
//we need better way to solve this. FIXME
if (is_inside_valid_area((x_start_of_dragging += x_drag_offset), (y_start_of_dragging += y_drag_offset))) {
  int slot_number = (x_start_of_dragging - x_drag_offset) / WIDTH_OF_SLOT;
  chum_remove_sample_from_slot(0,slot_number); //first parameter is track_number

  //moving valid_area to valid_area.
  if ((is_inside_valid_area( (x_release + x_drag_offset), (y_release + y_drag_offset)))) {
    //use this (if there are something in way, they are handled too)
    object_add_to_timeline(actor,x_release + x_drag_offset, (y_release + y_drag_offset));
  }
  else  {
    clutter_container_remove_actor(CLUTTER_CONTAINER(clutter_actor_get_parent(CLUTTER_ACTOR(actor))), CLUTTER_ACTOR(actor));
    }
}else {

//We are handling object from stage 
      if (is_inside_valid_area( (x_release + x_drag_offset), (y_release + y_drag_offset))) {
        //it is allowed to place here
        object_add_to_timeline(actor,x_release + x_drag_offset, (y_release + y_drag_offset));
          //object_add_to_timeline(actor,x_release, (y_release ));

///////////////////
          //Spawn new object in stage.
          ClutterActor* parent_group = clutter_actor_get_parent(CLUTTER_ACTOR(dragging));
          const gchar* id_of_actor;
          id_of_actor = clutter_get_script_id(G_OBJECT(actor));

          ClutterActor* new_actor;
          new_actor = config_get_configured_actor(chum_get_theme_folder(chum_get_current_theme()),  (gchar*)id_of_actor);
        
          if (new_actor ==NULL)
              printf("new_actor is NULL\n");
          if (parent_group ==NULL)
            printf("parent_group is NULL\n");

          clutter_container_add_actor(CLUTTER_CONTAINER(parent_group), new_actor);
          clutter_actor_set_reactive(new_actor, TRUE);
          g_signal_connect (new_actor, "button-press-event", G_CALLBACK (input_actions), NULL);
          g_signal_connect (new_actor, "button-release-event", G_CALLBACK (input_actions), NULL);

      } else {
          //Forbidden place to drop object, move it back where it comes.
          clutter_actor_set_position (CLUTTER_ACTOR(dragging), x_start_of_dragging, y_start_of_dragging );
     }
  }
    //And now dragging is over
    dragging = NULL;



}


/**
 * This function loads all objects for a stage. It loads the
 * objects to objects_group (ClutterGroup). 
 *
 * Each object got connected to signals, press, release, motion.
 * 
 * @param	objects_group	pointer for all objects in a stage
 * @param	theme_folder	Folder of asked theme
 */
void object_create_stage_object_group (ClutterActor* objects_group, const gchar *theme_folder) {
	ClutterActor* actor;

 GList *actors= config_get_objects_for_theme(theme_folder);
 GList *l;
 for (l = actors; l; l = l->next){
    actor=l->data; 
    //printf("object.c: %s\n",clutter_get_script_id(actor) );

    clutter_container_add_actor(CLUTTER_CONTAINER(objects_group), actor);
    clutter_actor_set_reactive(actor, TRUE);
    g_signal_connect (actor, "button-press-event", G_CALLBACK (object_pressed), NULL);
    g_signal_connect (actor, "button-release-event", G_CALLBACK (object_released), NULL);
    g_signal_connect (actor, "motion-event", G_CALLBACK (motion_on_object), NULL);
 }

}
