/**composing_game.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the composing game.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <clutter/clutter.h>
#include <clutter-gtk/gtk-clutter-embed.h>


#include "jammo-texture.h"
#include "clutter_jammo.h"
#include "../chum/chum.h" //THEMES_DIR
#include "object.h"
#include "config.h"
#include "button.h"


ClutterActor* timeline_star_actor;
ClutterActor* objects_in_this_stage;

//////For theme selection

static void theme_selection_mouse_release (JammoTexture *actor, ClutterEvent *event, gpointer data){
int value = GPOINTER_TO_INT(data);
chum_change_to_theme(value);
}


static void on_timeline_completed(ClutterTimeline *timeline,  gpointer data) {
  //printf("star reached end\n");
  clutter_actor_hide(timeline_star_actor);
  //chum_stop_sequencer();
}

static void on_timeline_marker_reached(ClutterTimeline *timeline,  gchar *name, gint frame, gpointer data) {
  //printf("frame_number:%s. next_key_frame %d\n",frame_number,times[timeline_index]);
  int X = atoi(name);
  printf("X is %d\n",X);
  clutter_actor_set_position (timeline_star_actor, X , Y_PLACE_OF_TIMELINE);
}

void gui_visualize_playing(void) {
  //printf("clutter_gui: Playing starts!\n");

  //timeline_star is initialized from start_theme(). If we want play_sequencer before that
  //(e.g. testing virtual instrument) we want skip star visualization.
  if (timeline_star_actor==NULL)
    return;

  guint64 length_of_song;
  chum_get_duration_of_song(&length_of_song);

  guint64 a0 = 60000;
  guint64 a1= 1000000;
  guint64 a2=a0*a1;
  gint64 length_of_beat = a2 * GST_NSECOND * chum_get_meter_of_track(0)/chum_get_tempo_of_track(0);

  g_print ("clutter: Duration: %" GST_TIME_FORMAT " .one beat: %" GST_TIME_FORMAT "\n",
  GST_TIME_ARGS (length_of_song), GST_TIME_ARGS (length_of_beat));


  ClutterTimeline *timeline = clutter_timeline_new_for_duration (length_of_song);
  clutter_timeline_set_loop(timeline, FALSE); 
  g_signal_connect (timeline, "marker-reached", G_CALLBACK (on_timeline_marker_reached),timeline_star_actor);
  g_signal_connect (timeline, "completed", G_CALLBACK (on_timeline_completed),timeline_star_actor);

  gint64 i;
  int place=-20;
  for (i=0;i<length_of_song;i+=length_of_beat) {
      gchar *place_ =g_strdup_printf("%d",place);

      guint time_ns = i / GST_NSECOND /1000000;
      //printf("time(ns):%d, place%d\n",time_ns,place);
      clutter_timeline_add_marker_at_time (timeline, place_, time_ns);
      place+=WIDTH_OF_SLOT;
  }



  clutter_actor_show (timeline_star_actor);
  clutter_actor_set_position (timeline_star_actor, 0 , Y_PLACE_OF_TIMELINE);


clutter_timeline_start(timeline);
}


ClutterActor* drop_area;
ClutterActor* get_drop_area()
{
	return(drop_area);
}


GList *current_behaviours_and_actors = NULL;
GList *get_current_behaviours_and_actors(){
return current_behaviours_and_actors;
}

/**
 * stage_start_behaviour() is used to initialize and start timeline
 * behaviours.
 * 
 * This is for objects and buttons in config.json
 *
 * @param		actor			actor for behaviour
 * @param		behaviour		behaviour which is used
 */
void stage_start_behaviour(ClutterActor* actor, ClutterBehaviour* behaviour)
{
	ClutterAlpha* alpha;
	ClutterTimeline* timeline;
	
	g_return_if_fail(CLUTTER_IS_ACTOR(actor));
	g_return_if_fail(CLUTTER_IS_BEHAVIOUR(behaviour));
	
	alpha = clutter_behaviour_get_alpha(behaviour);
	timeline = clutter_alpha_get_timeline(alpha);
	clutter_timeline_start(timeline);

	gchar *name;
	g_object_get(G_OBJECT(actor), "name", &name, NULL);
	if (name==NULL) //objects doesn't have names. buttons have
	  {
	  ActorBehaviour *ab = malloc(sizeof(ActorBehaviour));
	  ab->behaviour=behaviour;
	  ab->actor=actor;
	  current_behaviours_and_actors = g_list_append(current_behaviours_and_actors, ab); 
	  }
//clutter_behaviour_remove (behaviour,actor); //helpompi debugata!
}


/**
 * @param		stage_nr	number of stage
 * @return		actor		background actor of asked stage. NULL if asked too big
 */
ClutterActor* load_background(const char* theme_folder)
{
	ClutterActor* actor;
	gchar* filepath1;
	gchar* dir = THEMES_DIR;

	filepath1 = g_strdup_printf("%s/%s/background.png", dir, theme_folder);

	actor = clutter_texture_new_from_file (filepath1, NULL);
	return actor;
}


/**
 * Initialization function for drop_area.
 */
static void stage_init_drop_area(ClutterActor* stage)
{	
	drop_area = config_get_configured_actor(NULL,"drop-area");
	clutter_actor_set_name(drop_area, "drop_area");
	
	clutter_container_add_actor (CLUTTER_CONTAINER (stage), drop_area);
	clutter_actor_show (drop_area);
	
	clutter_actor_set_reactive(drop_area, TRUE);
}

/*
It is possible 'fool' the game like this way:
 drag object, move pointer outside of window, release button
 or
 move pointer fastly over object and click button - press is over object, but release is over stage

-> This function is solution. All time mouse is released and object is not capturing it, 
 this function is called. This invokes do_draggind_ends which is safe even false positive case.
*/
/*
void stage_mouse_release(ClutterActor *actor, ClutterEvent *event, gpointer data) {
  //printf("\n\n****mouse release on stage******\n\n\n");
  gint x_mouse_position, y_mouse_position;
  clutter_event_get_coords (event,&x_mouse_position, &y_mouse_position);
  do_dragging_ends(x_mouse_position, y_mouse_position);
}
*/
/**
 * stage_init_clutter_stage() function is used to initialize the
 * stage given as parameter. Function sets the corresponding
 * background for the stage in order. Function also initializes
 * all stage relevant actors and all buttons to objects_group
 * (ClutterGroup).
 * 
 */
void start_theme() {
ClutterActor* stage =main_getStage();

current_behaviours_and_actors = NULL;
	//First throw away all old actors
	GList* children= clutter_container_get_children (CLUTTER_CONTAINER (stage));

	GList *l;
	for (l = children; l; l = l->next){
	    gchar *name;
	    g_object_get(G_OBJECT(l->data), "name", &name, NULL);
	    printf("removed: %s\n",name);
	    clutter_container_remove_actor (CLUTTER_CONTAINER (main_getStage()), l->data);  
	  }

		ClutterActor* bgr = load_background(chum_get_theme_folder(chum_get_current_theme()));
		clutter_actor_set_name(bgr, "background");
		if (bgr==NULL)
		    printf("Background is NULL\n");
		clutter_container_add_actor (CLUTTER_CONTAINER (main_getStage()), bgr);
		clutter_actor_set_position (bgr, 0, 0);
		clutter_actor_show (bgr);
		clutter_actor_set_reactive(bgr, TRUE);
		clutter_actor_lower_bottom (bgr);


		stage_init_drop_area(stage);
		//g_signal_connect (stage, "motion-event", G_CALLBACK (mouse_motion_on_stage), NULL);
		//g_signal_connect (stage, "button-release-event", G_CALLBACK (stage_mouse_release), NULL);
		
		ClutterActor* objects_group;
		objects_group = clutter_group_new();
		object_create_stage_object_group (objects_group, chum_get_theme_folder(chum_get_current_theme()));

		//make own group for buttons. FIX
		button_create_buttons (objects_group);
		clutter_actor_set_name(objects_group, "group of objects and buttons");
		clutter_container_add_actor (CLUTTER_CONTAINER (stage), objects_group);
		clutter_actor_set_reactive(objects_group, TRUE);

		objects_in_this_stage=objects_group;
		timeline_star_actor = config_get_configured_actor(NULL,"timeline_star");
		clutter_actor_set_name(timeline_star_actor, "timeline_star_actor");

		clutter_container_add_actor(CLUTTER_CONTAINER(stage), timeline_star_actor);
		clutter_actor_set_reactive(timeline_star_actor, TRUE);
		clutter_actor_hide (timeline_star_actor);	
}



static void from_theme_selection_to_game_selection(){
chum_go_back();
}

void show_theme_selection() {
ClutterActor* stage =main_getStage();

//First we count how many themes we have in theme-folder
int number_of_stages=chum_get_number_of_themes();
//Then we take background image for each and make theme-selection
int i;
for (i=1;i<number_of_stages+1;i++){
    ClutterActor*  actor= load_background(chum_get_theme_folder(i));
    //if (actor==NULL)   printf("Background is NULL\n");

    //there are empty white area bottom of background:
    //first make image taller and then clip from bottom
    clutter_actor_set_height (actor,700);
    clutter_actor_set_clip (actor,800/number_of_stages,0,800/number_of_stages,480);
    clutter_actor_set_position (actor,800/number_of_stages*(i-2),0);		

    clutter_container_add_actor (CLUTTER_CONTAINER (stage), actor);
    clutter_actor_show (actor);
    clutter_actor_set_reactive(actor, TRUE);
    //clutter_actor_set_name(actor, "");
    g_signal_connect (actor, "button-press-event", G_CALLBACK (theme_selection_mouse_release),GINT_TO_POINTER(i));

    //make vertical bar between each theme
    ClutterActor* line=clutter_rectangle_new_with_color (get_transparency_color());
    clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(line),get_dark_color());
    clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(line),10);
    clutter_actor_set_size (line, 10, 480);
    clutter_actor_set_position (line, 800/number_of_stages*(i-1), 0);
    clutter_actor_show (line);
    clutter_container_add_actor (CLUTTER_CONTAINER (stage), line);
}

//border all over the theme-selection
ClutterActor* actor=clutter_rectangle_new_with_color (get_transparency_color());
  clutter_actor_set_size (actor, 800, 480);
  clutter_actor_set_position (actor, 0, 0);
  clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(actor),get_dark_color());
  clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(actor),10);
  clutter_actor_show (actor);  
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), actor);




ClutterActor *s1 = config_get_configured_actor(NULL,"house");
clutter_container_add_actor (CLUTTER_CONTAINER (stage), s1);
clutter_actor_set_position (s1, 720, 5); 
clutter_actor_set_size (s1, 66, 60);
clutter_actor_show (s1);
clutter_actor_set_name(s1, "house");
clutter_actor_set_reactive(s1, TRUE);
g_signal_connect (s1, "button-release-event", G_CALLBACK (from_theme_selection_to_game_selection),NULL);
}