#!/bin/sh

PREFIX=`pwd`/usr

touch NEWS README AUTHORS ChangeLog

aclocal
automake -ac
autoconf
./configure N900=yes --prefix=$PREFIX


mkdir $PREFIX/lib/jammo -p 2> /dev/null
echo "Building GST plugins"
cd src/meam/gst-jammo-plugins

./compile_plugin.sh sampler 
./compile_plugin.sh slider
./compile_plugin.sh pitchdetect
cp libs/libgstjammo*.so $PREFIX/lib/jammo

cd -

echo "Building gnonlin plugin"
cd src/3rd_party/ && ./build_gnonlin.sh && cp gnonlin/gnl/.libs/libgnl.so $PREFIX/lib/jammo && cd -

echo "Making start scripts"
echo "GST_PLUGIN_PATH=../lib/jammo/ ./jammo " > $PREFIX/bin/jammo.sh
chmod a+x $PREFIX/bin/jammo.sh


exit 0
