#include "communication.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <pthread.h>

#define SOCKET_ERROR        -1
#define HOST_NAME_SIZE      255
#define QUEUE_SIZE          5
#define BUFFER_SIZE         1000

int connected=0;
int hServerSocket; /*Listening socket*/
//int sockethandle; /* handle to socket */
Connection connection;
Connection connectionlist[5];//0=server, 1-4=group members
//FDSet stuff for select(serverthread)
fd_set master;    // master file descriptor list
fd_set read_fds;  // temp file descriptor list for select()
int fdmax;        // maximum file descriptor number



void * serverthread(void *);

int communication_create_connection(int id,char *address, int port)
{
	struct hostent* pHostInfo;   /* holds info about a machine */
	struct sockaddr_in Address;  /* Internet socket address stuct */
	char buffer[100];
    	long nHostAddress;
	char strHostName[HOST_NAME_SIZE];
	int rc;
    	pthread_t threadid;

	strcpy(strHostName,address);
     
	connection.userid=id;
	


    	printf("\nMaking a socket");
    	/* make a socket */
    	connection.sockethandle=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);

    	if(connection.sockethandle == SOCKET_ERROR)
    	{
        	printf("\nCould not make a socket\n");
        	return 0;
    	}


    	/* get IP address from name */
    	pHostInfo=gethostbyname(strHostName);
   	/* copy address into long */
    	memcpy(&nHostAddress,pHostInfo->h_addr,pHostInfo->h_length);

    	/* fill address struct */
    	Address.sin_addr.s_addr=nHostAddress;
    	Address.sin_port=htons(port);
    	Address.sin_family=AF_INET;

    	printf("\nConnecting to %s on port %d",strHostName,port);

    	/* connect to host */
    	if(connect(connection.sockethandle,(struct sockaddr*)&Address,sizeof(Address))== SOCKET_ERROR)
    	{
        	printf("\nCould not connect to host\n");
        	return 0;
    	}

 	FD_SET(connection.sockethandle, &master);
	fdmax = connection.sockethandle;
	rc = pthread_create(&threadid, NULL, serverthread, NULL);
	connected=1;
	return 1;
}
int communication_send_data(int id, char *message, int size)
{
	
	printf("Sending %d bytes.",size);
	if(connected)
	{
		write(connection.sockethandle,message,size);
	}
	else
	{
		printf("No connection available");
	}

}

int communication_start_server(int id, int port)
{
    struct hostent* pHostInfo;   /* holds info about a machine */
    struct sockaddr_in Address; /* Internet socket address stuct */
    int nAddressSize=sizeof(struct sockaddr_in);
    int rc;
    pthread_t threadid;

    printf("\nStarting server");

    FD_ZERO(&master);    // clear the master and temp sets
    FD_ZERO(&read_fds);

    printf("\nMaking socket");
    /* make a socket */
    hServerSocket=socket(AF_INET,SOCK_STREAM,0);

    if(hServerSocket == SOCKET_ERROR)
    {
        printf("\nCould not make a socket\n");
        return 0;
    }

    /* fill address struct */
    Address.sin_addr.s_addr=INADDR_ANY;
    Address.sin_port=htons(port);
    Address.sin_family=AF_INET;

    printf("\nBinding to port %d\n",port);

    /* bind to a port */
    if(bind(hServerSocket,(struct sockaddr*)&Address,sizeof(Address)) 
                        == SOCKET_ERROR)
    {
        printf("\nCould not bind\n");
        return 0;
    }
 /*  get port number */
    getsockname( hServerSocket, (struct sockaddr *) &Address,(socklen_t *)&nAddressSize);
    printf("opened socket as fd (%d) on port (%d) for stream i/o\n",hServerSocket, ntohs(Address.sin_port) );

        printf("Server\n\
              sin_family        = %d\n\
              sin_addr.s_addr   = %d\n\
              sin_port          = %d\n"
              , Address.sin_family
              , Address.sin_addr.s_addr
              , ntohs(Address.sin_port)
            );
     printf("\nMaking a listen queue of %d elements",QUEUE_SIZE);
    /* establish listen queue */
    if(listen(hServerSocket,QUEUE_SIZE) == SOCKET_ERROR)
    {
        printf("\nCould not listen\n");
        return 0;
    }

     printf("\nWaiting for a connection\n");
      /* get the connected socket */
     connection.sockethandle=accept(hServerSocket,(struct sockaddr*)&Address,(socklen_t *)&nAddressSize);

     printf("\nGot a connection");   
     printf("Server\n\
              sin_family        = %d\n\
              sin_addr.s_addr   = %d\n\
              sin_port          = %d\n"
              , Address.sin_family
              , Address.sin_addr.s_addr
              , ntohs(Address.sin_port)
            );  
     connection.userid=id;

     FD_SET(connection.sockethandle, &master);     
     fdmax = connection.sockethandle;
     rc = pthread_create(&threadid, NULL, serverthread, NULL);
     connected=1;
     collaboration_user_info_request();
     return 1;
   
}

void * serverthread(void * arg)//Communication thread, listens to open sockets for incoming messages
{
	int size;
	int id=0;
	char buffer[BUFFER_SIZE];
	FILE *logfile;

	for(;;)
    	{	
		read_fds = master; // copy it
        	/*if (select(fdmax+1, &read_fds, NULL, NULL, NULL) == -1) {
            		perror("select");
            		exit(4);
        	}*/

		/* read from socket into buffer */
		size=read(connection.sockethandle,buffer,BUFFER_SIZE);
		//size=recv(connection.sockethandle, buffer, BUFFER_SIZE, 0);
		//logfile=fopen("log", "w");
		//fprintf(logfile,"Received message\n");
		printf("\nReceived %d bytes.",size);
		if(size<=0)//connection breaks
		{
			printf("\nLost connection.");
			communication_close_connection();
		}
		//fclose(logfile);
		collaboration_handle_message(buffer,size,id);
	}
}

int communication_close_connection()
{
	printf("\nClosing socket\n");
    	/* close socket */                       
    	if(close(connection.sockethandle) == SOCKET_ERROR)
    	{
        	printf("\nCould not close socket\n");
		exit(-1);//For testing
    	}
	connected=0;
	return 1;
}


