/*
 * test-stample-button.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

/**********
 * Known bugs: Timeline is not adjusted to anything (including sample durations).
 */

#include <meam/jammo-meam.h>
#include <chum/jammo-chum.h>
#include <chum/jammo-sample-button.h>
#include <chum/jammo-track-view.h>
#include <tangle.h>



static gboolean create_new_sample(TangleButton* button, gpointer track_view) {
	ClutterActor* sample_button;
	sample_button = jammo_sample_button_new_from_files("test_image_100x74.jpg", "/opt/jammo/themes/animal/110/animalw_110_vibraslap_2.wav");
	jammo_track_view_add_jammo_sample_button(JAMMO_TRACK_VIEW(track_view), JAMMO_SAMPLE_BUTTON(sample_button), 1);
	
	return FALSE;
}

static gboolean on_play_button_clicked(TangleButton* button, gpointer user_data) {
	jammo_sequencer_play(JAMMO_SEQUENCER(user_data));


	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* box;
	ClutterActor* sample_button;
	JammoSequencer* sequencer;
	
	JammoEditingTrack* track;
	ClutterActor* track_view;
	ClutterActor* play_button;
	ClutterActor* button_for_creating;
	
	jammo_meam_init(&argc, &argv);
	jammo_chum_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	//clutter_stage_set_fullscreen(CLUTTER_STAGE(stage), TRUE);
	clutter_actor_set_size(stage, 800.0, 480.0);
	box = tangle_widget_new();
	clutter_container_add(CLUTTER_CONTAINER(stage), box, NULL);

	sample_button = jammo_sample_button_new_from_files("test_image_100x74.jpg", "/opt/jammo/themes/animal/110/animalw_110_pluck_2.wav");
	clutter_actor_set_position(sample_button, 100.0, 100.0);
	clutter_container_add(CLUTTER_CONTAINER(box), sample_button, NULL);
	
	sequencer = jammo_sequencer_new();
	track = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));
	
	track_view = jammo_track_view_new(track, 6, 1000000000L, 100.0);
	g_object_set(track_view, "line-every-nth-slot", 2, 
	             "disabled-slots-begin", 1,
		     "disabled-slots-end", 1, NULL);
	clutter_actor_set_position(track_view, 0.0, 200.0);
	clutter_container_add(CLUTTER_CONTAINER(box), track_view, NULL);
	
	play_button = tangle_button_new();
	clutter_actor_set_position(play_button, 700.0, 400.0);
	tangle_widget_add_after(TANGLE_WIDGET(play_button), clutter_texture_new_from_file("test_image_100x74.jpg", NULL), NULL, NULL, NULL);
	g_signal_connect(play_button, "clicked", G_CALLBACK(on_play_button_clicked), sequencer);
	clutter_container_add(CLUTTER_CONTAINER(box), play_button, NULL);
	
	button_for_creating = tangle_button_new();
	clutter_actor_set_position(button_for_creating, 200.0, 400.0);
	tangle_widget_add_after(TANGLE_WIDGET(button_for_creating), clutter_texture_new_from_file("test_image_100x74.jpg", NULL), NULL, NULL, NULL);
	g_signal_connect(button_for_creating, "clicked", G_CALLBACK(create_new_sample), track_view);
	clutter_container_add(CLUTTER_CONTAINER(box), button_for_creating, NULL);
	
		
		
	clutter_actor_show_all(stage);
	clutter_main();
	
	return 0;
}
