/*
 * cupboard.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>
#include <fcntl.h> //we check some files


#include "themeselection.h"
#include "file_helper.h"
#include "string.h"

#include "gui.h" //for chum_states
#include "chum.h" //for chum_states
#include "jammo-mentor.h"
#include "../meam/jammo-playing-track.h"


static gboolean cupboard_icon_clicked(TangleButton *tanglebutton, gpointer data){
	printf("Load icon pressed\n");
	ClutterActor* actor = jammo_get_actor_by_id("cupboard-view");
	clutter_actor_hide(actor);

	themeselection_start_theme("fantasy");
	
	//We must give time to start_theme (for some unknown reason)
	g_timeout_add(100,themeselection_load,(char*)data);
	//themeselection_load();
	return FALSE;
}

static JammoSequencer* sequencer;
static void play_sequencer(TangleActor *actor, gpointer user_data) {
//jammo_sequencer_play(JAMMO_SEQUENCER(user_data));
jammo_sequencer_play(sequencer);
}



/*

*/
static gboolean cupboard_song_icon_clicked(TangleButton *tanglebutton, gpointer data){
	gchar* name=(char*)data;
	printf("Load song_icon pressed: '%s'\n",name);

	// If we have not visited in songselection, we can't use cross-button.
	//Additionally next time we go to songselection, mentor doesn't say 'welcome' (good)
	ClutterActor* songselection = jammo_get_actor_by_id("songselection-view");
	clutter_actor_show(songselection);
	clutter_actor_hide(songselection);


	//Hide mentor
	jammo_mentor_shut_up(jammo_mentor_get_default());
	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));


	//add tracks to sequencer
	if (sequencer) {
		jammo_sequencer_stop(sequencer);
		g_object_unref(sequencer);
	}
	sequencer = jammo_sequencer_new();


	//TODO: maybe we not should use currently selected_language, but save it too.
	gchar *filename;
	int fd;
	filename = g_strdup_printf("%s/songs/%s/comping%s.ogg", DATA_DIR,name,chum_get_selected_language());
	fd = open(filename,O_RDONLY);
	if (fd == -1) //File not found
		{  //no track for this language,. use  common comping.
		filename = g_strdup_printf("%s/songs/%s/comping.ogg", DATA_DIR,name); //try without language postfix
		}
	printf("looking for file '%s' for comping_track\n",filename);

	JammoPlayingTrack* playing_track;  
	playing_track = jammo_playing_track_new(filename);   //for comping track
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(playing_track));
	g_free(filename);



	gchar *loaded_filename;
	loaded_filename = g_strdup_printf("%s/%s.wav",SINGINGS_DIRECTORY,(char*)data);
	printf("looking for file '%s' for loaded_track\n",loaded_filename);	

	JammoPlayingTrack* playing_track2;
	playing_track2 = jammo_playing_track_new(loaded_filename);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(playing_track2));  
	g_free(loaded_filename);



	chum_set_state_of_chum(SCREEN_FROM_CUPBOARD);


	//Hide cupboard
	ClutterActor* old_view;
	old_view = jammo_get_actor_by_id("cupboard-view");
	tangle_actor_hide_animated(TANGLE_ACTOR(old_view));

	//Show saved song-view
	gchar *new_name = g_strdup_printf("song-%s-view",name);
	ClutterActor* new_view;
	new_view = jammo_get_actor_by_id(new_name);	
	clutter_actor_show(new_view);

	//And start sequencer after animation is completed
	g_signal_connect(new_view, "show-completed", G_CALLBACK(play_sequencer), sequencer );
	
	return FALSE;
}

//Scrolling area for icons
static ClutterActor* scrolling_actor = NULL;

/*
This will also check and load icons for savings.
*/
void cupboard_start_cupboard(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	//Stop if there are sequencer playing
	if (sequencer) {
		jammo_sequencer_stop(sequencer);
		g_object_unref(sequencer);
	}
	
	if (scrolling_actor){
	clutter_actor_destroy(CLUTTER_ACTOR(scrolling_actor));
	}
	
	ClutterActor* container_for_saved_icons;
	container_for_saved_icons = tangle_widget_new();
	clutter_actor_set_size(container_for_saved_icons, 210.0, 1800.0);

	//Load compositions TODO. This is just test-version with one icon.
	gchar *filepath1;
	filepath1 = COMPOSITIONS_DIRECTORY;
	
	GList* files = file_helper_get_all_files(filepath1);

	int counter1=0;
	GList* l;
	for (l = files; l; l = l->next)
		{
		printf("readed '%s'\n",(char*)l->data);
		ClutterActor* icon;
		//if (strncmp(name,"fant",4)==0) TODO //Use correct icon
		icon = tangle_button_new_with_background_actors(clutter_texture_new_from_file("/opt/jammo/themes/fantasy/110/ghost.png", NULL), clutter_texture_new_from_file("/opt/jammo/themes/fantasy/110/ghost.png", NULL));

		g_object_set(icon,"depth-position", -1, "width", 60.0, "height", 60.0, "x", 50.0,  "y", 20+counter1*95.0, NULL);
		
		clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), icon, NULL);
		clutter_actor_set_reactive(icon,TRUE);
		g_signal_connect (icon, "clicked", G_CALLBACK (cupboard_icon_clicked),l->data);
		counter1++;
		}

	
	//And singings
	filepath1 = SINGINGS_DIRECTORY;

	files = file_helper_get_all_files(filepath1);

	int counter2=0;
	for (l = files; l; l = l->next)
		{
		printf("readed '%s'\n",(char*)l->data);
		ClutterActor* icon;
		//int length_of_prefix= strlen(filepath1);

		char* name = (char*)l->data;
		printf("name = '%s'\n",name);
		char* name1 = &name[strlen(filepath1)+1];
		printf("name1 = '%s'\n",name1);
	
		char* name2 = malloc (20);
		strncpy( name2, name1,strlen(name1)-4);
		name2[strlen(name1)-4]='\0';
		printf("name2 = '%s'\n",name2);

		gchar* icon_filename=g_strdup_printf("%s/songs/%s/icon.png",DATA_DIR,name2);
		printf("looking for '%s'\n",icon_filename);
		
		icon = tangle_button_new_with_background_actors(clutter_texture_new_from_file(icon_filename, NULL), clutter_texture_new_from_file(icon_filename, NULL));
		g_free(icon_filename);

		g_object_set(icon,"depth-position", -1, "width", 60.0, "height", 60.0, "x", 190.0,  "y", 20+counter2*94.0, NULL);

		clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), icon, NULL);
		
		clutter_actor_set_reactive(icon,TRUE);
		char* name_for_callback = malloc (20);
		strcpy(name_for_callback,name2);
		g_signal_connect (icon, "clicked", G_CALLBACK (cupboard_song_icon_clicked),name_for_callback);
		g_free(name2);
		counter2++;
		}

		int counter = counter1>counter2?counter1:counter2; //max(counter1,counter2);
		//make movable shelves
		int i;
		for (i=0;i<counter;i++)
			{
			ClutterActor* b_icon = tangle_button_new_with_background_actors(clutter_texture_new_from_file("/opt/jammo/cupboard_shelf.png", NULL), clutter_texture_new_from_file("/opt/jammo/cupboard_shelf.png", NULL));
			g_object_set(b_icon,"depth-position", -2, "width", 290.0, "height", 94.0, "x", 0.0,  "y", -1+i*94.0, NULL);
			clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), b_icon, NULL);
			}


		//Tune size of container
		clutter_actor_set_size(container_for_saved_icons, 310.0, counter*94.0);


	//Scrolling area for icons
	scrolling_actor = tangle_scrolling_actor_new(container_for_saved_icons);
	clutter_actor_set_position(scrolling_actor,  210.0, 65.0);
	
	clutter_actor_set_size(scrolling_actor, 310.0, counter*94.0<376.0?counter*94.0:376.0);
	g_object_set(scrolling_actor,"depth-position", -1,NULL);
	clutter_container_add_actor(CLUTTER_CONTAINER(jammo_get_actor_by_id("cupboard-view")), scrolling_actor);
}

void cupboard_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* actor;
	ClutterActor* actor2;
	ClutterAnimation* animation;
	ClutterAnimation* animation2;
	gchar* filename;
	JammoSample* sample;
	
	actor = jammo_get_actor_by_id("cupboard-leftdoor");
	g_assert(actor != NULL);

	actor2 = jammo_get_actor_by_id("cupboard-rightdoor");
	g_assert(actor2 != NULL);

	if ((animation = clutter_actor_get_animation(actor))) {
		clutter_animation_completed(animation);
	} else {
		animation = clutter_actor_animate(actor, CLUTTER_LINEAR, 2750, "rotation-angle-y", -150.0, "x", 217.0, NULL);
		//g_signal_connect(animation, "completed", G_CALLBACK(finalize_welcome), NULL);
		
		filename = g_strdup_printf("%s/door_opening.wav",DATA_DIR);
		sample = jammo_sample_new_from_file(filename);
		g_free(filename);
		jammo_sample_play(sample);
		g_object_unref(sample);
	}
	
if ((animation2 = clutter_actor_get_animation(actor2))) {
		clutter_animation_completed(animation2);
	} else {
		animation2 = clutter_actor_animate(actor2, CLUTTER_LINEAR, 2750, "rotation-angle-y", 150.0, "x", 490.0, NULL);
	}

}
