/*
 * cupboard.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>
#include <fcntl.h> //we check some files


#include "themeselection.h"
#include "file_helper.h"
#include "string.h"

void cupboard_icon_clicked(ClutterTexture *actor2, ClutterEvent *event, gpointer data){
	printf("Load icon pressed\n");
	ClutterActor* actor = jammo_get_actor_by_id("cupboard-view");
	clutter_actor_hide(actor);

	themeselection_start_theme("fantasy");
	
	//We must give time to start_theme (for some unknown reason)
	g_timeout_add(100,themeselection_load,(char*)data);
	//themeselection_load();
}

/*
This is just simple jammo_sample_play for saved wav. TODO
*/
void cupboard_song_icon_clicked(ClutterTexture *actor2, ClutterEvent *event, gpointer data){
	printf("Load song_icon pressed: '%s'\n",(char*)data);

	gchar *filename;
		#ifdef N900
	filename = g_strdup_printf("/home/user/MyDocs/jammo/singings/%s.wav",(char*)data);
	#else
	filename = g_strdup_printf("/tmp/jammo/singings/%s.wav",(char*)data);
	#endif

	JammoSample*	sample = jammo_sample_new_from_file(filename);
	g_free(filename);
	jammo_sample_play(sample);
	g_object_unref(sample);

}

/*
This will also check and load icons for savings.
*/
void cupboard_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* actor;
	ClutterActor* actor2;
	ClutterAnimation* animation;
	ClutterAnimation* animation2;
	gchar* filename;
	JammoSample* sample;

	ClutterActor* container_for_saved_icons = tangle_widget_new(); //TANGLEWIDGET
	clutter_actor_set_size(container_for_saved_icons, 210.0, 1800.0);

	//Load compositions TODO. This is just test-version with one icon.
	gchar *filepath1;
	#ifdef N900
	filepath1 = g_strdup_printf("/home/user/MyDocs/jammo/compositions");;
	#else
	filepath1 = g_strdup_printf("/tmp/jammo/compositions");
	#endif

	GList* files = file_helper_get_all_files(filepath1);

	GList* l;
	for (l = files; l; l = l->next)
		{
		printf("readed '%s'\n",(char*)l->data);
		ClutterActor* icon;
		//if (strncmp(name,"fant",4)==0) TODO //Use correct icon
		icon=clutter_texture_new_from_file("/opt/jammo/themes/fantasy/110/ghost.png", NULL);

		g_object_set(icon, "x", 0.0,  "y", 0.0, NULL);  //TODO:use counter for coordinates
		clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), icon, NULL);
		clutter_actor_set_reactive(icon,TRUE);
		g_signal_connect (icon, "button-release-event", G_CALLBACK (cupboard_icon_clicked),l->data);
		}

	
	//And singings
	#ifdef N900
	filepath1 = g_strdup_printf("/home/user/MyDocs/jammo/singings");
	#else
	filepath1 = g_strdup_printf("/tmp/jammo/singings");
	#endif

	files = file_helper_get_all_files(filepath1);

	int counter=0;
	for (l = files; l; l = l->next)
		{
		printf("readed '%s'\n",(char*)l->data);
		ClutterActor* icon;
		int length_of_prefix= strlen(filepath1);

		char* name = (char*)l->data;
		printf("name = '%s'\n",name);
		char* name1 = &name[strlen(filepath1)+1];
		printf("name1 = '%s'\n",name1);
	
		char* name2 = malloc (20);
		strncpy( name2, name1,strlen(name1)-4);
		name2[strlen(name1)-4]='\0';
		printf("name2 = '%s'\n",name2);

		gchar* icon_filename=g_strdup_printf("%s/songs/%s/icon.png",DATA_DIR,name2);
		printf("looking for '%s'\n",icon_filename);
		icon=clutter_texture_new_from_file(icon_filename, NULL);
		g_free(icon_filename);

		g_object_set(icon,"width", 60.0, "height", 60.0, "x", 150.0,  "y", 10+counter*95.0, NULL);
		clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), icon, NULL);
		clutter_actor_set_reactive(icon,TRUE);
		char* name_for_callback = malloc (20);
		strcpy(name_for_callback,name2);
		g_signal_connect (icon, "button-release-event", G_CALLBACK (cupboard_song_icon_clicked),name_for_callback);
		g_free(name2);
		counter++;
		}


	//Scrolling area for icons
	ClutterActor* scrolling_actor;
	scrolling_actor = tangle_scrolling_actor_new(container_for_saved_icons);
	clutter_actor_set_position(scrolling_actor,  260.0, 72.0);
	clutter_actor_set_size(scrolling_actor, 210.0, 370.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(jammo_get_actor_by_id("cupboard-view")), scrolling_actor);



	actor = jammo_get_actor_by_id("cupboard-leftdoor");
	g_assert(actor != NULL);

	actor2 = jammo_get_actor_by_id("cupboard-rightdoor");
	g_assert(actor2 != NULL);

	if ((animation = clutter_actor_get_animation(actor))) {
		clutter_animation_completed(animation);
	} else {
		animation = clutter_actor_animate(actor, CLUTTER_LINEAR, 2750, "rotation-angle-y", -150.0, "x", 217.0, NULL);
		//g_signal_connect(animation, "completed", G_CALLBACK(finalize_welcome), NULL);
		
		filename = g_strdup_printf("%s/door_opening.wav",DATA_DIR);
		sample = jammo_sample_new_from_file(filename);
		g_free(filename);
		jammo_sample_play(sample);
		g_object_unref(sample);
	}
	
if ((animation2 = clutter_actor_get_animation(actor2))) {
		clutter_animation_completed(animation2);
	} else {
		animation2 = clutter_actor_animate(actor2, CLUTTER_LINEAR, 2750, "rotation-angle-y", 150.0, "x", 490.0, NULL);
	}

}
