/*
 * cupboard.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>
#include <fcntl.h> //we check some files


#include "themeselection.h"
void cupboard_icon_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("Load icon pressed\n");
	ClutterActor* actor = jammo_get_actor_by_id("cupboard-view");
	clutter_actor_hide(actor);

	themeselection_start_theme("fantasy");
	
	//We must give time to start_theme (for some unknown reason)
	g_timeout_add(100,themeselection_load,NULL);
	//themeselection_load();
}

void cupboard_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* actor;
	ClutterActor* actor2;
	ClutterAnimation* animation;
	ClutterAnimation* animation2;
	gchar* filename;
	JammoSample* sample;


	//Check and load icons for savings. TODO. This is just test-version with one icon.
	gchar *filepath1;
	#ifdef N900
	filepath1 = g_strdup_printf("/home/user/MyDocs/jammo_comp.wav");
	#else
	filepath1 = g_strdup_printf("/tmp/jammo/jammo_comp");
	#endif

	int fd = open(filepath1,O_RDONLY);
	if (fd == -1) { //If there are no saved composing, do not show icon.
		actor = jammo_get_actor_by_id("cupboard-icon");
		clutter_actor_hide(actor);
	}



	actor = jammo_get_actor_by_id("cupboard-leftdoor");
	g_assert(actor != NULL);

	actor2 = jammo_get_actor_by_id("cupboard-rightdoor");
	g_assert(actor2 != NULL);

	if ((animation = clutter_actor_get_animation(actor))) {
		clutter_animation_completed(animation);
	} else {
		animation = clutter_actor_animate(actor, CLUTTER_LINEAR, 2750, "rotation-angle-y", -150.0, "x", 217.0, NULL);
		//g_signal_connect(animation, "completed", G_CALLBACK(finalize_welcome), NULL);
		
		filename = g_strdup_printf("%s/door_opening.wav",DATA_DIR);
		sample = jammo_sample_new_from_file(filename);
		g_free(filename);
		jammo_sample_play(sample);
		g_object_unref(sample);
	}
	
if ((animation2 = clutter_actor_get_animation(actor2))) {
		clutter_animation_completed(animation2);
	} else {
		animation2 = clutter_actor_animate(actor2, CLUTTER_LINEAR, 2750, "rotation-angle-y", 150.0, "x", 490.0, NULL);
	}

}
