/** chum.c is part of JamMo.
License: GPLv2, read more from COPYING

(from D2.4)
"CHUM controls the user interface and will communicate with all other modules. 
It will use MEAM to create music. It will use GEMS to identify and authorize
the user and to send data to other users and teacher's server. It also sends
all the user actions to CEM fo logging/mentor input/game input."
*/

#include <fcntl.h> //we check some files
#include <string.h> //we use strcmp
#include <pthread.h> // we use threads when debugging
#include <unistd.h>

#include "gui.h"
#include "chum.h"
#include "file_helper.h"

#include "../cem/cem.h"
#include "../meam/jammo-meam.h"
#include "../meam/jammo-sample.h"
#include "../meam/jammo-editing-track.h"
#include "../meam/jammo-recording-track.h"
#include "../meam/jammo-instrument-track.h"
#include "../meam/jammo-slider-track.h"

#include "../gems/gems.h"

#include "../gui_clutter/instrument_testing.h"
static int chum_count_themes();


/*Chum is like state-machine*/
int state_of_chum=SCREEN_WELCOME;
int current_theme; /*for composing game*/
char* current_song;  /*for karaoke game*/

//This is not same than language from profile (which affects speech of mentor)
//This is only when user wants sing a song in different language.
char* selected_language="_fi";

char* chum_get_selected_language(){
	return selected_language;
}

void  chum_set_selected_language(const gchar* language){
	selected_language=language;
}


gboolean duetto=TRUE;
void chum_set_duetto(gboolean b){
	duetto=b;
}


//FALSE means advanced_game
static gboolean chum_easy_game = TRUE;
gboolean chum_is_easy_game(){
  return chum_easy_game;
}

void chum_set_easy_game(gboolean b){
	chum_easy_game=b;
}
//This helps logging/debugging state switching
char *name_of_states[] ={ "SCREEN_WELCOME",
                          "SCREEN_PASSWORD_TYPING",
                          "SCREEN_GAME_SELECTION",
                          "SCREEN_THEME_SELECTION",
                          "SCREEN_COMPOSING",
                          "SCREEN_SONG_SELECTION",
                          "SCREEN_SONG_RECORDING",
                          "SCREEN_PLAY_RECORDED",
                          "SCREEN_PLAY_RECORDED",
                          "SCREEN_MIDI_EDITOR" };

static JammoSequencer* sequencer = NULL;
JammoEditingTrack* editing_track;
JammoEditingTrack* editing_track_partner; //pairgame for youngest group
JammoEditingTrack* backing_track;

JammoInstrumentTrack* instrument_track;
JammoSliderTrack* slider_track;
JammoRecordingTrack* recording_track;

gboolean multiplaying=FALSE; 
gint number_of_themes = 0;
gint chum_get_number_of_themes(){
return number_of_themes;
}

int chum_get_state_of_chum(){
return state_of_chum;
}

#ifdef removed
//THIS IS THE MAIN LOOP OF JAMMO!!!
void chum_start_jammo_main_loop() {
    cem_add_to_log("starting main loop",LOG_DEBUG);
    gui_start_main_loop();
    cem_add_to_log("main loop is over",LOG_DEBUG);
}
#endif

#ifdef removed
void chum_start_chum(int argc, char** argv){
    int i;
    int port;
    char strHostName[100];
    #ifdef N900
    gchar *cmd = g_strdup_printf("mkdir -p /home/user/.jammo");
    int error_code = system(cmd);
    if (error_code)
        printf("Error, can't call '%s'\n",cmd);
    #endif

    cem_add_to_log("chum_start_chum()",LOG_DEBUG);
    for (i=1;i<argc;i++) 
      {
      cem_add_to_log(g_strdup_printf("chum_start_chum(%s)",argv[i]),LOG_DEBUG);
      }
   //We can't catch --help if jammo_meam_init(&argc, &argv) are called.
   if (argc==2 && strcmp(argv[1],"--help")==0) {
        printf("\nJamMo usage:\n\n");
        printf("flags:\n");
        printf("sing  \t- start sing selection (mentor/home will be visible after one song)\n");
        printf("theme  \t- start composing game (mentor/home will be visible after one song)\n");
        printf("editor  \t- start midi-editor\n");
        printf("password \t- test password typing\n\n");
        printf("instrument n\t- test instrument n\n\n");
        printf("slider n\t- test slider n\n\n");
        exit(0);
        }

    //init for sequencer
    jammo_meam_init(&argc, &argv);
    number_of_themes=chum_count_themes();

    if (argc==2 && strcmp(argv[1],"password")==0) { 
        state_of_chum=SCREEN_PASSWORD_TYPING;
        }
    else if (argc==3 && strcmp(argv[1],"--server")==0) { //Test communication in server mode
		printf("\nCreating server");
        	port=atoi(argv[2]);
		gems_create_game_server(port);
		multiplaying=TRUE;
        }
     else if (argc==4 && strcmp(argv[1],"--client")==0) { //Test communication in client mode
		printf("\nCreating client");		
		strcpy(strHostName,argv[2]);
		port=atoi(argv[3]);
        	gems_create_game_client(strHostName, port);
		multiplaying=TRUE;
        }

    gui_init();
    if (argc==2 && strcmp(argv[1],"sing")==0) { 
        state_of_chum=SCREEN_SONG_SELECTION;
        }

    else if (argc==2 && strcmp(argv[1],"editor")==0) { 
        state_of_chum=SCREEN_MIDI_EDITOR;
        }

    else if (argc==2 && strcmp(argv[1],"theme")==0) { 
        state_of_chum=SCREEN_THEME_SELECTION;
        }

    else if (argc==2 && strcmp(argv[1],"sequencer")==0) {
        state_of_chum=SCREEN_SEQUENCER;
        }

    else if (argc==3 && strcmp(argv[1],"instrument")==0) { 
        start_test_instrument(atoi(argv[2]));
        chum_start_jammo_main_loop();
        return;
        }

   else if (argc==3 && strcmp(argv[1],"slider")==0) { 
        start_test_slider(atoi(argv[2]));
        chum_start_jammo_main_loop();
        return;
        }


    gui_go_screen(state_of_chum);
    chum_start_jammo_main_loop();
}
#endif

void chum_test_instrument(int type) {
	cem_add_to_log(g_strdup_printf("chum_test_instrument(%d)",type),LOG_DEBUG);
	sequencer = jammo_sequencer_new();
	instrument_track = jammo_instrument_track_new(type);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(instrument_track));
	
  //Instrument track doesn't work if there aren't another track with one sample.
	editing_track = jammo_editing_track_new();
	JammoSample* sample;
	gchar* filepath1 = g_strdup_printf("%s/themes/forest/loop1.wav",DATA_DIR);
	sample = jammo_sample_new_from_file(filepath1);
	jammo_editing_track_add_sample(editing_track, sample, 0);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(editing_track));

}
void chum_test_slider(int type) {
	cem_add_to_log(g_strdup_printf("chum_test_slider(%d)",type),LOG_DEBUG);
	sequencer = jammo_sequencer_new();
	slider_track = jammo_slider_track_new(type);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(slider_track));
	
  //Slider track doesn't work if there aren't another track with one sample.
	editing_track = jammo_editing_track_new();
	JammoSample* sample;
	gchar* filepath1 = g_strdup_printf("%s/themes/forest/loop1.wav",DATA_DIR);
	sample = jammo_sample_new_from_file(filepath1);
	jammo_editing_track_add_sample(editing_track, sample, 0);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(editing_track));

}

#ifdef removed
void chum_go_back() {
    cem_add_to_log(g_strdup_printf("chum_go_back(). state_of_chum was %s...",name_of_states[state_of_chum]),LOG_DEBUG);

    switch (chum_get_state_of_chum()) {
      //singing
      case SCREEN_SONG_SELECTION:
	  state_of_chum=SCREEN_GAME_SELECTION;
	  break;
      case SCREEN_SONG_RECORDING:
	  state_of_chum=SCREEN_SONG_SELECTION;
	  break;
      case SCREEN_PLAY_RECORDED:
	  state_of_chum=SCREEN_SONG_RECORDING;
	  break;

      //composing
      case SCREEN_COMPOSING:
	  state_of_chum=SCREEN_THEME_SELECTION;
	  break;
      case SCREEN_THEME_SELECTION:
	  state_of_chum=SCREEN_GAME_SELECTION;
	  break;
      }


    cem_add_to_log(g_strdup_printf("...chum_go_back(). new state_of_chum is %s",name_of_states[state_of_chum]),LOG_DEBUG);

    gui_go_screen(state_of_chum);
}
#endif

#ifdef removed
void chum_go_next() {
    cem_add_to_log(g_strdup_printf("chum_go_next(). state_of_chum was %s...",name_of_states[state_of_chum]),LOG_DEBUG);

    //singing game is handled with switch-case. Composing game doens't have such a thing like next.
    switch (chum_get_state_of_chum()) {
      case SCREEN_SONG_RECORDING:
	  state_of_chum=SCREEN_PLAY_RECORDED;
	  chum_play_recorded_and_backing_track();
	  break;

      case SCREEN_PLAY_RECORDED:
	  state_of_chum=SCREEN_SONG_SELECTION;
	  break;
		case SCREEN_WELCOME:
	  state_of_chum=SCREEN_GAME_SELECTION;
	  break;
		case SCREEN_PASSWORD_TYPING:
	  state_of_chum=SCREEN_WELCOME;
	  break;

      default:
	state_of_chum++;
	break;
    }

    cem_add_to_log(g_strdup_printf("...chum_go_next(). new state_of_chum is %s",name_of_states[state_of_chum]),LOG_DEBUG);

    gui_go_screen(state_of_chum);
}
#endif

#ifdef removed
void chum_go_screen(int screen_number){
    cem_add_to_log(g_strdup_printf("chum_go_screen(%s)",name_of_states[screen_number]),LOG_DEBUG);
    state_of_chum=screen_number;
    gui_go_screen(state_of_chum);
}
#endif

//STUB
void chum_change_to_game(int game_number){
    cem_add_to_log(g_strdup_printf("chum_change_to_game(%d)",game_number),LOG_DEBUG);
    state_of_chum=SCREEN_THEME_SELECTION;
}

int chum_get_current_theme(){
    cem_add_to_log(g_strdup_printf("get_current_theme(). will return %d",current_theme),LOG_DEBUG);
    return current_theme;
}

JammoEditingTrack* chum_create_new_empty_track() {
	JammoEditingTrack* track;

	cem_add_to_log(g_strdup_printf("chum_create_new_empty_track()"),LOG_DEBUG);
	track = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));

	return track;
}

void chum_make_sequencer(){
sequencer = jammo_sequencer_new();
}

void chum_change_theme(int theme_number){
	JammoSample* sample;
	
    cem_add_to_log(g_strdup_printf("chum_change_theme(%d)",theme_number),LOG_DEBUG);
    current_theme=theme_number;

	if (sequencer) {
		g_object_unref(sequencer);
	}
	sequencer = jammo_sequencer_new();
	editing_track = chum_create_new_empty_track(); //for samples
	if (multiplaying)
		editing_track_partner = chum_create_new_empty_track(); //for partners samples

    //Add backing track if there are.
    gchar* filepath1 = g_strdup_printf("%s/%s/backing_track.wav", THEMES_DIR, chum_get_theme_folder(chum_get_current_theme()));
    int fd = open(filepath1,O_RDONLY);
    if (fd != -1) {
	backing_track = chum_create_new_empty_track(); //for backing track
	sample = jammo_sample_new_from_file(filepath1);
	jammo_editing_track_add_sample(backing_track, sample, 0);
	close(fd);
    }

    state_of_chum=SCREEN_COMPOSING;
    //gui_go_screen(state_of_chum);
}

#ifdef removed
void chum_change_to_theme(int theme_number){
chum_change_theme(theme_number);
    state_of_chum=SCREEN_COMPOSING;
    gui_go_screen(state_of_chum);
}
#endif

char* chum_get_current_song(){
cem_add_to_log(g_strdup_printf("get_current_song(). will return '%s'",current_song),LOG_DEBUG);
    return current_song;
}

const gchar *chum_get_song_folder( int i){
gchar *name =  (gchar *) g_list_nth_data(chum_get_all_songs(),i); //FIXME. now it checks it everytime in disk
return name;
}


/*
Always call this before gui_go_screen(SCREEN_PLAY_RECORDED);
*/
void chum_play_recorded_and_backing_track(){
    chum_stop_sequencer();
    /*
	if (sequencer) {
		g_object_unref(sequencer);
	}
    */
	sequencer = jammo_sequencer_new();

	backing_track = chum_create_new_empty_track(); //for comping track
    //gchar *filename = g_strdup_printf("%s/comping.ogg", song_folder);
    //printf("language is '%s'\n",selected_language);

    gchar *filename = g_strdup_printf("%s/songs/%s/comping%s.ogg", DATA_DIR,chum_get_current_song(),selected_language);
    int fd = open(filename,O_RDONLY);
    if (fd == -1) //File not found
     {
     filename = g_strdup_printf("%s/songs/%s/comping.ogg", DATA_DIR,chum_get_current_song()); //use without language postfix
     }

    chum_add_new_sample_to_track_nth_slot(backing_track, NULL,filename,0);
    g_free(filename);

    editing_track = chum_create_new_empty_track(); //for recorded singing
    chum_add_new_sample_to_track_nth_slot(editing_track,NULL,RECORDING_FILENAME,0);
    state_of_chum=SCREEN_PLAY_RECORDED;
}


void chum_change_to_song(const char *song_name){
  JammoSample* sample1;

    cem_add_to_log(g_strdup_printf("chum_change_to_song(%s)",song_name),LOG_DEBUG);
    current_song=song_name;

  if (sequencer) {
    g_object_unref(sequencer);
  }

  //printf("will make sample for file '%s'\n",filename);
  sequencer = jammo_sequencer_new();

   gchar *filename;
   int fd;
   if (duetto)
     {
     filename = g_strdup_printf("%s/songs/%s/vocal%s.ogg", DATA_DIR,song_name,selected_language);
     fd = open(filename,O_RDONLY);

     if (fd == -1) //File not found
       {  //no vocal track. use only comping.
       filename = g_strdup_printf("%s/songs/%s/comping.ogg", DATA_DIR,song_name); //try without language postfix
       }
     }
   else //solo
    {
    filename = g_strdup_printf("%s/songs/%s/comping%s.ogg", DATA_DIR,song_name,selected_language);
    fd = open(filename,O_RDONLY);
       if (fd == -1) //File not found
       {  //no track for this language,. use  common comping.
       filename = g_strdup_printf("%s/songs/%s/comping.ogg", DATA_DIR,song_name); //try without language postfix
       }
    }

  printf("looking for file '%s' \n",filename);
  backing_track = jammo_editing_track_new();   //for comping track
  jammo_sequencer_add_track(sequencer, JAMMO_TRACK(backing_track));

  sample1 = jammo_sample_new_from_file(filename);
  jammo_editing_track_add_sample(backing_track, sample1, 0);

  //Do not use pitch_detect on OFFICIAL_RELEASE (not robust enough)
  #ifdef OFFICIAL_RELEASE
  recording_track = jammo_recording_track_new(RECORDING_FILENAME);
  #else
  recording_track = jammo_recording_track_new_with_pitch_detect(RECORDING_FILENAME);
  #endif

  jammo_sequencer_add_track(sequencer, JAMMO_TRACK(recording_track));

  state_of_chum=SCREEN_SONG_RECORDING;
  g_free(filename);
  //gui_go_screen(state_of_chum);
}

void chum_stop_sequencer(){
    cem_add_to_log("chum_stop_sequencer()",LOG_DEBUG);
    jammo_sequencer_stop(sequencer);
}

void chum_play_sequencer(){
	
  //  chum_stop_sequencer();
    cem_add_to_log("chum_play_sequencer()",LOG_DEBUG);
//    gui_visualize_playing(state_of_chum);
	jammo_sequencer_play((JammoSequencer*)sequencer);
}

void chum_get_duration_of_song(guint64 *value) {
	*value = jammo_sequencer_get_duration(sequencer);
}

//FIX: implement this.
//void chum_pause_sequencer();


/*
srcLocation = Full path.

Reasons to call this:
-local sample add			(pass this to gems)
-local sample add to backing_track			(track==backing_track)
-remote sample add			(track!=editing_track)
-local singing game playback		(id==NULL)

*/
JammoSample* chum_add_new_sample_to_track(JammoEditingTrack* track,const gchar* id,  const gchar* srcLocation, guint64 startTime){
	JammoSample* sample;

    cem_add_to_log(g_strdup_printf("chum_add_new_sample_to_track(%s,%s,%" GST_TIME_FORMAT ")", id,srcLocation, GST_TIME_ARGS (startTime)),LOG_DEBUG);
	if (track==editing_track && id!=NULL)
		{
		//printf("pass to gems '%s'\n",id);
	   	gems_add_new_sample_to_track(0, id, startTime);
		}
	else if (track==backing_track)
		{
		printf("Added sample to backing_track\n");
		}
	else 
		{
		printf("Partner added sample\n");
		}
	sample = jammo_sample_new_from_file(srcLocation);
	jammo_editing_track_add_sample(track, sample, startTime);
	return sample;
}


/*
Wrapper
*/
JammoSample* chum_add_new_sample_to_track_nth_slot(JammoEditingTrack* track, const gchar* id, const gchar* srcLocation, guint slot){
return chum_add_new_sample_to_track(track, id, srcLocation, slot * GST_SECOND); /* TODO: Slot is one second now. */
}


#ifdef removed_temp
//THIS IS TEMPORARILY REMOVED. Because whole gui_clutter/*.c is removed.
JammoSample* chum_add_new_sample_to_track_remote(int a, const gchar* id, guint64 startTime){
cem_add_to_log(g_strdup_printf(" chum_add_new_sample_to_track_remote(%d,%s,%" GST_TIME_FORMAT ")",a, id,GST_TIME_ARGS (startTime)),LOG_DEBUG);
gchar* sound=object_add_to_timeline_remote(id,startTime);

gchar* buffer0;
buffer0 = g_strdup_printf("%s/themes/%s/%s",DATA_DIR,chum_get_theme_folder(chum_get_current_theme()), sound);
return chum_add_new_sample_to_track(editing_track_partner,id,buffer0,startTime);
}
#else
JammoSample* chum_add_new_sample_to_track_remote(int a, const gchar* id, guint64 startTime){
return NULL;
}
#endif

void chum_remove_sample_from_slot_remote(int a, int slot){
	chum_remove_sample_from_slot(editing_track_partner, slot);
}

void chum_remove_sample_from_slot(JammoEditingTrack* track, int slot){
	JammoSample* sample;

cem_add_to_log(g_strdup_printf("chum_remove_sample_from_slot(track=%p,slot=%d)",track,slot),LOG_DEBUG);
	if (track==editing_track)
		{
		gems_remove_sample_from_slot(1,slot);
		}
	else 
		printf("Partner removed sample\n");
	if ((sample = jammo_editing_track_get_sample(track, slot * GST_SECOND))) { /* TODO: Slot is one second now. */
		jammo_editing_track_remove_sample(track, sample);
	}
}

//FIX: we should not use fixed value
#define MAX_NUMBER_OF_THEMES 10
const gchar* theme_folders[MAX_NUMBER_OF_THEMES];

const gchar* chum_get_theme_folder(int index){
//cem_add_to_log(g_strdup_printf("chum_get_theme_folder(%d). we will return %s",index,theme_folders[index]),LOG_DEBUG);
    return theme_folders[index];
}


#ifdef removed
static int chum_count_themes(){
    g_return_val_if_fail(THEMES_DIR,-1);
    GError* error = NULL;
    GDir* dir = g_dir_open (THEMES_DIR, 0, &error);
    if (error) {
	g_warning ("g_dir_open() failed: %s\n", error->message);
	g_clear_error (&error);
	return -1;
    }

    int number_of_themes = 0;
    const gchar* filename = NULL;
    while ((filename = g_dir_read_name(dir))) {
	if (filename[0]!='.') { //do not count hidden files (folders)
	      number_of_themes++;
	      theme_folders[number_of_themes]=filename;
	}
   }
return number_of_themes;
}
#endif

void chum_get_all_slot_info(int track_number){
cem_add_to_log(g_strdup_printf("chum_get_all_slot_info(%d)",track_number),LOG_DEBUG);
//meam_get_all_slot_info(track_number);
}

void chum_add_instrument_track(int type) {
cem_add_to_log(g_strdup_printf("chum_add_instrument_track(%d)",type),LOG_DEBUG);
//meam_add_instrument_track(type);
}

void chum_state_of_note(gboolean state, char note){
cem_add_to_log(g_strdup_printf("chum_state_of_note(%d,%c)",state,note),LOG_DEBUG);
//meam_state_of_note( state,  note);
}

void chum_toggle_note(char note){
cem_add_to_log(g_strdup_printf("chum_toggle_note(%c)",note),LOG_DEBUG);
//meam_toggle_note(note);
}

void chum_toggle_note_on_octave(char note, int octave){
cem_add_to_log(g_strdup_printf("chum_toggle_note_on_octave(%c,%d)",note,octave),LOG_DEBUG);

jammo_instrument_track_set_and_play_note_realtime(instrument_track,note,octave);
//meam_toggle_note_on_octave(note,octave);
}

void chum_slider_freq(int a){
jammo_slider_track_set_frequency(slider_track,a);
}


void chum_slider_state(gboolean b){
jammo_slider_track_set_state(slider_track,b);
}

void chum_print_note_table(){
cem_add_to_log(g_strdup_printf("chum_print_note_table()"),LOG_DEBUG);
//meam_print_note_table();
}


void chum_octave_up() {
cem_add_to_log(g_strdup_printf("chum_octave_up()"),LOG_DEBUG);
//meam_octave_up();
}

void chum_octave_down(){
cem_add_to_log(g_strdup_printf("chum_octave_down()"),LOG_DEBUG);
//meam_octave_down();
}

GList* chum_get_all_songs(){
cem_add_to_log(g_strdup_printf("chum_get_all_songs()"),LOG_DEBUG);
return file_helper_get_all_songs();
}



guint chum_get_meter_of_track(int track_number){
guint meter=4; // meam_get_meter_of_track(track_number);
cem_add_to_log(g_strdup_printf("chum_get_meter_of_track(%d) [%u]",track_number,meter),LOG_DEBUG);
return meter;
}

guint chum_get_tempo_of_track(int track_number){
guint tempo=130; //meam_get_tempo_of_track(track_number);
cem_add_to_log(g_strdup_printf("chum_get_tempo_of_track(%d) [%u]",track_number,tempo),LOG_DEBUG);
return tempo;
}
